/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.jetty.OldNanoHandler;
import com.blixx.server.jetty.RedirectJettyLogger;
import com.blixx.server.jetty.ServerLoginService;
import com.blixx.server.jetty.ServerSecurityHandler;
import com.blixx.shared.BM;
import com.boom.crt.CertificateManager;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HostHeaderCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyMain {
    private static SessionHandler sessionHandler = null;
    public static SslContextFactory.Server sslContextFactory;

    public static void start(int port) throws Exception {
        Server server = new Server();
        Log.setLog((Logger)new RedirectJettyLogger());
        CertificateManager cm = ServerEngine.getInstance().getCertificateManager();
        if (cm.getKsClient() != null) {
            sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(cm.getKsClient().getKeyStorePath().toAbsolutePath().toString());
            sslContextFactory.setKeyStorePassword(new String(cm.getKsClient().getPwdArray()));
            sslContextFactory.setTrustStorePath(cm.getTsClient().getKeyStorePath().toAbsolutePath().toString());
            sslContextFactory.setTrustStorePassword(new String(cm.getTsClient().getPwdArray()));
            sslContextFactory.setRenegotiationAllowed(true);
            sslContextFactory.setExcludeCipherSuites(new String[]{"^.*_(MD5|SHA|SHA1)$"});
            sslContextFactory.addExcludeCipherSuites(new String[]{"^TLS_RSA_.*$"});
            sslContextFactory.addExcludeCipherSuites(new String[]{"^SSL_.*$"});
            sslContextFactory.addExcludeCipherSuites(new String[]{"^.*_NULL_.*$"});
            sslContextFactory.addExcludeCipherSuites(new String[]{"^.*_anon_.*$"});
            sslContextFactory.setIncludeProtocols(new String[]{"TLSv1.2"});
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            src.setSniHostCheck(false);
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
            httpConfig.addCustomizer((HttpConfiguration.Customizer)src);
            ServerConnector sslConnector = new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            sslConnector.setPort(port);
            sslConnector.setIdleTimeout(30000L);
            server.addConnector((Connector)sslConnector);
            RTLogger.print(1, "Jetty HTTPS started on port:" + port);
        } else {
            ServerConnector connector0 = new ServerConnector(server);
            connector0.setPort(port);
            connector0.setIdleTimeout(30000L);
            server.addConnector((Connector)connector0);
            RTLogger.print(1, "Jetty HTTP started on port:" + port);
        }
        if (!ServerEngine.getInstance().getServerProps().isDisableHttpUserAuth()) {
            ServerLoginService bls = new ServerLoginService();
            server.addBean((Object)bls);
            sessionHandler = new SessionHandler();
            sessionHandler.setMaxInactiveInterval(3600);
            sessionHandler.getSessionCookieConfig().setMaxAge(3600);
            sessionHandler.setRefreshCookieAge(600);
            sessionHandler.setHttpOnly(true);
            server.setHandler((Handler)sessionHandler);
            ServerSecurityHandler sh = new ServerSecurityHandler();
            sh.setCheckWelcomeFiles(false);
            FormAuthenticator formauth = new FormAuthenticator("/" + BM.PRODUCT_lowercase + "/login.html", "/" + BM.PRODUCT_lowercase + "/error.html", false);
            sh.setAuthenticator((Authenticator)formauth);
            sh.setIdentityService(bls);
            sh.setRealmName("BOOM");
            sessionHandler.setHandler((Handler)sh);
            OldNanoHandler oldNanoHandler = new OldNanoHandler();
            sh.setHandler((Handler)oldNanoHandler);
        } else {
            sessionHandler = new SessionHandler();
            sessionHandler.setHttpOnly(true);
            OldNanoHandler oldNanoHandler = new OldNanoHandler();
            sessionHandler.setHandler((Handler)oldNanoHandler);
            server.setHandler((Handler)sessionHandler);
        }
        server.setStopAtShutdown(true);
        JettyMain.disableSendingServerVersion(server);
        server.start();
    }

    public static SessionHandler getSessionHandler() {
        return sessionHandler;
    }

    public static void disableSendingServerVersion(Server server) {
        try {
            for (Connector y : server.getConnectors()) {
                for (ConnectionFactory x : y.getConnectionFactories()) {
                    if (!(x instanceof HttpConnectionFactory)) continue;
                    ((HttpConnectionFactory)x).getHttpConfiguration().setSendServerVersion(false);
                    ((HttpConnectionFactory)x).getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new HostHeaderCustomizer("localhost"));
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(3, "Warning:", e);
        }
    }
}

