/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.log.RTLogger;
import com.blixx.server.UserManager;
import com.blixx.server.jetty.UserPrincipal;
import com.blixx.shared.Cryptor;
import com.blixx.shared.UserRole;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.session.SessionHandler;

public class ServerSecurityHandler
extends SecurityHandler {
    public static final String BASIC = "Basic";
    public static final String BASIC_PREFIX = "Basic ";
    public static final String BEARER = "Bearer";
    public static final String BEARER_PREFIX = "Bearer ";
    public static final String P_USER = "_user";
    public static final String AUTHORIZATION = "Authorization";
    public static final String ACCESS_TOKEN = "Access-Token";
    private static final String CLAIM_SUBJECT = "sub";
    private static final String CLAIM_PREFERRED_USERNAME = "preferred_username";
    public static final String _USER = "_user";
    public static final String _PASS = "_pass";
    private final ConcurrentHashMap<String, UserPrincipal> cached = new ConcurrentHashMap();
    private static final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public ServerSecurityHandler() {
        scheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                ((ConcurrentHashMap.KeySetView)this.cached.keySet()).removeAll((Collection)this.cached.entrySet().stream().filter(en -> System.currentTimeMillis() > ((UserPrincipal)en.getValue()).getExpiresAt() + 10000L).map(Map.Entry::getKey).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                RTLogger.print(5, "", e);
            }
        }, 10L, 60L, TimeUnit.SECONDS);
    }

    protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, RoleInfo constraintInfo) throws IOException {
        return true;
    }

    protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) throws IOException {
        return true;
    }

    protected boolean isAuthMandatory(Request baseRequest, Response baseResponse, Object constraintInfo) {
        return true;
    }

    protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
        return new RoleInfo();
    }

    protected boolean checkSecurity(Request request) {
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String pathInfo = request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "");
        if (pathInfo.endsWith(".ico") || pathInfo.equals("/") || pathInfo.startsWith("/index.htm") || pathInfo.startsWith("/srv/html/") || pathInfo.startsWith("/deploy") || pathInfo.startsWith("/docs/") || pathInfo.startsWith("/comm/agent")) {
            return false;
        }
        if (pathInfo.equals("/validateSession")) {
            String answer = "{ \"status\" : 0 }";
            if (request.getSession().getAttribute("org.eclipse.jetty.security.UserIdentity") != null) {
                request.getResponse().setStatus(200);
            } else {
                request.getResponse().setStatus(406);
                answer = "{ \"status\" : 1 }";
            }
            try {
                request.getResponse().setContentType("application/json");
                request.getResponse().setContentLength(answer.length());
                request.getResponse().getOutputStream().write(answer.getBytes(), 0, answer.length());
                request.setHandled(true);
            }
            catch (IOException e) {
                RTLogger.print(4, "", e);
            }
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null || request.getSessionHandler().isValid(session)) {
            Authentication authentication;
            Authentication authentication2 = authentication = session == null ? null : (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                request.setAuthentication(authentication);
            } else if (this.basicAuthN(request)) {
                RTLogger.print(3, " user session authn - ok. %s", session);
            }
            return super.checkSecurity(request);
        }
        RTLogger.print(5, " -- chkSc request: {} session: {}", request, session);
        return super.checkSecurity(request);
    }

    protected boolean basicAuthN(Request request) {
        boolean isAuthenticated = false;
        String basicAuth = request.getHeader(AUTHORIZATION);
        if (basicAuth != null && basicAuth.startsWith(BASIC_PREFIX)) {
            String binHexStr = basicAuth.substring(BASIC_PREFIX.length());
            String up = new String(Base64.getDecoder().decode(binHexStr));
            String[] upArr = up.split(":", 2);
            String user = upArr[0];
            String pass = upArr[1];
            UserRole ur = UserManager.getInstance().checkUser(user, Cryptor.encrypt2(pass));
            if (ur != null) {
                this.setAuthenticated(request, BASIC, user, ur);
                isAuthenticated = true;
            }
        }
        return isAuthenticated;
    }

    protected void setAuthenticated(Request request, String authMethod, String user, UserRole ur) {
        SessionHandler sessionHandler = request.getSessionHandler();
        HttpSession session = request.getSession();
        if (session.isNew()) {
            UserAuthentication authentication = this.getAuthentication(authMethod, user, ur);
            RTLogger.print(2, "user: {} newSession: {}", user, session.getId());
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)authentication);
            request.setAuthentication((Authentication)authentication);
        } else {
            Object auth = session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (auth instanceof Authentication) {
                request.setAuthentication((Authentication)auth);
            } else {
                request.setAuthentication((Authentication)this.getAuthentication(authMethod, user, ur));
            }
        }
        HttpCookie cookie = sessionHandler.access(session, true);
        if (cookie != null) {
            request.getResponse().addCookie(cookie);
        }
    }

    protected UserAuthentication getAuthentication(String authMethod, String user, UserRole ur) {
        UserPrincipal principal = new UserPrincipal(user);
        Subject subj = new Subject();
        DefaultUserIdentity userIdentity = new DefaultUserIdentity(subj, (Principal)principal, new String[]{ur.getName()});
        return new UserAuthentication(authMethod, (UserIdentity)userIdentity);
    }
}

