/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty.json;

import com.blixx.server.AgentCard;
import com.blixx.server.cube.AgentCardStatusSummary;
import com.blixx.server.cube.Cube;
import com.blixx.shared.BM;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class AgentCardJson
implements JsonSerializer<AgentCard> {
    private static final String MAP = "@map:";

    @Override
    public JsonElement serialize(AgentCard ac, Type typeOfSrc, JsonSerializationContext context) {
        String[] dlines;
        String label;
        JsonObject obj = new JsonObject();
        obj.addProperty("id", ac.getAgentID());
        obj.addProperty("host", ac.getAgentHost());
        obj.addProperty("ip", ac.getAgentIP());
        boolean isOnline = ac.getMode() == 0 || ac.getMode() == 1 || ac.getMode() == 8;
        obj.addProperty("online", isOnline);
        int maxAV = 0;
        int maxKPI = 0;
        int maxOther = 0;
        int numAV = 0;
        int numKPI = 0;
        int numOther = 0;
        AgentCardStatusSummary acs = Cube.getInstance().getAgentCardStatusSummary(ac.getAgentID());
        if (acs != null) {
            maxAV = acs.getMaximumAV();
            maxKPI = acs.getMaximumKPI();
            maxOther = acs.getMaximumOther();
            numAV = acs.getNumberOfMessagesAV();
            numKPI = acs.getNumberOfMessagesKPI();
            numOther = acs.getNumberOfMessagesOther();
        }
        if ("".equals(label = ac.getLabel())) {
            label = ac.getAgentHost();
        }
        int numtotal = numAV + numKPI + numOther;
        int maxtotal = Math.max(Math.max(maxAV, maxKPI), maxOther);
        obj.addProperty("ind_total", numtotal);
        obj.addProperty("ind_av", numAV);
        obj.addProperty("ind_kpi", numKPI);
        obj.addProperty("ind_other", numOther);
        obj.addProperty("sev_total", maxtotal);
        obj.addProperty("sev_av", maxAV);
        obj.addProperty("sev_kpi", maxKPI);
        obj.addProperty("sev_other", maxOther);
        obj.addProperty("descr", ac.getDescription());
        obj.addProperty("label", label);
        obj.addProperty("port", ac.getAgentPort());
        String osName = "Unknown";
        try {
            osName = ac.getOSName();
            if (osName.contains("(BS:")) {
                osName = osName.substring(osName.lastIndexOf(41) + 1).trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        obj.addProperty("os", osName);
        obj.addProperty("outage", ac.getAgentOutage());
        obj.addProperty(BM.PRODUCT_lowercase + "srv", ac.getRelatedServer());
        obj.addProperty("flags", ac.getAgentFlags());
        obj.addProperty("lto", ac.getLastTimeOnline());
        obj.addProperty("disabled", ac.isDisabled());
        obj.addProperty("firewalled", ac.isFirewalled());
        obj.addProperty("http", ac.isHttpAgent());
        obj.addProperty("appr", ac.isApproved());
        obj.addProperty("allowed_send", ac.isAgentAllowsToSend());
        obj.addProperty("allowed_send_perf", ac.isAgentAllowsToSendPERF());
        for (String line : dlines = ac.getDescription().split("[\r\n]+")) {
            if (!(line = line.trim()).startsWith(MAP)) continue;
            try {
                String mapElement = line.substring(MAP.length()).trim();
                int eq = mapElement.indexOf(61);
                if (eq == -1) continue;
                String key = mapElement.substring(0, eq);
                String value = mapElement.substring(eq + 1);
                obj.addProperty(key, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return obj;
    }
}

