/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty.json;

import com.blixx.server.DeployClient;
import com.blixx.server.utils.DeployType;
import com.blixx.shared.DeploymentStatus;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.lang.reflect.Type;
import java.util.LinkedList;

public class DeployClientJson
implements JsonSerializer<DeployClient> {
    @Override
    public JsonElement serialize(DeployClient dc, Type typeOfSrc, JsonSerializationContext context) {
        LinkedList<String> fileNames = new LinkedList<String>();
        if (DeployType.UNDEPLOY_POLICIES == dc.getType()) {
            for (String monPolicy : dc.getMonitors()) {
                fileNames.add(monPolicy + ".mon.xml");
            }
            for (String monPolicy : dc.getMessages()) {
                fileNames.add(monPolicy + ".msg.xml");
            }
        } else {
            for (File f : dc.getFiles()) {
                fileNames.add(f.getName());
            }
        }
        DeploymentStatus ds = new DeploymentStatus(dc.getID(), dc.getAgentCard().getAgentID(), dc.getInitTime(), dc.getExpireTime(), dc.getType().toString(), dc.getState());
        ds.setFileNames(fileNames);
        return ds.getJson();
    }
}

