/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty.json;

import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.ext.TimeMask;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OutagePolicyJson
implements JsonSerializer<OutagePolicy> {
    @Override
    public JsonElement serialize(OutagePolicy sp, Type typeOfSrc, JsonSerializationContext context) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JsonObject pr = new JsonObject();
        pr.addProperty("ID", sp.getID());
        pr.addProperty("NAME", sp.getName());
        pr.addProperty("EXPECTED_DURATION", "" + sp.getExpectedDuration());
        pr.addProperty("ENT", "" + sp.getIsEnableTime());
        pr.addProperty("IET", "" + sp.getIsEndTime());
        pr.addProperty("ACTION", ServerPolicyTemplate.getActionLabel(sp.getAction()));
        pr.addProperty("POSTACTION", ServerPolicyTemplate.getActionLabel(sp.getPostAction()));
        pr.addProperty("DESCRIPTION", sp.getDescription());
        pr.addProperty("ENABLED", "" + sp.isEnabled());
        pr.addProperty("ENABLEDBY", sp.getEnabledBy());
        pr.addProperty("OWNER", sp.getOwner());
        pr.addProperty("DISABLEDDBY", sp.getDisabledBy());
        if (sp.getTimeInterval() != null) {
            pr.addProperty("TI_FT", sdf.format(new Date(sp.getTimeInterval().getFirstStart())));
            pr.addProperty("TI_INTERVAL", "" + sp.getTimeInterval().getInterval());
            TimeMask timeMask = sp.getTimeInterval().getTimeMask();
            if (timeMask != null && timeMask.getMask() != null && timeMask.getMask().length() > 10) {
                pr.addProperty("TI_MASK", timeMask.getMask());
            }
        }
        pr.add("FILTERS", context.serialize(sp.getFilters()));
        return pr;
    }
}

