/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty.json;

import com.blixx.server.ServerEngine;
import com.blixx.server.jetty.json.SEventShortJson;
import com.blixx.shared.Annotation;
import com.blixx.shared.SEventFwd;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SEventFwdJson
extends SEventShortJson {
    public static Map<String, Object> customAttributeNames = new HashMap<String, Object>();

    @Override
    public JsonElement serialize(SEventFwd src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = (JsonObject)super.serialize(src, typeOfSrc, context);
        obj.addProperty("tfa", src.getTFA());
        obj.addProperty("vfa", src.getVFA());
        obj.addProperty("monitor", src.getMonitor());
        obj.addProperty("value", src.getValue());
        obj.addProperty("ftime", src.getFirstTime());
        obj.addProperty("policysource", src.getSource());
        obj.addProperty("owner", src.getT5());
        obj.addProperty("key", src.getKeyConfigured());
        obj.addProperty("closemask", src.getCloseMask());
        obj.addProperty("oaction", src.getOpAction());
        obj.addProperty("aaction", src.getAutoAction());
        obj.addProperty("aactionnode", src.getAutoActionNode());
        obj.addProperty("aactionflag", src.getAutoActionFlag());
        obj.addProperty("adviceid", src.getInstructionID());
        String helpText = ServerEngine.getInstance().getPolicyRepository().getHelps().get(src.getInstructionID());
        obj.addProperty("advice", helpText == null ? "" : helpText);
        obj.addProperty("instruction_url", src.getT3());
        List<String> annot = ServerEngine.getInstance().getEventsRouter().getAnnotations(src.getID());
        boolean isAnnotation = annot.size() > 1;
        obj.addProperty("annoflag", isAnnotation);
        JsonArray annotArr = new JsonArray();
        for (String anno : annot) {
            Annotation an = Annotation.parseString(anno);
            JsonObject anJs = new JsonObject();
            anJs.addProperty("time", an.getTime());
            anJs.addProperty("flag", an.getStatus());
            anJs.addProperty("text", an.getText());
            annotArr.add(anJs);
        }
        obj.add("annotations", annotArr);
        JsonArray caArr = new JsonArray();
        for (Map.Entry<String, String> en : src.m_CustomAttributes.entrySet()) {
            if (!customAttributeNames.containsKey(en.getKey()) || en.getKey() == null || en.getValue() == null || en.getValue().length() <= 0) continue;
            JsonObject ca = new JsonObject();
            ca.addProperty(en.getKey().toLowerCase(), en.getValue());
            caArr.add(ca);
        }
        obj.add("cas", caArr);
        return obj;
    }

    static {
        customAttributeNames.put("CA1", null);
        customAttributeNames.put("CA2", null);
        customAttributeNames.put("CA3", null);
        customAttributeNames.put("CA4", null);
        customAttributeNames.put("CA5", null);
        customAttributeNames.put("CA6", null);
        customAttributeNames.put("CA7", null);
        customAttributeNames.put("CA8", null);
        customAttributeNames.put("CA9", null);
        customAttributeNames.put("CA10", null);
        customAttributeNames.put("CA11", null);
        customAttributeNames.put("CA12", null);
        customAttributeNames.put("CA13", null);
        customAttributeNames.put("CA14", null);
        customAttributeNames.put("CA15", null);
    }
}

