/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.TooOldFiles;
import com.blixx.shared.BM;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractExportJob
extends ServerJob {
    public String GROUP;
    protected static final String YYYY_DD_MM_HH_MM_SS = "yyyy-dd-MM-HH-mm-ss";
    public static final String ATTR_FILE_MASK_DATE_FORMAT = "fileMaskDateFormat";
    public static final String ATTR_FILE_MASK = "fileMask";
    public static final String ATTR_WORKING_DIR = "workingDir";
    public static final String ATTR_KEEPFILES_DAYS = "keepFilesDays";
    public static final String ATTR_EXPORT_NORMAL_ONLINE = "exportNormalOnline";
    public static final String ATTR_EXPORT_NORMAL_OFFLINE = "exportNormalOffline";
    public static final String ATTR_EXPORT_EXTERNAL_ONLINE = "exportExternalOnline";
    public static final String ATTR_EXPORT_EXTERNAL_OFFLINE = "exportExternalOffline";
    public static final String $DATE = "<$DATE>";
    protected String m_fileMask = BM.PRODUCT_lowercase + "_<$DATE>.csv";
    protected String m_fileMaskDateFormat = "yyyy-dd-MM-HH-mm-ss";
    protected String m_workingdir = "srv/jobs/cmdbexport";
    protected File m_dir;
    protected int keepFilesDays = 7;
    protected boolean m_exportNormalOnline = true;
    protected boolean m_exportNormalOffline = true;
    protected boolean m_exportExternalOnline = true;
    protected boolean m_exportExternalOffline = true;
    protected SALogger m_logger = new SALogger();
    public String m_lastResult = "-";

    public AbstractExportJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        this.initLogfile();
        this.printValues();
        this.m_logger.print(2, String.valueOf(this.getClass()));
        this.m_logger.print(1, "init done");
        return true;
    }

    @Override
    public boolean onStartRun() {
        this.m_logger.print(1, "job started AgentExport");
        try {
            try {
                if (!this.m_dir.exists()) {
                    this.m_dir.mkdirs();
                    this.initLogfile();
                    this.printValues();
                    this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
                } else {
                    this.m_logger.print(3, "directory exist. " + this.m_dir.getCanonicalPath());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            File[] to_delete = this.m_dir.listFiles(new TooOldFiles(this.keepFilesDays, null, ".csv"));
            this.m_logger.print(3, "old files to delete: " + to_delete.length);
            for (int i = 0; i < to_delete.length; ++i) {
                try {
                    if (to_delete[i].delete()) continue;
                    this.m_logger.print(1, ERROR + "can't delete old file: " + String.valueOf(to_delete[i]));
                    continue;
                }
                catch (Throwable e) {
                    this.m_logger.print(1, ERROR + "can't delete old file: " + String.valueOf(to_delete[i]), e);
                }
            }
        }
        catch (Throwable e) {
            this.m_logger.print(3, "", e);
        }
        return super.onStartRun();
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    public void initVariables() throws Exception {
        String value;
        CheckAttribute ac;
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(this.GROUP);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_WORKING_DIR);
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.m_workingdir = aa.getValue();
        this.m_dir = new File(this.m_workingdir);
        if (!this.m_dir.exists()) {
            this.m_dir.mkdirs();
            this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK)) == null) {
            throw new InvalidConfig("fileMask is null");
        }
        this.m_fileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK_DATE_FORMAT);
        if (aa == null) {
            throw new InvalidConfig("fileMaskDateFormat is null");
        }
        try {
            new SimpleDateFormat(aa.getValue());
            this.m_fileMaskDateFormat = aa.getValue();
        }
        catch (Throwable e) {
            this.m_logger.print(1, ERROR + "unsupported fileMaskDateFormat" + aa.getValue());
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_KEEPFILES_DAYS);
        if (aa != null) {
            try {
                this.keepFilesDays = Integer.parseInt(aa.getValue());
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: keepFilesDays");
            }
        }
        if ((ac = (CheckAttribute)specificJobConfig.getAttribute(ATTR_EXPORT_NORMAL_ONLINE)) != null) {
            value = "" + ac.getValue();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.m_exportNormalOnline = ac.getValue();
            } else {
                this.m_logger.print(1, ERROR + "invalid value for attribute: exportNormalOnline");
            }
        } else {
            specificJobConfig.addAttribute(new CheckAttribute(ATTR_EXPORT_NORMAL_ONLINE, this.m_exportNormalOnline, "Export online Agents"));
        }
        ac = (CheckAttribute)specificJobConfig.getAttribute(ATTR_EXPORT_NORMAL_OFFLINE);
        if (ac != null) {
            value = "" + ac.getValue();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.m_exportNormalOffline = ac.getValue();
            } else {
                this.m_logger.print(1, ERROR + "invalid value for attribute: exportNormalOffline");
            }
        } else {
            specificJobConfig.addAttribute(new CheckAttribute(ATTR_EXPORT_NORMAL_OFFLINE, this.m_exportNormalOffline, "Export offline Agents"));
        }
        ac = (CheckAttribute)specificJobConfig.getAttribute(ATTR_EXPORT_EXTERNAL_ONLINE);
        if (ac != null) {
            value = "" + ac.getValue();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.m_exportExternalOnline = ac.getValue();
            } else {
                this.m_logger.print(1, ERROR + "invalid value for attribute: exportExternalOnline");
            }
        } else {
            specificJobConfig.addAttribute(new CheckAttribute(ATTR_EXPORT_EXTERNAL_ONLINE, this.m_exportExternalOnline, "Export online Hosts"));
        }
        ac = (CheckAttribute)specificJobConfig.getAttribute(ATTR_EXPORT_EXTERNAL_OFFLINE);
        if (ac != null) {
            value = "" + ac.getValue();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.m_exportExternalOffline = ac.getValue();
            } else {
                this.m_logger.print(1, ERROR + "invalid value for attribute: exportExternalOffline");
            }
        } else {
            specificJobConfig.addAttribute(new CheckAttribute(ATTR_EXPORT_EXTERNAL_OFFLINE, this.m_exportExternalOffline, "Export offline Hosts"));
        }
    }

    public boolean isSelectedToExport(AgentCard ac) {
        return this.m_exportNormalOnline && ac.getAgentPort() != 0 && ac.isOnline() || this.m_exportNormalOffline && ac.getAgentPort() != 0 && !ac.isOnline() || this.m_exportExternalOnline && ac.getAgentPort() == 0 && ac.isOnline() || this.m_exportExternalOffline && ac.getAgentPort() == 0 && !ac.isOnline();
    }

    public void initLogfile() {
        this.m_logger.setMaxCount(super.getJobConfig().getLogcount());
        this.m_logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.m_logger.setDir(this.m_workingdir, "agentexport");
        this.m_logger.setLevel(super.getJobConfig().getLoglevel());
    }

    private void printValues() {
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.m_logger.print(1, "keepFilesDays: " + this.keepFilesDays);
        this.m_logger.print(1, "filemask: " + this.m_fileMask);
        this.m_logger.print(1, "filemask Date format: " + this.m_fileMaskDateFormat);
        this.m_logger.print(1, "export agents online: " + this.m_exportNormalOnline);
        this.m_logger.print(1, "export agents offline: " + this.m_exportNormalOffline);
        this.m_logger.print(1, "export external online: " + this.m_exportExternalOnline);
        this.m_logger.print(1, "export external offline: " + this.m_exportExternalOffline);
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        JobConfig bkp = this.m_config;
        try {
            super.setJobConfig(config);
            this.onInit();
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR + "Error processing new configuration. Rollback.");
            try {
                super.setJobConfig(bkp);
                this.onInit();
            }
            catch (Throwable e1) {
                this.m_logger.print(1, ERROR + "Rollback failed");
            }
            throw new InvalidConfig(e);
        }
    }

    public String getFileMaskDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_DD_MM_HH_MM_SS);
        try {
            sdf = new SimpleDateFormat(this.m_fileMaskDateFormat);
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR + "date format is wrong: " + this.m_fileMaskDateFormat, e);
        }
        return sdf.format(date);
    }

    public String getFilename(Date time) {
        String res = this.m_fileMask.replace($DATE, this.getFileMaskDate(time));
        res = res.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
        return res;
    }

    public File getFile(Date time) {
        String filename = this.getFilename(time);
        return new File(this.m_dir, filename);
    }
}

