/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.jobs.ActiveDirectoryConnector;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.MapAttribute;
import com.blixx.shared.jobs.PasswordAttribute;
import com.blixx.shared.jobs.TextAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;

public class ActiveDirectorySyncJob
extends ServerJob {
    private Map<String, String> groupMapping = new LinkedHashMap<String, String>();
    private Set<String> processedUser = new HashSet<String>();
    private ActiveDirectoryConnector connector;
    private UserManager userManager = UserManager.getInstance();
    private static final String LDAP_PASS = "LDAP_PASS";
    private static final String LDAP_USER = "LDAP_USER";
    private static final String LDAP_URL = "LDAP_URL";
    private static final String LDAP_BASE = "LDAP_BASE";
    private static final String LDAP_SEARCH_BASE = "LDAP_SEARCH_BASE";
    private static final String LDAP_AUTHENTICATION = "Simple";
    private static final String LDAP_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String GROUP_CONN = "CONNECTION";
    private static final String USER_GROUP_MAP = "USER-GROUP-MAPPING";
    private static final String GROUPS = "GROUPS";
    public static final String LDAP2 = "LDAP";
    private String ldapBase = "";
    private String ldapSearchBase = "";
    private String ldapUsername = "";
    private String ldapPassword = "";
    private String ldapUrl = "";
    private String ldapUserAttributes = "";
    private StringBuilder lastResult = new StringBuilder();

    public ActiveDirectorySyncJob(JobConfig config) throws Exception {
        super(config);
    }

    public ActiveDirectoryConnector getConnector() throws AuthenticationException {
        Hashtable<String, String> env = this.getEnvironmentForAD();
        this.connector = new ActiveDirectoryConnector(env);
        return this.connector;
    }

    public Map<String, String> getGroupMapping() {
        return this.groupMapping;
    }

    public void setGroupMapping(Map<String, String> groupMapping) {
        this.groupMapping = groupMapping;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        try {
            this.initVariables();
        }
        catch (Exception e) {
            throw new InvalidConfig(e.getMessage());
        }
    }

    @Override
    public boolean onStartRun() {
        this.processedUser.clear();
        this.lastResult = new StringBuilder();
        return super.onStartRun();
    }

    @Override
    public boolean onStopRun() {
        this.processedUser.clear();
        RTLogger.print(3, "Job finished: %s", this.getName());
        return super.onStopRun();
    }

    @Override
    public boolean onGetData() {
        if (this.getGroupMapping().size() == 0) {
            this.lastResult.append("No User Group mapping configured.");
        }
        for (Map.Entry<String, String> entry : this.getGroupMapping().entrySet()) {
            try {
                String ldapUserGroupName = entry.getValue();
                String boomRoleName = entry.getKey();
                RTLogger.print(3, "Start sync AD group: " + ldapUserGroupName + " to boom group: " + boomRoleName);
                ArrayList<User> adUserList = new ArrayList();
                List<Object> boomUserList = new ArrayList();
                if (null == ldapUserGroupName || "".equals(ldapUserGroupName) || null == boomRoleName || "".equals(boomRoleName)) {
                    String msg = String.format("Skipped incomplete mapping. BoomUserRole:'%s' / ADUserGroup: '%s'.", boomRoleName, ldapUserGroupName);
                    RTLogger.print(3, msg);
                    this.lastResult.append(msg).append('\n');
                    continue;
                }
                adUserList = this.getLdapUsers(ldapUserGroupName, this.ldapSearchBase, this.lastResult);
                boomUserList = this.getBoomUsers(boomRoleName);
                if (null != adUserList && boomUserList == null) {
                    this.lastResult.append(this.createBoomUserGroupWithUser(adUserList, boomRoleName));
                    boomUserList = this.getBoomUsers(boomRoleName);
                }
                if (adUserList != null) {
                    this.processSync(adUserList, boomUserList, boomRoleName);
                    try {
                        Object usr2;
                        boomUserList = this.getBoomUsers(boomRoleName);
                        ArrayList<String> boomUserNames = new ArrayList<String>(boomUserList.size());
                        for (Object usr2 : boomUserList) {
                            boomUserNames.add(((User)usr2).getLoginName());
                        }
                        ArrayList<String> adUserNames = new ArrayList<String>(adUserList.size());
                        usr2 = adUserList.iterator();
                        while (usr2.hasNext()) {
                            User usr3 = (User)usr2.next();
                            adUserNames.add(usr3.getLoginName());
                        }
                        boomUserNames.removeAll(adUserNames);
                        if (!boomUserNames.isEmpty()) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append(boomRoleName).append(" is sync-ed. Users: ").append(adUserNames.size()).append('\n');
                        this.lastResult.append((CharSequence)sb);
                        RTLogger.print(3, sb);
                    }
                    catch (Exception e) {
                        RTLogger.print(3, this.getName(), e);
                    }
                    continue;
                }
                RTLogger.print(3, "AD group '%s' not found", ldapUserGroupName);
            }
            catch (Exception e) {
                this.lastResult.append("Job has been interrupted. Error ").append(e.getMessage());
                RTLogger.print(3, this.getName() + " - job has been interrupted", e);
                return false;
            }
        }
        return true;
    }

    public String createBoomUserGroupWithUser(List<User> users, String roleName) {
        StringBuilder result = new StringBuilder();
        UserRole role = this.userManager.getRoleByName(roleName);
        if (role == null) {
            role = UserRole.createNewRole();
            role.setName(roleName);
            this.userManager.ensureAllRightsAssigned(role);
            this.userManager.saveRole(role, true);
            result.append("User Role: ").append(roleName).append(" created.\n\n");
        }
        for (User usr : users) {
            if (this.userManager.getUser(usr.getLoginName()) == null) {
                User us = User.createNewUser();
                us.setActive(1);
                us.setLoginName(usr.getLoginName());
                us.setRoleID(role.getID());
                us.setRoleName(role.getName());
                us.setFirstName(usr.getFirstName());
                us.setLastName(usr.getLastName());
                us.setEmail(usr.getEmail());
                us.setPhone(usr.getPhone());
                us.setEncryptedPwd(LDAP2);
                result.append('[').append(us.getLoginName()).append("] --- ");
                this.userManager.saveUser(us);
                result.append("User stored.\n");
                continue;
            }
            result.append('[').append(usr.getEmail()).append("] --- already exist. Skipped.\n");
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_USERS");
        return result.toString();
    }

    public void processSync(List<User> adUserList, List<User> boomUserList, String roleName) {
        ArrayList<String> adUserLoginName = new ArrayList<String>();
        ArrayList<String> originalBoomUserLoginName = new ArrayList<String>();
        for (User adUser : adUserList) {
            adUserLoginName.add(adUser.getLoginName());
        }
        for (User boomUser : boomUserList) {
            originalBoomUserLoginName.add(boomUser.getLoginName());
        }
        ArrayList<String> usersToDelete = new ArrayList<String>(originalBoomUserLoginName);
        usersToDelete.removeAll(adUserLoginName);
        this.processUser(usersToDelete, adUserList, originalBoomUserLoginName, roleName);
    }

    private void processUser(List<String> usersToDelete, List<User> adUserList, List<String> originalBoomUserLoginName, String roleName) {
        for (String userName : usersToDelete) {
            User boomUser = this.userManager.getUser(userName);
            this.userManager.deleteUser(boomUser);
            this.processedUser.remove(userName);
            String output = String.format("User: %s deleted from the group: %s.", userName, roleName);
            this.lastResult.append(output).append("\n");
            RTLogger.print(3, output);
        }
        for (User adUser : adUserList) {
            String usr = adUser.getLoginName();
            User boomUser = this.userManager.getUser(usr);
            if (originalBoomUserLoginName.contains(usr)) {
                String phone;
                String email;
                String lName;
                String fName;
                this.processedUser.add(usr);
                boolean isChanged = false;
                String string = fName = adUser.getFirstName() == null ? "" : adUser.getFirstName();
                if (!boomUser.getFirstName().equals(fName)) {
                    boomUser.setFirstName(fName);
                    isChanged = true;
                }
                String string2 = lName = adUser.getLastName() == null ? "" : adUser.getLastName();
                if (!boomUser.getLastName().equals(lName)) {
                    boomUser.setLastName(lName);
                    isChanged = true;
                }
                String string3 = email = adUser.getEmail() == null ? "" : adUser.getEmail();
                if (!boomUser.getEmail().equals(email)) {
                    boomUser.setEmail(email);
                    isChanged = true;
                }
                String string4 = phone = adUser.getPhone() == null ? "" : adUser.getPhone();
                if (!boomUser.getPhone().equals(phone)) {
                    boomUser.setPhone(phone);
                    isChanged = true;
                }
                if (!isChanged) continue;
                this.userManager.saveUser(boomUser);
                String output = String.format("Attributes updated for User: %s.", usr);
                RTLogger.print(3, output);
                continue;
            }
            if (!this.processedUser.contains(usr)) {
                if (boomUser != null) {
                    this.userManager.deleteUser(boomUser);
                    String output = String.format("non-ldap boom user: %s is deleted and will be replaced with LDAP user.", usr);
                    RTLogger.print(3, output);
                }
                boomUser = User.createNewUser();
                boomUser.setEncryptedPwd(LDAP2);
                boomUser.setLoginName(usr);
                if (adUser.getFirstName() != null) {
                    boomUser.setFirstName(adUser.getFirstName());
                }
                if (adUser.getRoleName() != null) {
                    boomUser.setRoleName(roleName);
                }
                if (adUser.getLastName() != null) {
                    boomUser.setLastName(adUser.getLastName());
                }
                if (adUser.getEmail() != null) {
                    boomUser.setEmail(adUser.getEmail());
                }
                if (adUser.getPhone() != null) {
                    boomUser.setPhone(adUser.getPhone());
                }
                this.userManager.saveUser(boomUser);
                this.processedUser.add(usr);
                String output = String.format("Added %s to Boom user group : %s", usr, roleName);
                this.lastResult.append(output).append("\n");
                RTLogger.print(3, output);
                continue;
            }
            String output = String.format("Already sync-ed user: %s also mapped in the group:  %s. Skipped.", usr, roleName);
            this.lastResult.append(output).append("\n");
            RTLogger.print(3, output);
        }
    }

    public List<User> getLdapUsers(String ldapUserGroupName, String searchBase, StringBuilder lastResult) throws Exception {
        return this.getConnector().getUsersByGroupName(ldapUserGroupName, searchBase, lastResult);
    }

    public List<User> getBoomUsers(String roleName) {
        List<User> boomUserList = null;
        UserRole role = this.userManager.getRoleByName(roleName);
        if (null != role) {
            boomUserList = this.userManager.getUsers(role.getID());
            boomUserList.removeIf(u -> !LDAP2.equals(u.getEncryptedPwd()));
        }
        return boomUserList;
    }

    public Hashtable<String, String> getEnvironmentForAD() throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        this.userManager.prepareLdapEnvironment(env, this.ldapUsername, this.ldapPassword, this.ldapUrl, this.ldapBase, this.ldapUserAttributes, LDAP_AUTHENTICATION, LDAP_FACTORY);
        return env;
    }

    @Override
    public String getLastRunResult() {
        return this.lastResult.toString();
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        return true;
    }

    private void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_CONN);
        this.processedUser = new HashSet<String>();
        this.lastResult = new StringBuilder();
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(LDAP_BASE);
        if (aa == null) {
            throw new InvalidConfig("LDAP_BASE is null");
        }
        this.ldapBase = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(LDAP_SEARCH_BASE);
        if (aa == null) {
            throw new InvalidConfig("LDAP_SEARCH_BASE is null");
        }
        this.ldapSearchBase = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(LDAP_URL);
        if (aa == null) {
            throw new InvalidConfig("LDAP_URL is null");
        }
        this.ldapUrl = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(LDAP_USER);
        if (aa == null) {
            throw new InvalidConfig("LDAP_USER is null");
        }
        this.ldapUsername = aa.getValue();
        PasswordAttribute pa = (PasswordAttribute)specificJobConfig.getAttribute(LDAP_PASS);
        if (pa == null) {
            throw new InvalidConfig("LDAP_PASS is null");
        }
        this.ldapPassword = pa.getValue();
        specificJobConfig = jc.getConfig().getGroup(USER_GROUP_MAP);
        MapAttribute ma = (MapAttribute)specificJobConfig.getAttribute(GROUPS);
        for (Map.Entry entry : ma.getValue().entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.groupMapping.put(name, value);
        }
    }
}

