/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.AbstractExportJob;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.jobs.JobConfig;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;

public class AgentExport
extends AbstractExportJob {
    public static final String GROUP_AGENTS = "AGENTS";

    public AgentExport(JobConfig config) throws Exception {
        super(config);
        this.GROUP = GROUP_AGENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        this.m_logger.print(3, "starting...");
        File outFile = null;
        PrintWriter pw = null;
        try {
            outFile = this.getFile(new Date());
            pw = new PrintWriter(outFile);
            String header = "AGENT_ID;LABEL;HOSTNAME;PORT;IP;OS;ONLINE;APPROVED;ENABLED;EXTERNAL";
            pw.println(header);
            if (this.m_exportNormalOnline || this.m_exportNormalOffline || this.m_exportExternalOnline || this.m_exportExternalOffline) {
                for (Map.Entry<String, AgentCard> en : ServerEngine.getInstance().getAgentRepository().getAgentCards().entrySet()) {
                    AgentCard ac = en.getValue();
                    boolean doExport = ac.isApproved() && this.isSelectedToExport(ac);
                    if (!doExport) continue;
                    this.m_logger.print(3, "processing " + ac.getAgentHost());
                    try {
                        StringBuilder sb = new StringBuilder();
                        sb.append('\"').append(ac.getAgentID()).append('\"').append(';').append('\"').append(ac.getLabel()).append('\"').append(';').append('\"').append(ac.getAgentHost()).append('\"').append(';').append('\"').append(ac.getAgentPort()).append('\"').append(';').append('\"').append(ac.getAgentIP()).append('\"').append(';');
                        this.appendOS(ac, sb);
                        switch (ac.getMode()) {
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                sb.append('\"').append("N").append('\"').append(';');
                                break;
                            }
                            default: {
                                sb.append('\"').append("Y").append('\"').append(';');
                            }
                        }
                        if (!ac.isApproved()) {
                            sb.append('\"').append("N").append('\"').append(';');
                        } else {
                            sb.append('\"').append("Y").append('\"').append(';');
                        }
                        sb.append('\"').append(ac.isDisabled() ? "N" : "Y").append('\"');
                        sb.append('\"').append(ac.getAgentPort() == 0 ? "Y" : "N").append('\"');
                        pw.println(sb.toString());
                    }
                    catch (Throwable e) {
                        this.m_logger.print(1, ERROR + "Error occurred during processing " + ac.getAgentHost() + " (" + ac.getAgentIP() + ")");
                        this.m_logger.print(1, ERROR + String.valueOf(ac), e);
                    }
                }
            }
            this.m_lastResult = "Output file: " + outFile.getName();
            this.m_logger.print(2, "Output file: " + outFile.getName());
            this.m_logger.print(1, SUCCESS + "job finished AgentExport");
        }
        catch (Throwable e) {
            this.m_lastResult = "Error " + e.getMessage();
            if (outFile != null) {
                this.m_logger.print(1, ERROR + "Error creating output file " + outFile.getName());
            }
            this.m_logger.print(1, ERROR, e);
            this.m_logger.print(1, FAILED + "job finished AgentExport");
        }
        finally {
            try {
                pw.close();
            }
            catch (Throwable header) {}
        }
        return true;
    }

    private void appendOS(AgentCard ac, StringBuilder sb) {
        AgentInventoryCard aci = ac.getAgentInventoryCard();
        if (aci != null && aci.isDiscovered()) {
            String osVersion;
            String osName;
            String osArch = aci.getAttribute(AgentInventoryCard.getPath("OS.ARCH"));
            if (osArch == null) {
                osArch = "";
            }
            if ((osName = aci.getAttribute(AgentInventoryCard.getPath("OS.NAME"))) == null) {
                osName = "";
            }
            if ((osVersion = aci.getAttribute(AgentInventoryCard.getPath("OS.VERSION"))) == null) {
                osVersion = "";
            }
            StringBuffer os = new StringBuffer();
            os.append(osName).append(' ').append(osVersion).append(' ').append(osArch);
            String osComplete = os.toString().trim();
            if (osComplete.length() > 0) {
                osComplete = osComplete.replace(';', '_');
                sb.append('\"').append(osComplete).append('\"');
            }
            sb.append(';');
        } else {
            try {
                String osFromField = ac.getOSName();
                if (osFromField != null && osFromField.indexOf(41) != -1) {
                    osFromField = osFromField.substring(osFromField.lastIndexOf(41) + 1).trim();
                }
                if (osFromField == null || "_External".equalsIgnoreCase(osFromField)) {
                    osFromField = "";
                }
                sb.append('\"').append(osFromField.trim()).append('\"').append(';');
            }
            catch (Throwable e) {
                sb.append(';');
            }
        }
    }
}

