/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.EventOperations;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.ServerJobManager;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.SupportedVariablesS;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.MapAttribute;
import com.blixx.shared.jobs.TextAttribute;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AutoArchiveJobFiltered
extends ServerJob {
    public static String PATTERNS = "PATTERNS";
    public static String FILTER_MAP = "FILTER_MAP";
    public static final String MAXDAYS = "MAXDAYS";
    public static final String MAXHOURS = "MAXHOURS";
    public static final String MAXMINUTES = "MAXMINUTES";
    protected static final int m_maxHoursDefault = 1440;
    protected static final int m_maxMinutesDefault = 0;
    public int m_maxHours = 1440;
    protected int maxMinutes = 0;
    public String m_lastResult = "-";
    public Map<String, Pattern> m_patterns = new LinkedHashMap<String, Pattern>();

    public AutoArchiveJobFiltered(JobConfig config) throws Exception {
        super(config);
        if (config.getJobGroup().getAttribute(MAXMINUTES) == null) {
            config.getJobGroup().addAttribute(new TextAttribute(MAXMINUTES, "0", "additional max minutes"));
        }
    }

    @Override
    public boolean onGetData() {
        RTLogger.print(4, "AutoArchiveJobFiltered: Start " + this.getName());
        if (this.m_patterns.size() == 0) {
            RTLogger.print(3, "AutoArchiveJobFiltered: No patterns found. Task run skipped.");
        }
        StringBuilder resultBuilder = new StringBuilder();
        try {
            long time = 0L;
            if (this.m_maxHours >= 0) {
                time = System.currentTimeMillis() - (long)this.m_maxHours * 3600000L - (long)this.maxMinutes * 60000L;
            }
            for (Map.Entry<String, Pattern> entry : this.m_patterns.entrySet()) {
                String vars = entry.getKey();
                Pattern pattern = entry.getValue();
                LinkedList<String> idToArchive = new LinkedList<String>();
                EventOperations EO = ServerEngine.getInstance().getEventsRouter().getEventOperations();
                for (SEventFwd se : EO.getAllClosed()) {
                    String result;
                    if (this.m_maxHours > 0 && se.getSTime() > time || !pattern.matcher(result = SupportedVariablesS.prepareString(se, vars)).matches()) continue;
                    idToArchive.add(se.getID());
                }
                int size = idToArchive.size();
                if (idToArchive.size() > 0) {
                    ServerEngine.getInstance().getEventsRouter().archive2(idToArchive, false);
                    RTLogger.print(4, "AutoArchiveJobFiltered: Auto archived " + size);
                    List<SlaveServerCard> slaves = ServerEngine.getInstance().getSlaves();
                    for (SlaveServerCard ssc : slaves) {
                        if (ssc.getScenario() == 0) {
                            ssc.getServerClient().start("DELETE_MSG", null, idToArchive.toArray(new String[0]));
                            continue;
                        }
                        if (ssc.getScenario() > 2) continue;
                        ssc.getServerClient().start("ARCH_MSG", null, idToArchive.toArray(new String[0]));
                    }
                }
                resultBuilder.append("(").append(vars).append(") - ").append(size).append(" indications archived\n");
            }
        }
        catch (Throwable e) {
            resultBuilder.append("Error: ").append(e.getMessage());
        }
        this.m_lastResult = resultBuilder.toString();
        RTLogger.print(4, "AutoArchiveJobFiltered: Stop " + this.getName());
        return true;
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    public void initVariables() throws Exception {
        this.m_patterns.clear();
        this.convertToMaxHoursIfNeccessary();
        JobConfig jc = super.getJobConfig();
        AbstractAttribute attrMaxMinutes = jc.getJobGroup().getAttribute(MAXMINUTES);
        if (attrMaxMinutes != null) {
            try {
                this.maxMinutes = Integer.parseInt(String.valueOf(attrMaxMinutes.getValue()));
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "MAXMINUTES: error parsing: " + String.valueOf(attrMaxMinutes.getValue()));
            }
        }
        Group specificJobConfig = jc.getConfig().getGroup(FILTER_MAP);
        MapAttribute aa = (MapAttribute)specificJobConfig.getAttribute(PATTERNS);
        for (Map.Entry entry : aa.getValue().entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            Pattern p = Pattern.compile(value);
            this.m_patterns.put(name, p);
        }
    }

    private void convertToMaxHoursIfNeccessary() {
        boolean xmlChanged = false;
        JobConfig jc = super.getJobConfig();
        AbstractAttribute attr = jc.getJobGroup().getAttribute(MAXDAYS);
        if (attr != null) {
            try {
                this.m_maxHours = Integer.parseInt(String.valueOf(attr.getValue())) * 24;
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "MAXDAYS: error parsing: " + String.valueOf(attr.getValue()));
            }
            jc.getJobGroup().removeAttribute(MAXDAYS);
            jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
            xmlChanged = true;
        } else {
            TextAttribute attr2 = (TextAttribute)jc.getJobGroup().getAttribute(MAXHOURS);
            if (attr2 != null) {
                try {
                    this.m_maxHours = Integer.parseInt(String.valueOf(jc.getJobGroup().getAttribute(MAXHOURS).getValue()));
                }
                catch (NumberFormatException e) {
                    RTLogger.print(1, "MAXHOURS: error parsing: " + attr2.getValue());
                    if (jc.getJobGroup().getAttribute(MAXHOURS) == null) {
                        this.m_maxHours = 1440;
                        jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "0", "Max hours"));
                    }
                }
            } else {
                jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                xmlChanged = true;
            }
        }
        if (xmlChanged) {
            ServerJobManager.getInstance().storeConfig(jc);
        }
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        JobConfig bkp = this.m_config;
        try {
            super.setJobConfig(config);
            this.onInit();
        }
        catch (Exception e) {
            RTLogger.print(2, "AutoArchiveJobFiltered: Error processing new configuration. Rollback.");
            try {
                super.setJobConfig(bkp);
                this.onInit();
            }
            catch (Throwable e1) {
                RTLogger.print(2, "AutoArchiveJobFiltered: Rollback failed");
            }
            throw new InvalidConfig(e);
        }
    }
}

