/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.ServerJobManager;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AutoDeleteJob
extends ServerJob {
    public static final String JOB_NAME = "Auto Delete indications";
    public static final String UNPARSABLE_MAX_HOURS_ATTRIBUTE_MUST_BE_INTEGER = "Unparsable. Max hours attribute must be integer";
    public static final String MAX_HOURS_VALUE_LESS_THAN_1_HOUR_TASK_DEACTIVATED = "\"Max hours\" value less than 1 hour! Task deactivated";
    public static final String MAXDAYS = "MAXDAYS";
    public static final String MAXHOURS = "MAXHOURS";
    protected static final int m_maxHoursDefault = 2160;
    protected int m_maxHours = 2160;
    protected String m_lastResult = "-";
    protected static ServerJob m_this = null;

    public static synchronized ServerJob getAutoDeleteJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Deletes archived indications older than specified amount of \"Max hours\"\nValue of \"Max hours\" must be bigger 0.\nTo deactivate this task set \"Max hours\" value to 0 or -1");
            jc.setSchedulingInterval("d0:23:59:59");
            jc.setClassName(AutoDeleteJob.class.getCanonicalName());
            int maxHours = 2160;
            int days = ServerProperties.getDeleteDays();
            if (days > -1) {
                maxHours = days * 24;
            }
            jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + maxHours, "Max hours"));
            jc.setActive(maxHours > 0);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(false);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new AutoDeleteJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "AutoDeleteJob initialization failed", e);
            }
            AutoDeleteJob.updateBoomProps();
        }
        return m_this;
    }

    public AutoDeleteJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.convertToMaxHoursIfNeccessary();
        return true;
    }

    private void convertToMaxHoursIfNeccessary() {
        boolean xmlChanged = false;
        JobConfig jc = super.getJobConfig();
        TextAttribute attr = (TextAttribute)jc.getJobGroup().getAttribute(MAXDAYS);
        if (attr != null) {
            try {
                this.m_maxHours = Integer.parseInt(attr.getValue()) * 24;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            jc.getJobGroup().removeAttribute(MAXDAYS);
            jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
            xmlChanged = true;
        } else {
            TextAttribute attr2 = (TextAttribute)jc.getJobGroup().getAttribute(MAXHOURS);
            if (attr2 != null) {
                try {
                    this.m_maxHours = Integer.parseInt(String.valueOf(jc.getJobGroup().getAttribute(MAXHOURS).getValue()));
                }
                catch (NumberFormatException e) {
                    if (jc.getJobGroup().getAttribute(MAXHOURS) == null) {
                        this.m_maxHours = 2160;
                        jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                        xmlChanged = true;
                    }
                }
            } else {
                jc.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                xmlChanged = true;
            }
        }
        this.setActive(jc.getActive());
        if (xmlChanged) {
            ServerJobManager.getInstance().storeConfig(jc);
        }
        AutoDeleteJob.updateBoomProps();
    }

    private static void updateBoomProps() {
        ServerProperties.setDeleteDays(-1);
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        if (this.m_maxHours >= 1) {
            try {
                int deleted = -1;
                long DeleteDeltaMilliseconds = 3600000L * (long)this.m_maxHours;
                long expireTime = System.currentTimeMillis() - DeleteDeltaMilliseconds;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String deleteTime = sdf.format(new Date(expireTime));
                RTLogger.print(2, "Auto Delete all up to " + deleteTime);
                String deleteOld = "DELETE FROM EVENTS_A WHERE STIME<" + expireTime;
                if (ServerEngine.getInstance().getDB().m_isOracle) {
                    deleteOld = "DELETE FROM EVENTS_A WHERE EVENTS_A.\"STIME\" < " + expireTime;
                }
                RTLogger.print(4, "Auto Delete indication1 SQL " + deleteOld);
                deleted = ServerEngine.getInstance().getDB().executeOnArchive(deleteOld);
                String deleteExt = "DELETE FROM EVENTS_EXT_A WHERE ID_E NOT IN (SELECT ID FROM EVENTS_A)";
                if (ServerEngine.getInstance().getDB().m_isOracle) {
                    deleteExt = "DELETE FROM EVENTS_EXT_A WHERE EVENTS_EXT_A.\"ID_E\" NOT IN (SELECT ID FROM EVENTS_A)";
                }
                RTLogger.print(4, "Auto Delete indication2 SQL " + deleteExt);
                ServerEngine.getInstance().getDB().executeOnArchive(deleteExt);
                String annotations2 = ServerEngine.getInstance().getDB().SQL_DELETE_ANNOTATIONS_V2;
                RTLogger.print(4, "Auto Delete Annotations SQL " + annotations2);
                ServerEngine.getInstance().getDB().executeOnArchive(annotations2);
                this.m_lastResult = "Deleted " + deleted + " archived indications";
            }
            catch (SQLException e) {
                this.m_lastResult = e.getMessage();
            }
        } else {
            this.m_lastResult = "Run rejected, \"Max hours\" value less than 1 hour!";
        }
        return true;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        TextAttribute attribute = (TextAttribute)config.getJobGroup().getAttribute(MAXDAYS);
        if (attribute != null) {
            try {
                this.m_maxHours = Integer.parseInt(attribute.getValue()) * 24;
            }
            catch (NumberFormatException e) {
                throw new InvalidConfig(UNPARSABLE_MAX_HOURS_ATTRIBUTE_MUST_BE_INTEGER);
            }
            config.getJobGroup().removeAttribute(MAXDAYS);
            config.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
        } else {
            try {
                this.m_maxHours = Integer.parseInt(String.valueOf(config.getJobGroup().getAttribute(MAXHOURS).getValue()));
            }
            catch (NumberFormatException e) {
                if (config.getJobGroup().getAttribute(MAXHOURS) == null) {
                    this.m_maxHours = 2160;
                    config.getJobGroup().addAttribute(new TextAttribute(MAXHOURS, "" + this.m_maxHours, "Max hours"));
                }
                throw new InvalidConfig(UNPARSABLE_MAX_HOURS_ATTRIBUTE_MUST_BE_INTEGER);
            }
        }
        this.setActive(config.getActive());
        AutoDeleteJob.updateBoomProps();
    }

    @Override
    public boolean setActive(boolean isActive) {
        if (this.m_maxHours < 1) {
            this.m_lastResult = MAX_HOURS_VALUE_LESS_THAN_1_HOUR_TASK_DEACTIVATED;
            this.getJobConfig().setActive(false);
        } else {
            this.getJobConfig().setActive(true);
        }
        return this.getJobConfig().getActive();
    }
}

