/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.AbstractExportJob;
import com.blixx.server.jobs.FqdnProvider;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.TooOldFiles;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.PasswordAttribute;
import com.blixx.shared.jobs.SftpHostConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.ZIP;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;

public class CMDBExportNG
extends AbstractExportJob {
    public static final String HOSTNAME_KEY = "HOSTNAME";
    public static final String IP_KEY = "IP";
    public static final String GROUP_CMDB = "CMDB";
    public static final String GROUP_SFTP1 = "SFTP1";
    public static final String GROUP_SFTP2 = "SFTP2";
    public static final String GROUP_SFTP3 = "SFTP3";
    public static final String GROUP_SFTP4 = "SFTP4";
    public static final String $HOSTNAME = "<$HOSTNAME>";
    private static final String $AGENTID = "<$AGENTID>";
    public static final String ATTR_SFTP_HOST = "sftpHost";
    public static final String ATTR_SFTP_PORT = "sftpPort";
    public static final String ATTR_SFTP_USER = "sftpUser";
    public static final String ATTR_SFTP_PASS = "sftpPass";
    public static final String ATTR_SFTP_PLAIN_PASS = "sftpPlainPass";
    public static final String ATTR_SFTP_DIR = "sftpDir";
    public static final String ATTR_SFTP_PRIV_KEY = "sftpPrivKey";
    public static final String ATTR_SFTP_PUB_KEY = "sftpPubKey";
    public static final String ATTR_SFTP_PRIV_KEY_PASS = "sftpPrivKeyPass";
    public static final String ATTR_HW_FILE_MASK = "hardwareFileMask";
    public static final String ATTR_SW_FILE_MASK = "softwareFileMask";
    public static final String ATTR_ZIP_FILE_MASK = "zipFileMask";
    public static final String ATTR_DNS_LOOKUP_KEY = "dnsLookup";
    public static final String ATTR_EXPORT_COLUMNS_KEY = "exportSlavesToColumns";
    public static final String ATTR_NUMBER_OF_SLAVES = "numberOfSlavesToExport";
    public static final String ATTR_DNS_COMMAND = "dnsCommand";
    public static final String ATTR_FIXED_HEADERS = "fixedHeadersForOutputFile";
    public static final String ATTR_NETCARD_HEADERS = "networkHeadersForOutputFile";
    public static final String ATTR_SLAVE_HEADERS = "slaveHeadersForOutputFile";
    protected String hwFileMask = "BOOM_CMDB_INV_<$DATE>.csv";
    protected String swFileMask = "BOOM_<$HOSTNAME>UID<$AGENTID>.sw";
    protected String zipFileMask = "BOOM_CMDB_SW_<$DATE>.zip";
    protected String swPrefix = "SW";
    protected boolean dnsLookup = false;
    protected boolean exportSlavesToColumns = false;
    protected int numberofSlavesToExport = 2;
    protected String dnsCommand = "dig -x {ip} +short +time=2 +tries=1";
    protected String serverHostName = "localhost";
    protected String[] fixedHeaders = new String[]{"OS", "HOSTNAME", "OS.NAME", "OS.RELEASE", "OS.BIOS.NAME/OS.KERNEL.NAME", "OS.KERNEL.RELEASE", "OS.KERNEL.VERSION", "HW.MANUFACTURER", "HW.SERIALNUMBER"};
    protected String[] networkCardHeaders = new String[]{"HW.NETCARD.{n}.NAME", "HW.NETCARD.{n}.MAC", "HW.NETCARD.{n}.IPv4.{m}", "HW.NETCARD.{n}.FQDNv4.{m}", "HW.NETCARD.{n}.IPv6.{m}", "HW.NETCARD.{n}.FQDNv6.{m}", "HW.NETCARD.{n}.VENDOR"};
    protected String[] slaveHeaders = new String[]{"HW.NETCARD.{n}.SLAVE.{m}.NAME", "HW.NETCARD.{n}.SLAVE.{m}.VENDOR", "HW.NETCARD.{n}.SLAVE.{m}.MAC"};
    private List<SftpHostConfig> sftpHosts = new ArrayList<SftpHostConfig>();
    public static ConcurrentHashMap<String, String> fqdnsForIps = new ConcurrentHashMap();
    private static final String NETCARD_PATTERN = "^HW\\.NETCARD\\.\\d\\..*$";
    private static final String IP_V4_PATTERN = "^HW\\.NETCARD\\.\\d\\.IPv4\\.\\d$";

    public CMDBExportNG(JobConfig config) throws Exception {
        super(config);
        this.GROUP = GROUP_CMDB;
    }

    @Override
    public boolean onStartRun() {
        this.m_logger.print(1, "job started AgentExport");
        try {
            try {
                if (!this.m_dir.exists()) {
                    this.m_dir.mkdirs();
                    this.initLogfile();
                    this.printValues();
                    this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
                } else {
                    this.m_logger.print(3, "directory exist. " + this.m_dir.getCanonicalPath());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            File[] csvToDelete = this.m_dir.listFiles(new TooOldFiles(this.keepFilesDays, null, ".csv"));
            File[] zipToDelete = this.m_dir.listFiles(new TooOldFiles(this.keepFilesDays, null, ".zip"));
            File[] toDelete = new File[csvToDelete.length + zipToDelete.length];
            System.arraycopy(csvToDelete, 0, toDelete, 0, csvToDelete.length);
            System.arraycopy(zipToDelete, 0, toDelete, csvToDelete.length == 0 ? 0 : csvToDelete.length, zipToDelete.length);
            this.m_logger.print(3, "old files to delete: " + toDelete.length);
            for (int i = 0; i < toDelete.length; ++i) {
                try {
                    if (toDelete[i].delete()) continue;
                    this.m_logger.print(1, ERROR + "can't delete old file: " + String.valueOf(toDelete[i]));
                    continue;
                }
                catch (Throwable e) {
                    this.m_logger.print(1, ERROR + "can't delete old file: " + String.valueOf(toDelete[i]), e);
                }
            }
        }
        catch (Throwable e) {
            this.m_logger.print(3, "", e);
        }
        return super.onStartRun();
    }

    @Override
    public boolean onGetData() {
        this.m_logger.print(3, "starting...");
        LinkedHashMap agentHwInfos = new LinkedHashMap();
        LinkedHashMap agentSwInfos = new LinkedHashMap();
        LinkedList<String> hwHeaders = new LinkedList<String>(Arrays.asList(this.fixedHeaders));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Predicate<String> netCardPattern = Pattern.compile(NETCARD_PATTERN).asPredicate();
        Predicate<String> ipV4Pattern = Pattern.compile(IP_V4_PATTERN).asPredicate();
        LinkedList<String> fixedHeadersFilter = new LinkedList<String>(Arrays.asList(this.fixedHeaders));
        List multipleHeaders = hwHeaders.stream().filter(h -> h.contains("/")).collect(Collectors.toList());
        for (String mulHeader : multipleHeaders) {
            int actualIndex = fixedHeadersFilter.indexOf(mulHeader);
            String[] hds = mulHeader.split("/");
            fixedHeadersFilter.remove(mulHeader);
            fixedHeadersFilter.addAll(actualIndex, Arrays.asList(hds));
        }
        int fixedHeadersCount = hwHeaders.size();
        hwHeaders.addAll(Arrays.asList(this.networkCardHeaders));
        if (!this.exportSlavesToColumns) {
            hwHeaders.addAll(Arrays.asList(this.slaveHeaders));
        }
        try {
            if (this.m_exportNormalOnline || this.m_exportNormalOffline || this.m_exportExternalOnline || this.m_exportExternalOffline) {
                int rowCounter = 0;
                for (Map.Entry<String, AgentCard> en : ServerEngine.getInstance().getAgentRepository().getAgentCards().entrySet()) {
                    AgentCard ac = en.getValue();
                    boolean doExport = ac.isApproved() && this.isSelectedToExport(ac);
                    if (!doExport) continue;
                    ArrayList<String> agentSwInventory = new ArrayList<String>();
                    this.m_logger.print(3, "processing " + ac.getAgentHost());
                    try {
                        this.m_logger.print(3, "processing " + ac.getAgentHost() + " (" + ac.getAgentIP() + ")");
                        StringBuffer sb = new StringBuffer();
                        sb.append(ac.getAgentHost()).append(';');
                        sb.append(ac.getAgentIP()).append(';');
                        if (ac.getAgentPort() == 0) {
                            sb.append("Host").append(';');
                        } else {
                            sb.append("Server").append(';');
                        }
                        AgentInventoryCard aci = ac.getAgentInventoryCard();
                        if (aci != null && aci.isDiscovered()) {
                            Object key2;
                            GroupTreeObject tree = aci.getTree();
                            List<GroupTreeObject> allValues = tree.getAllElements();
                            List fixedValues = allValues.stream().filter(t -> fixedHeadersFilter.contains(t.getName())).collect(Collectors.toList());
                            Collections.sort(fixedValues, Comparator.comparingInt(item -> fixedHeadersFilter.indexOf(item.getName())));
                            List netCardKeys = allValues.stream().map(GroupTreeObject::getName).filter(netCardPattern).collect(Collectors.toList());
                            List netCardValues = allValues.stream().filter(t -> netCardKeys.contains(t.getName())).collect(Collectors.toList());
                            Map netCards = netCardValues.stream().collect(Collectors.groupingBy(s -> s.toString().replace("HW.NETCARD.", "").substring(0, s.toString().indexOf(46)), Collectors.toSet()));
                            List sortedKeys = netCards.keySet().stream().sorted().collect(Collectors.toList());
                            this.m_logger.print(4, "Number of Network cards found : " + netCards.size() + " for " + ac.getAgentID());
                            for (Object key2 : sortedKeys) {
                                String n = ((String)key2).replace(".", "");
                                Set netCard = netCards.get(key2);
                                List ip4KeysForCard = netCard.stream().map(GroupTreeObject::getName).filter(ipV4Pattern).collect(Collectors.toList());
                                List ip4Values = netCard.stream().sorted().filter(t -> ip4KeysForCard.contains(t.getName())).collect(Collectors.toList());
                                if (ip4Values.size() == 0) {
                                    ip4Values.add(new GroupTreeObject("", "", ""));
                                }
                                for (GroupTreeObject ipv4 : ip4Values) {
                                    ArrayList<String> agentHwInventory = new ArrayList<String>();
                                    String m = ipv4.getName().replace("HW.NETCARD." + n + ".IPv4.", "");
                                    for (int i = 0; i < fixedHeadersCount + this.networkCardHeaders.length; ++i) {
                                        agentHwInventory.add("");
                                    }
                                    for (String[] fixedValue : fixedValues) {
                                        int valueIndex = hwHeaders.indexOf(fixedValue.getName());
                                        if (valueIndex < 0) {
                                            String hd = hwHeaders.stream().filter(arg_0 -> CMDBExportNG.lambda$onGetData$6((GroupTreeObject)fixedValue, arg_0)).findFirst().orElse("");
                                            if (hd.isEmpty()) {
                                                this.m_logger.print(1, ERROR + ac.getAgentID(), "Header for " + fixedValue.getName() + " could not found.");
                                                continue;
                                            }
                                            valueIndex = hwHeaders.indexOf(hd);
                                        }
                                        String val = "";
                                        if (fixedValue.getTreeObject() != null && fixedValue.getTreeObject().getObject() != null) {
                                            val = fixedValue.getTreeObject().getObject().toString();
                                        }
                                        if (val.isEmpty()) continue;
                                        agentHwInventory.set(valueIndex, val);
                                    }
                                    String ipV6 = "";
                                    for (String netCardHeader : this.networkCardHeaders) {
                                        int valueIndex = hwHeaders.indexOf(netCardHeader);
                                        String filter = netCardHeader.replace("{n}", n).replace("{m}", m);
                                        GroupTreeObject netCardNValue = netCardValues.stream().filter(t -> t.getName().matches(filter)).findFirst().orElse(null);
                                        String val = "";
                                        if (netCardNValue != null && netCardNValue.getTreeObject() != null && netCardNValue.getTreeObject().getObject() != null) {
                                            val = netCardNValue.getTreeObject().getObject().toString();
                                            if (netCardHeader.contains(".IPv6.")) {
                                                ipV6 = netCardNValue.getTreeObject().getObject().toString();
                                            }
                                        }
                                        if (this.dnsLookup && netCardHeader.endsWith(".FQDNv4.{m}") && !ipv4.getName().isEmpty()) {
                                            if (val.isEmpty()) {
                                                val = ipv4.getTreeObject().getObject().toString();
                                                r = new FqdnProvider(ipv4.getTreeObject().getObject().toString(), this.dnsCommand, valueIndex);
                                                t = new Thread(r);
                                                threads.add(t);
                                                t.start();
                                            } else {
                                                fqdnsForIps.put(ipv4.getTreeObject().getObject().toString(), val);
                                                val = ipv4.getTreeObject().getObject().toString();
                                            }
                                        } else if (this.dnsLookup && netCardHeader.endsWith(".FQDNv6.{m}") && !ipV6.isEmpty()) {
                                            if (val.isEmpty()) {
                                                val = ipV6;
                                                r = new FqdnProvider(ipV6, this.dnsCommand, valueIndex);
                                                t = new Thread(r);
                                                threads.add(t);
                                                t.start();
                                            } else {
                                                fqdnsForIps.put(ipV6, val);
                                                val = ipV6;
                                            }
                                        }
                                        if (val.isEmpty()) continue;
                                        agentHwInventory.set(valueIndex, val);
                                    }
                                    if (this.exportSlavesToColumns) {
                                        this.m_logger.print(4, "Exporting inventory as columns for " + ac.getAgentID());
                                        for (i = 1; i < this.numberofSlavesToExport + 1; ++i) {
                                            for (String slaveHeader : this.slaveHeaders) {
                                                String hdName = slaveHeader.replace("{n}", "n").replace("{m}", "" + i);
                                                if (!hwHeaders.contains(hdName)) {
                                                    hwHeaders.add(hdName);
                                                }
                                                String filter = slaveHeader.replace("{n}", n).replace("{m}", "" + i);
                                                int valIndex = hwHeaders.indexOf(hdName);
                                                slaveValue = netCardValues.stream().filter(t -> t.getName().matches(filter)).findFirst().orElse(null);
                                                val = "";
                                                if (slaveValue != null && slaveValue.getTreeObject() != null && slaveValue.getTreeObject().getObject() != null) {
                                                    val = slaveValue.getTreeObject().getObject().toString();
                                                }
                                                while (agentHwInventory.size() < hwHeaders.size()) {
                                                    agentHwInventory.add("");
                                                }
                                                if (val.isEmpty()) continue;
                                                agentHwInventory.set(valIndex, val);
                                            }
                                        }
                                        agentHwInfos.put(Integer.toString(rowCounter++), agentHwInventory);
                                    } else {
                                        this.m_logger.print(4, "Exporting inventory as rows for " + ac.getAgentID());
                                        for (i = 1; i < this.numberofSlavesToExport + 1; ++i) {
                                            ArrayList<String> inventoryRowData = new ArrayList<String>(agentHwInventory);
                                            Object emptyDuplicate = "";
                                            for (String slaveHeader : this.slaveHeaders) {
                                                String filter = slaveHeader.replace("{n}", n).replace("{m}", "" + i);
                                                slaveValue = netCardValues.stream().filter(t -> t.getName().matches(filter)).findFirst().orElse(null);
                                                val = "";
                                                if (slaveValue != null && slaveValue.getTreeObject() != null && slaveValue.getTreeObject().getObject() != null) {
                                                    val = slaveValue.getTreeObject().getObject().toString();
                                                }
                                                emptyDuplicate = (String)emptyDuplicate + val;
                                                inventoryRowData.add(val);
                                            }
                                            if (!((String)emptyDuplicate).isEmpty() || i == 1) {
                                                agentHwInfos.put(Integer.toString(rowCounter++), inventoryRowData);
                                                this.m_logger.print(6, "Hardware inventory row for slave : " + i + " For IP: " + String.valueOf(ipv4.getTreeObject().getObject()) + " created.");
                                                continue;
                                            }
                                            this.m_logger.print(6, "Exporting for slave number : " + i + " For IP: " + String.valueOf(ipv4.getTreeObject().getObject()) + " skipped for empty values");
                                        }
                                    }
                                    this.m_logger.print(4, "Finished processing hardware Inventory for : " + ac.getAgentID());
                                }
                            }
                            this.m_logger.print(4, "Starting to process Software Inventory for : " + ac.getAgentID());
                            List swValues = allValues.stream().filter(t -> t.getName().startsWith(this.swPrefix.concat("."))).collect(Collectors.toList());
                            key2 = swValues.iterator();
                            while (key2.hasNext()) {
                                GroupTreeObject t2 = (GroupTreeObject)key2.next();
                                String swValue = (String)t2.getTreeObject().getObject();
                                if (agentSwInventory.contains(swValue) || swValue.isEmpty()) continue;
                                agentSwInventory.add(swValue);
                            }
                            this.m_logger.print(4, "Software Inventory processed totoal of : " + agentSwInventory.size() + " for " + ac.getAgentID());
                            if (agentSwInventory.size() <= 0) continue;
                            agentSwInfos.put((CallSite)((Object)(ac.getAgentID() + "," + ac.getAgentHost())), agentSwInventory);
                            continue;
                        }
                        this.m_logger.print(4, "Inventory process skipped due to HW_CPUN value is empty : " + ac.getAgentID());
                        try {
                            String osFromField = "";
                            if (osFromField != null && osFromField.indexOf(41) != -1) {
                                osFromField = osFromField.substring(osFromField.lastIndexOf(41) + 1).trim();
                            }
                            if ("_External".equalsIgnoreCase(osFromField)) {
                                osFromField = "";
                            }
                            ArrayList<String> agentHwInventory = new ArrayList<String>();
                            agentHwInventory.add(osFromField);
                            agentHwInfos.put(Integer.toString(rowCounter++), agentHwInventory);
                        }
                        catch (Throwable e) {
                            this.m_logger.print(1, ERROR + e.getMessage());
                        }
                    }
                    catch (Throwable e) {
                        this.m_logger.print(1, ERROR + "Error occurred during processing " + ac.getAgentHost() + " (" + ac.getAgentIP() + ")");
                        this.m_logger.print(1, ERROR + String.valueOf(ac), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.m_lastResult = "Error " + e.getMessage();
            this.m_logger.print(1, ERROR, e);
            this.m_logger.print(1, FAILED + "job finished CMDBExport");
        }
        int threadFinishedCounter = 0;
        while (threadFinishedCounter < threads.size()) {
            threadFinishedCounter = 0;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
            for (int i = 0; i < threads.size(); ++i) {
                if (((Thread)threads.get(threadFinishedCounter)).getState() != Thread.State.TERMINATED) continue;
                ++threadFinishedCounter;
            }
        }
        this.m_logger.print(4, "Writing to file Hardware inventory");
        Date now = new Date();
        Iterator itrHw = agentHwInfos.entrySet().iterator();
        File hwFile = this.getFile(now);
        try (PrintWriter hwWriter = new PrintWriter(hwFile);){
            int headerCount = hwHeaders.size();
            StringBuilder headersStr = new StringBuilder();
            hwHeaders.forEach(h -> headersStr.append((String)h).append(";"));
            String columns = this.removeLastChar(headersStr.toString());
            hwWriter.println(columns.replace("{n}", "n").replace("{m}", "m"));
            while (itrHw.hasNext()) {
                Map.Entry entry = itrHw.next();
                StringBuilder valuesStr = new StringBuilder();
                List values = (List)entry.getValue();
                for (int i = 0; i < headerCount; ++i) {
                    String headerName;
                    String v2 = "";
                    try {
                        v2 = (String)values.get(i);
                    }
                    catch (IndexOutOfBoundsException netCards) {
                        // empty catch block
                    }
                    if (this.dnsLookup && ((headerName = (String)hwHeaders.get(i)).endsWith(".FQDNv4.{m}") || headerName.endsWith(".FQDNv6.{m}")) && !v2.isEmpty()) {
                        int finalDotIndex;
                        String ip = "";
                        String fqdnVal = "";
                        try {
                            ip = v2;
                            fqdnVal = fqdnsForIps.get(ip);
                        }
                        catch (Exception key2) {
                            // empty catch block
                        }
                        v2 = fqdnVal != null && !fqdnVal.equals(ip) ? ((finalDotIndex = fqdnVal.lastIndexOf(".")) > 0 ? fqdnVal.substring(0, finalDotIndex) : fqdnVal) : "";
                    }
                    valuesStr.append(v2).append(";");
                }
                hwWriter.println(this.removeLastChar(valuesStr.toString()));
            }
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR, e);
            this.m_logger.print(1, FAILED + "job finished CMDBExport");
        }
        this.m_logger.print(4, "Writing to file Software inventory");
        ArrayList<File> swFiles = new ArrayList<File>();
        for (Map.Entry entry : agentSwInfos.entrySet()) {
            String idHost = (String)entry.getKey();
            String agentId = idHost.split(",")[0];
            String agentHost = idHost.split(",")[1];
            File swFile = this.getFile(agentHost, agentId);
            try (PrintWriter swWriter = new PrintWriter(swFile);){
                List values = (List)entry.getValue();
                values.sort(String::compareToIgnoreCase);
                values.forEach(v -> swWriter.println((String)v));
            }
            catch (Exception e) {
                this.m_logger.print(1, ERROR, e);
                this.m_logger.print(1, FAILED + "job finished CMDBExport");
            }
            swFiles.add(swFile);
            String md5hash = "";
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md5hash = this.getFileChecksum(md, swFile);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.m_logger.print(1, ERROR, e);
                this.m_logger.print(1, FAILED + "job finished CMDBExport");
            }
            File md5File = this.getMd5File(agentHost, agentId);
            try (PrintWriter md5Writer = new PrintWriter(md5File);){
                md5Writer.print(md5hash);
            }
            catch (Exception e) {
                this.m_logger.print(1, ERROR, e);
                this.m_logger.print(1, FAILED + "job finished CMDBExport");
            }
            swFiles.add(md5File);
        }
        this.m_logger.print(4, "Writing to file Software inventory finished.");
        this.m_logger.print(4, "Zipping Software inventory files");
        ZIP zip = new ZIP();
        File zipFile = this.getFileForZip(now);
        File[] filesToZip = swFiles.toArray(new File[0]);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (int i = 0; i < filesToZip.length; ++i) {
                File f = filesToZip[i];
                String fPath = f.getPath().replace(f.getName(), "");
                zip.zipFile(zos, f, fPath);
                try {
                    if (f.delete()) continue;
                    this.m_logger.print(1, ERROR + "can't delete file: " + f.getName());
                    continue;
                }
                catch (Throwable e) {
                    this.m_logger.print(1, ERROR + "can't delete file: " + f.getName(), e);
                }
            }
        }
        catch (IOException e) {
            this.m_logger.print(1, ERROR, e);
            this.m_logger.print(1, FAILED + "job finished CMDBExport");
        }
        this.m_logger.print(4, "Zipping Software inventory files finished.");
        this.sentToSftp(hwFile, zipFile);
        this.m_lastResult = "Output files: " + hwFile.getName() + " & " + zipFile.getName();
        this.m_logger.print(1, SUCCESS + "job finished CMDBExport");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentToSftp(File hwFile, File zipFile) {
        Session session = null;
        Channel channel = null;
        for (SftpHostConfig config : this.sftpHosts) {
            this.m_logger.print(4, "Sending to : " + config.getHost());
            String connectionType = config.getConnectionType();
            if (connectionType.equals("WRONG_CONFIG")) {
                this.m_logger.print(1, config.getErrorMessage());
                continue;
            }
            if (connectionType.equals("PUBLIC_KEY")) {
                session = this.getPublicKeySession(config);
            } else if (connectionType.equals("USER_PASS")) {
                session = this.getUserPassSession(config);
            }
            if (session == null) {
                this.m_logger.print(1, ERROR + "Creating Session failed for " + config.toString());
                continue;
            }
            try {
                session.connect();
                channel = session.openChannel("sftp");
                channel.connect();
                final ChannelSftp sftp = (ChannelSftp)channel;
                this.m_logger.print(4, "SFTP connection established to : " + config.getHost());
                try {
                    sftp.cd(config.getDir());
                }
                catch (Throwable e) {
                    String err = "SFTP: can't change remote directory: " + config.getDir();
                    this.m_logger.print(1, ERROR + err);
                    if (channel != null) {
                        try {
                            channel.disconnect();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (session == null) break;
                    try {
                        session.disconnect();
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                boolean sendInventory = false;
                boolean sendSoftware = false;
                String relativeHw = this.m_workingdir + "/" + hwFile.getName();
                final String transportNameHw = hwFile.getName().replace("$$", "*");
                try {
                    SftpProgressMonitor progressHw = new SftpProgressMonitor(){

                        public void init(int arg0, String arg1, String arg2, long arg3) {
                            CMDBExportNG.this.m_logger.print(1, "Started sending file :" + transportNameHw);
                        }

                        public void end() {
                            CMDBExportNG.this.m_logger.print(1, ServerJob.SUCCESS + " sending file :" + transportNameHw);
                            try {
                                sftp.chmod(438, transportNameHw);
                            }
                            catch (SftpException e) {
                                CMDBExportNG.this.m_logger.print(1, ServerJob.ERROR + " setting rights on :" + transportNameHw);
                            }
                        }

                        public boolean count(long i) {
                            return false;
                        }
                    };
                    sftp.put(relativeHw, transportNameHw, progressHw);
                    sendInventory = true;
                }
                catch (SftpException e) {
                    this.m_logger.print(1, ERROR + "Cause : " + String.valueOf(e.getCause()));
                    this.m_logger.print(1, ERROR + "Message : " + e.getMessage() + " put file: " + transportNameHw);
                }
                if (!sendInventory) {
                    this.m_logger.print(4, "Sending inventory failed, skipping sending zip file.");
                    continue;
                }
                String relativeZip = this.m_workingdir + "/" + zipFile.getName();
                final String transportNameZip = zipFile.getName().replace("$$", "*");
                try {
                    SftpProgressMonitor progressSw = new SftpProgressMonitor(){

                        public void init(int arg0, String arg1, String arg2, long arg3) {
                            CMDBExportNG.this.m_logger.print(1, "Started sending file :" + transportNameZip);
                        }

                        public void end() {
                            CMDBExportNG.this.m_logger.print(1, ServerJob.SUCCESS + " sending file :" + transportNameZip);
                            try {
                                sftp.chmod(438, transportNameZip);
                            }
                            catch (SftpException e) {
                                CMDBExportNG.this.m_logger.print(1, ServerJob.ERROR + " setting rights on :" + transportNameZip);
                            }
                        }

                        public boolean count(long i) {
                            return false;
                        }
                    };
                    sftp.put(relativeZip, transportNameZip, progressSw);
                    sendSoftware = true;
                }
                catch (SftpException e) {
                    this.m_logger.print(1, ERROR + e.getMessage() + " put file: " + transportNameZip);
                }
                if (!sendInventory || !sendSoftware) continue;
                this.m_logger.print(4, "Sending to : " + config.getHost() + " completed successfully");
                break;
            }
            catch (JSchException e) {
                this.m_logger.print(1, "Failed to connect to session - ", e);
            }
            finally {
                if (channel != null) {
                    try {
                        channel.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
                if (session == null) continue;
                try {
                    session.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private Session getPublicKeySession(final SftpHostConfig config) {
        Session session = null;
        JSch jsch = new JSch();
        this.m_logger.print(4, "Trying to open session with private public keys. : " + config.getHost());
        byte[] bytes = null;
        try {
            bytes = config.getSftpPrivateKeyPass().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            bytes = config.getSftpPrivateKeyPass().getBytes();
        }
        try {
            jsch.addIdentity(config.getSftpPrivateKey(), config.getSftpPublicKey(), bytes);
            session = jsch.getSession(config.getUser(), config.getHost(), config.getPort());
        }
        catch (JSchException e) {
            this.m_logger.print(1, "Failed to open session - ", e);
            return session;
        }
        session.setUserInfo(new UserInfo(){

            public void showMessage(String message) {
            }

            public boolean promptYesNo(String message) {
                return true;
            }

            public boolean promptPassword(String message) {
                return false;
            }

            public boolean promptPassphrase(String message) {
                return true;
            }

            public String getPassword() {
                return null;
            }

            public String getPassphrase() {
                return config.getSftpPrivateKeyPass();
            }
        });
        return session;
    }

    public Session getUserPassSession(final SftpHostConfig config) {
        Session session = null;
        JSch jsch = new JSch();
        this.m_logger.print(4, "Trying to open session with username password. : " + config.getHost());
        try {
            session = jsch.getSession(config.getUser(), config.getHost(), config.getPort());
        }
        catch (JSchException e) {
            this.m_logger.print(1, "Failed to open session - ", e);
            return session;
        }
        session.setPassword(config.getPass());
        session.setUserInfo(new UserInfo(){

            public void showMessage(String message) {
            }

            public boolean promptYesNo(String message) {
                return true;
            }

            public boolean promptPassword(String message) {
                return false;
            }

            public boolean promptPassphrase(String message) {
                return true;
            }

            public String getPassword() {
                return config.getPass();
            }

            public String getPassphrase() {
                return null;
            }
        });
        return session;
    }

    @Override
    public void initVariables() throws Exception {
        String value;
        CheckAttribute ac;
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_CMDB);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute("workingDir");
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.m_workingdir = aa.getValue();
        this.m_dir = new File(this.m_workingdir);
        if (!this.m_dir.exists()) {
            if (this.m_dir.mkdirs()) {
                this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
            } else {
                this.m_lastResult = ERROR + "creating working directory " + this.m_dir.getPath();
                this.m_logger.print(1, this.m_lastResult);
            }
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_HW_FILE_MASK)) == null) {
            throw new InvalidConfig("hardwareFileMask is null");
        }
        this.hwFileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SW_FILE_MASK);
        if (aa == null) {
            throw new InvalidConfig("softwareFileMask is null");
        }
        this.swFileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_ZIP_FILE_MASK);
        if (aa == null) {
            throw new InvalidConfig("zipFileMask is null");
        }
        this.zipFileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_DNS_COMMAND);
        if (aa == null) {
            throw new InvalidConfig("dnsCommand is null");
        }
        this.dnsCommand = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute("fileMaskDateFormat");
        if (aa == null) {
            throw new InvalidConfig("fileMaskDateFormat is null");
        }
        try {
            new SimpleDateFormat(aa.getValue());
            this.m_fileMaskDateFormat = aa.getValue();
        }
        catch (Throwable e) {
            this.m_logger.print(1, "unsupported fileMaskDateFormat" + aa.getValue());
        }
        aa = (TextAttribute)specificJobConfig.getAttribute("keepFilesDays");
        if (aa != null) {
            try {
                this.keepFilesDays = Integer.parseInt(aa.getValue());
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: keepFilesDays");
            }
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_NUMBER_OF_SLAVES)) != null) {
            try {
                this.numberofSlavesToExport = Integer.parseInt(aa.getValue());
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: numberOfSlavesToExport");
            }
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FIXED_HEADERS)) != null) {
            try {
                this.fixedHeaders = aa.getValue().split(",");
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: fixedHeadersForOutputFile");
            }
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_NETCARD_HEADERS)) != null) {
            try {
                this.networkCardHeaders = aa.getValue().split(",");
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: networkHeadersForOutputFile");
            }
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_SLAVE_HEADERS)) != null) {
            try {
                this.slaveHeaders = aa.getValue().split(",");
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: slaveHeadersForOutputFile");
            }
        }
        if ((ac = (CheckAttribute)specificJobConfig.getAttribute(ATTR_DNS_LOOKUP_KEY)) != null) {
            value = "" + ac.getValue();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.dnsLookup = ac.getValue();
            } else {
                this.m_logger.print(1, ERROR + "invalid value for attribute: dnsLookup");
            }
        } else {
            specificJobConfig.addAttribute(new CheckAttribute(ATTR_DNS_LOOKUP_KEY, this.dnsLookup, "Dns lookup for Ip"));
        }
        ac = (CheckAttribute)specificJobConfig.getAttribute(ATTR_EXPORT_COLUMNS_KEY);
        if (ac != null) {
            value = "" + ac.getValue();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.exportSlavesToColumns = ac.getValue();
            } else {
                this.m_logger.print(1, ERROR + "invalid value for attribute: exportSlavesToColumns");
            }
        } else {
            specificJobConfig.addAttribute(new CheckAttribute(ATTR_EXPORT_COLUMNS_KEY, this.exportSlavesToColumns, "Export Slaves to Columns"));
        }
        this.readSftpHostConfig(jc, GROUP_SFTP1);
        this.readSftpHostConfig(jc, GROUP_SFTP2);
        this.readSftpHostConfig(jc, GROUP_SFTP3);
        this.readSftpHostConfig(jc, GROUP_SFTP4);
    }

    private void readSftpHostConfig(JobConfig jc, String sftpGroupName) throws Exception {
        PasswordAttribute passaa;
        Group sftpGroup = jc.getConfig().getGroup(sftpGroupName);
        SftpHostConfig sftp = new SftpHostConfig();
        TextAttribute aa = null;
        aa = (TextAttribute)sftpGroup.getAttribute(ATTR_SFTP_HOST);
        if (aa != null) {
            sftp.setHost(aa.getValue());
        }
        if ((aa = (TextAttribute)sftpGroup.getAttribute(ATTR_SFTP_PORT)) != null) {
            try {
                sftp.setPort(Integer.parseInt(aa.getValue()));
            }
            catch (Exception e) {
                this.m_logger.print(1, "invalid sftpPort" + String.valueOf(aa) == null ? null : aa.getValue());
            }
        }
        if ((aa = (TextAttribute)sftpGroup.getAttribute(ATTR_SFTP_USER)) != null) {
            sftp.setUser(aa.getValue());
        }
        if ((passaa = (PasswordAttribute)sftpGroup.getAttribute(ATTR_SFTP_PASS)) != null) {
            sftp.setPass(passaa.getValue());
        }
        if ((aa = (TextAttribute)sftpGroup.getAttribute(ATTR_SFTP_DIR)) != null) {
            sftp.setDir(aa.getValue());
        }
        if ((aa = (TextAttribute)sftpGroup.getAttribute(ATTR_SFTP_PRIV_KEY)) != null) {
            sftp.setSftpPrivateKey(aa.getValue());
        } else {
            sftp.setSftpPrivateKey(null);
        }
        aa = (TextAttribute)sftpGroup.getAttribute(ATTR_SFTP_PUB_KEY);
        if (aa != null) {
            sftp.setSftpPublicKey(aa.getValue());
        } else {
            sftp.setSftpPublicKey(null);
        }
        passaa = (PasswordAttribute)sftpGroup.getAttribute(ATTR_SFTP_PRIV_KEY_PASS);
        if (passaa != null) {
            sftp.setSftpPrivateKeyPass(passaa.getValue());
        } else {
            sftp.setSftpPrivateKeyPass(null);
        }
        this.sftpHosts.add(sftp);
    }

    public File getFile(String hostName, String agentID) {
        String filename = this.getFilename(hostName, agentID);
        return new File(this.m_dir, filename);
    }

    public File getMd5File(String hostName, String agentID) {
        String filename = this.getFilename(hostName, agentID);
        filename = filename.replace(".sw", ".md5");
        return new File(this.m_dir, filename);
    }

    public File getFileForZip(Date time) {
        String filename = this.getFileNameForZip(time);
        return new File(this.m_dir, filename);
    }

    @Override
    public File getFile(Date time) {
        String filename = this.getFilename(time);
        return new File(this.m_dir, filename);
    }

    @Override
    public String getFilename(Date time) {
        String res = this.hwFileMask.replace("<$DATE>", this.getFileMaskDate(time)).replace("*", "$$");
        res = res.replace("<$BOOM_SERVER>", this.serverHostName);
        return res;
    }

    public String getFilename(String hostName, String agentID) {
        String res = this.swFileMask.replace($HOSTNAME, hostName).replace($AGENTID, agentID).replace("*", "$$");
        res = res.replace("<$BOOM_SERVER>", this.serverHostName);
        return res;
    }

    public String getFileNameForZip(Date time) {
        String res = this.zipFileMask.replace("<$DATE>", this.getFileMaskDate(time).replace("*", "$$"));
        res = res.replace("<$BOOM_SERVER>", this.serverHostName);
        return res;
    }

    private String getFileChecksum(MessageDigest digest, File file) throws IOException {
        try (DigestInputStream dis = new DigestInputStream(new FileInputStream(file), digest);){
            while (dis.read() != -1) {
            }
            digest = dis.getMessageDigest();
        }
        StringBuilder swHash = new StringBuilder();
        for (byte b : digest.digest()) {
            swHash.append(String.format("%02x", b));
        }
        return swHash.toString();
    }

    private void printValues() {
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.m_logger.print(1, "keepFilesDays: " + this.keepFilesDays);
        this.m_logger.print(1, "swFilemask: " + this.swFileMask);
        this.m_logger.print(1, "hwFilemask: " + this.hwFileMask);
    }

    public String removeLastChar(String str) {
        if (str != null && str.length() > 0 && str.charAt(str.length() - 1) == ';') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static /* synthetic */ boolean lambda$onGetData$6(GroupTreeObject fixedValue, String h) {
        return h.contains(fixedValue.getName());
    }
}

