/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import com.blixx.server.AgentCard;
import com.blixx.server.CertificateStateIndicationHelper;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.Severity;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.boom.crt.CertificateManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class CertificateExpirationJob
extends ServerJob {
    public static final String JOB_NAME = "Certificate expiration check";
    protected static CertificateExpirationJob instance = null;
    public static final String THRESHOLD_CONFIG = "THRESHOLD_CONFIG";
    private static final String DEFAULT_THRESHOLDS = "30:MAJOR,7:CRITICAL";
    private static final String SEND_NORMALS = "SENDNORMALS";
    protected final SALogger logger = new SALogger();
    private final SortedSet<ThresholdConfig> thresholdConfigSet = new TreeSet<ThresholdConfig>();
    private boolean isSendNormals = false;
    private String lastResult = "";

    public CertificateExpirationJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() {
        TextAttribute threshold = (TextAttribute)this.getJobConfig().getJobGroup().getAttribute(THRESHOLD_CONFIG);
        String value = threshold.getValue();
        if (value == null || value.matches("\\s*")) {
            value = DEFAULT_THRESHOLDS;
        }
        this.parseThresholdConfig(value);
        CheckAttribute isSN = (CheckAttribute)this.getJobConfig().getJobGroup().getAttribute(SEND_NORMALS);
        if (isSN != null && isSN.getValue() != null) {
            this.isSendNormals = isSN.getValue();
        }
        return false;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        try {
            this.onInit();
        }
        catch (Exception e) {
            this.logger.print(1, "Could not apply job config for CertificateExpirationJob");
        }
    }

    public static synchronized ServerJob getCertificateExpirationJob() {
        if (instance == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically checks the certificate expiration in server key and trust stores.");
            jc.setSchedulingInterval("d0:06:45:00");
            jc.setActive(true);
            jc.setClassName(CertificateExpirationJob.class.getCanonicalName());
            jc.getJobGroup().addAttribute(new TextAttribute(THRESHOLD_CONFIG, DEFAULT_THRESHOLDS, "Days before expiration to issue a message with specific severity. Format: THRESHOLD_DAYS:SEVERITY(,THRESHOLD_DAYS:SEVERITY)*"));
            jc.getJobGroup().addAttribute(new CheckAttribute(SEND_NORMALS, false, "Send normal indications for good certificates?"));
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(false);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                instance = new CertificateExpirationJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "CertificateExpirationJob initialization failed", e);
            }
        }
        return instance;
    }

    private void parseThresholdConfig(String thresholdConfig) {
        String[] thresholdConfigs;
        this.thresholdConfigSet.clear();
        this.thresholdConfigSet.add(new ThresholdConfig(1, Integer.MAX_VALUE));
        for (String cfg : thresholdConfigs = thresholdConfig.split(",")) {
            String[] severityDaysPair = cfg.split(":");
            if (severityDaysPair.length != 2) continue;
            String thresholdStr = severityDaysPair[0];
            String severityStr = severityDaysPair[1];
            try {
                Integer threshold = Integer.valueOf(thresholdStr);
                this.thresholdConfigSet.add(new ThresholdConfig(Severity.getSeverity(severityStr.toLowerCase()), threshold));
            }
            catch (NumberFormatException e) {
                this.logger.print(1, "Could not parse threshold configuration: " + cfg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        StringBuilder sb = new StringBuilder();
        try {
            CertificateManager certificateManager = ServerEngine.getInstance().getCertificateManager();
            if (certificateManager != null) {
                KeyStore ks;
                KeyStore ts;
                String result;
                sb.append("-TS-\n");
                if (certificateManager.getTsClient() != null && !(result = this.checkKSCerts(ts = certificateManager.getTsClient().getKeyStore(), CertificateStateIndicationHelper.KeyStoreType.SERVER_TRUST_STORE)).isEmpty()) {
                    sb.append(result);
                }
                sb.append("\n--\n").append("-KS-");
                if (certificateManager.getKsClient() != null && !(result = this.checkKSCerts(ks = certificateManager.getKsClient().getKeyStore(), CertificateStateIndicationHelper.KeyStoreType.SERVER_KEY_STORE)).isEmpty()) {
                    sb.append(result);
                }
                sb.append("\n--\n");
            }
        }
        catch (Exception e) {
            sb.append("Error ").append(e.getClass().getName());
            sb.append(e.getMessage());
            RTLogger.print(1, "Could not check certificates expiration", e);
        }
        finally {
            this.lastResult = sb.toString();
        }
        return true;
    }

    private String checkKSCerts(KeyStore keyStore, CertificateStateIndicationHelper.KeyStoreType keyStoreType) throws KeyStoreException {
        StringBuilder sb = new StringBuilder();
        int okSertsCount = 0;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                Certificate certificate = keyStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                Date notAfter = ((X509Certificate)certificate).getNotAfter();
                long currentTimeMillis = System.currentTimeMillis();
                long notAfterMillis = notAfter.getTime();
                long daysToExpiration = (notAfterMillis - currentTimeMillis) / TimeUnit.DAYS.toMillis(1L);
                Optional<ThresholdConfig> effectiveThresholdConfig = this.getEffectiveThresholdConfig(daysToExpiration);
                if (!effectiveThresholdConfig.isPresent()) continue;
                int severity = effectiveThresholdConfig.get().getSeverity();
                if (this.isSendNormals || severity > 1) {
                    AgentCard agentCardByID;
                    if (severity == 1) {
                        ++okSertsCount;
                    }
                    if ((agentCardByID = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(alias)) == null) {
                        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
                        CertificateStateIndicationHelper.sendCertificateExpirationIndication(severity, hostname, keyStoreType, alias, notAfter, daysToExpiration);
                    } else {
                        CertificateStateIndicationHelper.sendCertificateExpirationIndication(severity, agentCardByID.getAgentHost(), keyStoreType, alias, notAfter, daysToExpiration);
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                        sb.append('\n');
                    }
                    if (daysToExpiration > 0L) {
                        sb.append(alias).append(" : ").append(daysToExpiration).append(" to expire");
                        continue;
                    }
                    sb.append(alias).append(" : expired since ").append(Math.abs(daysToExpiration));
                    continue;
                }
                ++okSertsCount;
            }
            catch (Exception e) {
                sb.append("Could not check certificate from ").append((Object)keyStoreType).append(" for expiration. Alias: ").append(alias).append(". ").append(e.getClass().getName());
                sb.append(e.getMessage());
                RTLogger.print(1, "Could not check certificate from " + String.valueOf((Object)keyStoreType) + " for expiration. Alias: " + alias, e);
            }
        }
        sb.append("\nOK certs: ").append(okSertsCount);
        return sb.toString();
    }

    @Override
    public String getLastRunResult() {
        return this.lastResult;
    }

    private Optional<ThresholdConfig> getEffectiveThresholdConfig(long days) {
        ThresholdConfig effectiveCfg = null;
        for (ThresholdConfig cfg : this.thresholdConfigSet) {
            if ((long)cfg.threshold <= days) continue;
            effectiveCfg = cfg;
            break;
        }
        return Optional.ofNullable(effectiveCfg);
    }

    private static class ThresholdConfig
    implements Comparable<ThresholdConfig> {
        private final int severity;
        private final int threshold;

        public ThresholdConfig(int severity, int threshold) {
            this.severity = severity;
            this.threshold = threshold;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThresholdConfig that = (ThresholdConfig)o;
            return this.severity == that.severity && this.threshold == that.threshold;
        }

        public int hashCode() {
            return Objects.hash(this.severity, this.threshold);
        }

        @Override
        public int compareTo(ThresholdConfig o) {
            return Integer.compare(this.threshold, o.threshold);
        }
    }
}

