/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.DB;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class CleanPerfDB
extends ServerJob {
    public static final String GROUP_DATA = "DATA";
    public static final String ATTR_WORKING_DIR = "workingDir";
    public static final String ATTR_MAX_DAYS = "max_days_history";
    private String m_workingdir = "srv/jobs/cleanPerfDB";
    private int m_maxDays = 0;
    private File m_dir;
    private SALogger m_logger = new SALogger();
    public String m_lastResult = "-";

    public CleanPerfDB(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        this.m_logger.setMaxCount(super.getJobConfig().getLogcount());
        this.m_logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.m_logger.setDir(this.m_workingdir, "CleanPerfDB_");
        this.m_logger.setLevel(super.getJobConfig().getLoglevel());
        this.m_logger.print(1, String.valueOf(this.getClass()) + " init done.");
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.m_logger.print(1, "max history days: " + this.m_maxDays);
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    public void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_DATA);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_WORKING_DIR);
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.m_workingdir = aa.getValue();
        this.m_dir = new File(this.m_workingdir);
        if (!this.m_dir.exists()) {
            this.m_dir.mkdirs();
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_MAX_DAYS)) == null) {
            throw new InvalidConfig("max_days_history is null");
        }
        this.m_maxDays = Integer.parseInt(aa.getValue());
    }

    @Override
    public boolean onStartRun() {
        try {
            if (!this.m_dir.exists()) {
                this.m_dir.mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.onStartRun();
    }

    @Override
    public boolean onGetData() {
        if (this.m_maxDays <= 0) {
            this.m_logger.print(1, "max history days: " + this.m_maxDays + " must be bigger 0.");
            this.stopTask();
            return true;
        }
        long limt = System.currentTimeMillis() - 86400000L * (long)this.m_maxDays;
        DB db = ServerEngine.getInstance().getDB();
        ArrayList tables = new ArrayList(ServerEngine.getInstance().getDB().getPerfTables().keySet());
        Iterator it = tables.iterator();
        int errors = 0;
        int total = tables.size();
        int cleanedRows = 0;
        while (it.hasNext()) {
            String table = (String)it.next();
            try {
                int res = 0;
                int limitRows = 50000;
                String SQL = "DELETE FROM `" + table + "` WHERE `_TIME` < " + limt + " LIMIT " + limitRows;
                if (db.m_isOraclePERF) {
                    SQL = "DELETE FROM \"" + table + "\" WHERE \"_TIME\" < " + limt + " AND rownum <= " + limitRows;
                }
                do {
                    this.m_logger.print(1, SQL);
                    res = db.executePerf2(SQL, 1800);
                    this.m_logger.print(1, "Cleaned " + res + " rows");
                    if (res <= 0) continue;
                    cleanedRows += res;
                } while (res == limitRows);
            }
            catch (SQLException e) {
                ++errors;
                this.m_logger.print(1, "Error cleaning table: " + table, e);
            }
        }
        this.m_lastResult = errors != 0 ? "tables: " + total + ". errors: " + errors + " deleted rows: " + cleanedRows : "tables: " + total + ". deleted rows: " + cleanedRows;
        return true;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        JobConfig bkp = this.m_config;
        try {
            super.setJobConfig(config);
            this.onInit();
        }
        catch (Exception e) {
            this.m_logger.print(1, "Error processing new configuration. Rollback.");
            try {
                super.setJobConfig(bkp);
                this.onInit();
            }
            catch (Throwable e1) {
                this.m_logger.print(1, "Rollback failed");
            }
            throw new InvalidConfig(e);
        }
    }
}

