/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.io.File;

public class ExecJob
extends ServerJob {
    public static final String GROUP_EXEC = "EXEC";
    public static final String ATTR_WORKING_DIR = "workingDir";
    public static final String ATTR_EXEC = "exec";
    private String m_workingdir = "srv/jobs/exec";
    private String m_exec = null;
    private File m_dir;
    private SALogger m_logger = new SALogger();
    public String m_lastResult = "-";

    public ExecJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onGetData() {
        this.m_logger.print(1, "Start " + this.getName());
        try {
            this.m_exec = this.m_exec.replace("<$BOOM_SRV_DIR>", new File(".").getCanonicalPath());
            this.m_exec = this.m_exec.replace("<$BOOM_SRV_DIR>", new File(".").getCanonicalPath());
            this.m_exec = this.m_exec.replace("<$WORKING_DIR>", this.m_dir.getCanonicalPath());
            ExecResult er = ExecUtils.exec2(this.m_exec, this.m_dir, (int)(-5L + this.getInterval() / 1000L));
            this.m_lastResult = er.resultCode == 0 ? "Success: " + er.getOutput() : "Error: " + er.getOutput();
        }
        catch (Throwable e) {
            this.m_lastResult = "Error: Failed to execute " + this.m_exec + " : " + e.getMessage();
        }
        this.m_logger.print(1, "Stop " + this.getName());
        return true;
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        this.m_logger.setMaxCount(super.getJobConfig().getLogcount());
        this.m_logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.m_logger.setDir(this.m_workingdir, "ExecJob_");
        this.m_logger.setLevel(super.getJobConfig().getLoglevel());
        this.m_logger.print(1, String.valueOf(this.getClass()) + " init done.");
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    public void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_EXEC);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_WORKING_DIR);
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.m_workingdir = aa.getValue();
        this.m_dir = new File(this.m_workingdir);
        if (!this.m_dir.exists()) {
            this.m_dir.mkdirs();
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_EXEC)) == null) {
            throw new InvalidConfig("exec is null");
        }
        this.m_exec = aa.getValue();
    }
}

