/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.jobs.CMDBExportNG;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class FqdnProvider
implements Runnable {
    String ip = "";
    String command = "dig -x {ip} short +time=2 +tries=1";
    int valueIndex;

    public FqdnProvider(String ip, String cmd, int valueIndex) {
        this.ip = ip;
        this.command = cmd;
        this.valueIndex = valueIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String cmd = this.command.replace("{ip}", this.ip);
        StringBuilder digResult = new StringBuilder();
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                digResult.append(line + "\n");
            }
        }
        catch (Exception e) {
            RTLogger.print(2, e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    RTLogger.print(2, e.getMessage());
                }
            }
        }
        String fqdn = digResult.toString();
        CMDBExportNG.fqdnsForIps.putIfAbsent(this.ip, fqdn);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    public void setValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }
}

