/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.ServerEngine;
import com.blixx.shared.Interval;
import com.blixx.shared.jobs.IServerJob;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class ServerJob
extends SchedulerTask
implements IServerJob {
    protected SimpleDateFormat m_sdfDATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected long m_lastTimeStart = 0L;
    protected static String ERROR = "Error: ";
    protected static String SUCCESS = "Success: ";
    protected static String FAILED = "Failed: ";
    JobConfig m_config = new JobConfig();
    long m_LPT = 0L;
    Throwable m_initError = null;

    public ServerJob(JobConfig config) throws Exception {
        super(config.getJobName());
        this.m_config = config;
        String textInterval = this.m_config.getSchedulingInterval();
        this.setInterval(Interval.parseInterval(textInterval, -1));
    }

    @Override
    public boolean onGetData() {
        RTLogger.print(4, "dummy run. Server Job: " + this.getName());
        return true;
    }

    @Override
    public boolean onStartRun() {
        this.m_lastTimeStart = System.currentTimeMillis();
        RTLogger.print(4, "Starting Server Job: " + this.getName());
        return true;
    }

    @Override
    public boolean onStopRun() {
        this.m_LPT = System.currentTimeMillis() - this.getStartTime();
        RTLogger.print(4, "Finished Server Job: " + this.getName() + " pt=" + this.m_LPT);
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("SJOBS_LIST");
        return true;
    }

    @Override
    protected boolean onStopTask() {
        RTLogger.print(4, "Stopped Server Job: " + this.getName());
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }

    @Override
    public JobConfig getJobConfig() {
        return this.m_config;
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        if (config == null) {
            throw new InvalidConfig("null config");
        }
        this.m_config = config;
        String textInterval = this.m_config.getSchedulingInterval();
        this.setInterval(Interval.parseInterval(textInterval, -1));
    }

    public long getLastProcessingTime() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.getStartTime();
        }
        return this.m_LPT;
    }

    @Override
    public String getLastRunDate() {
        if (this.m_lastTimeStart == 0L) {
            return "-";
        }
        return this.m_sdfDATE.format(new Date(this.m_lastTimeStart));
    }

    @Override
    public String getLastRunTime() {
        return "" + this.getLastProcessingTime();
    }

    public boolean setActive(boolean isActive) {
        this.getJobConfig().setActive(isActive);
        return this.getJobConfig().getActive();
    }
}

