/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.sa.BMClassLoader;
import com.blixx.sa.Scheduler;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.ServerVirtualThreadPool;
import com.blixx.server.jobs.AutoArchiveJob;
import com.blixx.server.jobs.AutoCloseJob;
import com.blixx.server.jobs.AutoDeleteJob;
import com.blixx.server.jobs.CertificateExpirationJob;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.SyncProxyServers;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ServerJobManager {
    private static final String LAST_RESULT_ATTR = "LastResult";
    public static String DIR = "srv/jobs";
    public static String MASK = ".job.xml";
    private Scheduler scheduler = new Scheduler();
    private static volatile ServerJobManager m_sjm = null;
    private final Map<String, ServerJob> serverJobs = new TreeMap<String, ServerJob>();
    private final Map<String, File> jobConfigFiles = new TreeMap<String, File>();
    public static final String STOREXML = "STOREXML";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerJobManager getInstance() {
        if (m_sjm != null) return m_sjm;
        Class<ServerJobManager> clazz = ServerJobManager.class;
        synchronized (ServerJobManager.class) {
            if (m_sjm != null) return m_sjm;
            ServerJobManager sjm = new ServerJobManager();
            sjm.init();
            m_sjm = sjm;
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_sjm;
        }
    }

    public void init() {
        this.scheduler = new Scheduler();
        Thread bsjs = new Thread((Runnable)this.scheduler, "ServerJobsScheduler");
        bsjs.start();
        Path dir = null;
        try {
            dir = Paths.get(ServerEngine.getInstance().getMainDir(), "srv", "jobs");
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            RTLogger.print(1, "error creating server jobs dir", e);
            try {
                dir = Paths.get("srv", "jobs");
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException ex) {
                RTLogger.print(1, "error creating fallback server jobs dir", e);
            }
        }
        File[] arr = dir.toFile().listFiles();
        if (arr != null) {
            for (File f : arr) {
                if (!f.getName().endsWith(MASK)) continue;
                JobConfig jc = new JobConfig();
                try {
                    jc.loadXML(f);
                    this.jobConfigFiles.put(jc.getJobName(), f);
                    this.createServerJob(jc);
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Init of job file " + f.getName() + " failed", e);
                }
            }
        }
        if (this.jobConfigFiles.get("Synchronize_PROXY_Slaves") == null) {
            try {
                this.registerJob(SyncProxyServers.getServerJob());
            }
            catch (Throwable e1) {
                RTLogger.print(1, "SyncProxyServers failed to register", e1);
            }
        }
        if (this.jobConfigFiles.get("Auto Close indications") == null) {
            try {
                this.registerJob(AutoCloseJob.getAutoCloseJob());
            }
            catch (Throwable e1) {
                RTLogger.print(1, "AutoCloseJob failed to register", e1);
            }
        }
        if (this.jobConfigFiles.get("Auto Archive indications") == null) {
            try {
                this.registerJob(AutoArchiveJob.getAutoArchiveJob());
            }
            catch (Throwable e1) {
                RTLogger.print(1, "AutoArchiveJob failed to register", e1);
            }
        }
        if (this.jobConfigFiles.get("Auto Delete indications") == null) {
            try {
                this.registerJob(AutoDeleteJob.getAutoDeleteJob());
            }
            catch (Throwable e1) {
                RTLogger.print(1, "AutoDeleteJob failed to register", e1);
            }
        }
        if (this.jobConfigFiles.get("Certificate expiration check") == null) {
            try {
                this.registerJob(CertificateExpirationJob.getCertificateExpirationJob());
            }
            catch (Throwable e1) {
                RTLogger.print(1, "CertificateExpirationJob failed to register", e1);
            }
        }
        ServerProperties.saveProps();
    }

    private void createServerJob(JobConfig jc) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        Class cl;
        String className = jc.getClassName();
        try {
            cl = BMClassLoader.findClass2(className);
        }
        catch (Throwable e) {
            ServerEngine.getInstance().loadJars();
            cl = BMClassLoader.findClass2(className);
        }
        Constructor constr = cl.getConstructor(JobConfig.class);
        if (constr == null) {
            throw new Exception("{0124} Invalid defined class " + className);
        }
        ServerJob job = (ServerJob)constr.newInstance(jc);
        this.registerJob(job);
    }

    private void registerJob(ServerJob job) throws Exception {
        try {
            job.m_initError = null;
            job.onInit();
        }
        catch (Throwable e) {
            job.m_initError = e;
            job.setActive(false);
        }
        this.serverJobs.put(job.getJobConfig().getJobName(), job);
        if (job.getJobConfig().getActive().booleanValue()) {
            this.scheduler.addTask(job, 0L);
        }
    }

    public void reInit() {
        this.scheduler.stopScheduler();
        this.scheduler.clean();
        this.serverJobs.clear();
        this.jobConfigFiles.clear();
        this.init();
    }

    public String getStatus() {
        Iterator<Map.Entry<String, ServerJob>> it = this.serverJobs.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        if (this.scheduler.isStopped()) {
            sb.append("#Scheduler is stopped\n");
        } else {
            sb.append("#Scheduler is running\n");
        }
        while (it.hasNext()) {
            Map.Entry<String, ServerJob> entry = it.next();
            ServerJob job = entry.getValue();
            String status = "scheduled";
            if (job.m_initError != null) {
                status = "initError";
            } else if (job.isRunning()) {
                status = "running";
            } else if (!this.scheduler.hasTask(job.getName())) {
                status = "stopped";
                job.setActive(false);
            }
            StringBuilder row = new StringBuilder();
            row.append(job.getName()).append('\u25ba').append(job.getJobConfig().getSchedulingInterval()).append('\u25ba').append(job.getJobConfig().getActive()).append('\u25ba').append(status).append('\u25ba').append(job.getLastRunDate()).append('\u25ba').append(job.getLastRunTime());
            if (job.m_initError != null) {
                row.append('\u25ba').append("Error initialization: ").append(job.m_initError.getMessage());
            } else {
                row.append('\u25ba').append(job.getLastRunResult());
            }
            long time = this.scheduler.getNextRunScheduled(job.getName());
            if (time > 0L) {
                try {
                    String nextDate = job.m_sdfDATE.format(new Date(time));
                    row.append('\u25ba').append(nextDate);
                }
                catch (Throwable e) {
                    row.append('\u25ba').append('?');
                }
            } else {
                row.append('\u25ba').append('?');
            }
            row.append('\u25ba').append(job.getJobConfig().getJobDescription());
            String rowStr = row.toString().replace('\n', ' ');
            sb.append(rowStr).append('\n');
        }
        for (Map.Entry<String, File> entry : this.jobConfigFiles.entrySet()) {
            if (this.serverJobs.containsKey(entry.getKey())) continue;
            sb.append(entry.getKey()).append('\u25ba').append('?').append('\u25ba').append("false").append('\u25ba').append("not initialized").append('\u25ba').append('?').append('\u25ba').append('?').append('\u25ba').append('?').append('\u25ba').append('?').append('\u25ba').append("Initialization error").append('\n');
        }
        return sb.toString();
    }

    public void runJobOnce(String name) throws Exception {
        ServerJob job = this.serverJobs.get(name);
        if (job == null || job.m_initError != null) {
            throw new RuntimeException("Job configuration or initialization failed");
        }
        ServerVirtualThreadPool.getInstance().submit(job);
    }

    public void setActive(String jobname, boolean isActive) {
        ServerJob job = this.serverJobs.get(jobname);
        if (job != null && job.m_initError == null && job.getJobConfig().getActive() != isActive) {
            if (isActive = job.setActive(isActive)) {
                this.scheduler.addTask(job, 0L);
            } else {
                this.scheduler.removeTask(job.getName());
            }
            File f = this.jobConfigFiles.get(jobname);
            if (f != null) {
                job.getJobConfig().storeXML(f);
            }
        }
    }

    public void storeConfig(JobConfig jc) {
        String jobName = jc.getJobName();
        File f = this.jobConfigFiles.get(jobName);
        if (f == null) {
            f = new File(DIR + File.separator + FileUtils.getValidFileName(jobName) + MASK);
            this.jobConfigFiles.put(jobName, f);
        }
        jc.storeXML(f);
    }

    public void setConfig(String configXML) throws Exception {
        JobConfig jcfg = new JobConfig();
        jcfg.loadXML(new ByteArrayInputStream(configXML.getBytes()));
        jcfg.getJobGroup().removeAttribute(LAST_RESULT_ATTR);
        ServerJob job = this.serverJobs.get(jcfg.getJobName());
        if (job != null) {
            jcfg.setActive(job.getJobConfig().getActive());
        }
        File f = null;
        CheckAttribute storeAttr = (CheckAttribute)jcfg.getJobGroup().getAttribute(STOREXML);
        if (storeAttr == null || storeAttr.getValue().booleanValue()) {
            f = this.jobConfigFiles.get(jcfg.getJobName());
            if (f == null) {
                f = new File(DIR + File.separator + FileUtils.getValidFileName(jcfg.getJobName()) + MASK);
                this.jobConfigFiles.put(jcfg.getJobName(), f);
            }
            jcfg.storeXML(f);
        }
        if (job != null) {
            job.m_initError = null;
            job.setJobConfig(jcfg);
            this.scheduler.removeTask(job.getName());
            if (job.getJobConfig().getActive().booleanValue()) {
                this.scheduler.addTask(job, 0L);
            }
        } else {
            try {
                this.createServerJob(jcfg);
            }
            catch (Exception e) {
                String fileOrJobName = jcfg.getJobName();
                if (f != null) {
                    fileOrJobName = f.getName();
                }
                RTLogger.print(1, "Init of Server Job configuration " + fileOrJobName + " failed", e);
                throw e;
            }
        }
    }

    public String getConfig(String name) throws Exception {
        JobConfig jc = null;
        ServerJob sj = this.serverJobs.get(name);
        if (sj != null) {
            jc = sj.getJobConfig();
            TextAttribute lastresult = new TextAttribute(LAST_RESULT_ATTR, sj.getLastRunResult(), "Last Result");
            lastresult.setHeight(200);
            lastresult.setEditable(false);
            jc.getJobGroup().addAttribute(lastresult);
        } else {
            File cfgfile = this.jobConfigFiles.get(name);
            jc = new JobConfig();
            jc.loadXML(cfgfile);
            TextAttribute lastresult = new TextAttribute(LAST_RESULT_ATTR, "-", "Last Result");
            lastresult.setEditable(false);
            jc.getJobGroup().addAttribute(lastresult);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        jc.storeXML(bos);
        return bos.toString();
    }

    public void stopScheduler() {
        this.scheduler.stopScheduler();
        this.scheduler.clean();
    }
}

