/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentSyncStatus;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentManager;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.SelectAttribute;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.GroupTreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyncAgentsJob
extends ServerJob {
    private String m_workingdir = "srv/jobs/syncagents";
    private File m_dir;
    String m_currentStatus = "-";
    private SALogger m_logger = new SALogger();
    AtomicBoolean m_hasToStop = new AtomicBoolean(false);
    AtomicInteger m_finishedThreads = new AtomicInteger(0);
    ConcurrentLinkedQueue<AgentCard> m_toRepeat = new ConcurrentLinkedQueue();
    private ThreadPoolExecutor m_threadPool = new ThreadPoolExecutor(2, 10, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private boolean m_ignoreDeploymentQueue = false;
    private boolean m_undeploySingle = false;
    private boolean m_autoDeployASN = false;
    private List<Pattern> m_patterns = new ArrayList<Pattern>();
    private List<String> m_autoDeployASNs = new ArrayList<String>();
    private boolean m_skipDeployment = false;

    public SyncAgentsJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        List<String> messages = this.initVariables();
        this.initLogfile();
        this.m_logger.print(2, String.valueOf(this.getClass()));
        this.m_logger.print(1, "init done");
        if (messages != null && messages.size() > 0) {
            for (String str : messages) {
                this.m_logger.print(1, str);
            }
        }
        this.printValues();
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_currentStatus;
    }

    @Override
    public boolean onStartRun() {
        this.m_logger.print(1, "\n\njob started: SyncAgentJob");
        this.m_finishedThreads.set(0);
        return true;
    }

    @Override
    public boolean onGetData() {
        AgentCard[] secondTry;
        AgentCard agentCard;
        this.m_toRepeat.clear();
        this.m_currentStatus = "Starting";
        ArrayList<AgentCard> list = new ArrayList<AgentCard>(ServerEngine.getInstance().getAgentRepository().getAgentCards().values());
        Iterator<AgentCard> it = list.iterator();
        while (it.hasNext()) {
            agentCard = it.next();
            if (!agentCard.isLocalAgent() || agentCard.getAgentPort() == 0) {
                it.remove();
                continue;
            }
            boolean isMatchedAtLeastOne = true;
            if (this.m_patterns != null && this.m_patterns.size() > 0) {
                isMatchedAtLeastOne = false;
                for (Pattern p : this.m_patterns) {
                    Matcher m = p.matcher(agentCard.getLabel());
                    if (!m.matches()) continue;
                    isMatchedAtLeastOne = true;
                    break;
                }
            }
            if (isMatchedAtLeastOne) continue;
            it.remove();
        }
        this.m_finishedThreads.set(0);
        this.m_logger.print(1, "Local Agents to process: " + list.size());
        it = list.iterator();
        while (it.hasNext()) {
            this.m_currentStatus = "Try #1. Completed: " + this.m_finishedThreads.get() + " of " + list.size();
            agentCard = it.next();
            this.processAgent(agentCard, 1);
        }
        while (this.m_finishedThreads.get() < list.size() && !this.m_hasToStop.get()) {
            try {
                this.m_currentStatus = "Try #1. Completed: " + this.m_finishedThreads.get() + " of " + list.size();
                Thread.sleep(1000L);
            }
            catch (InterruptedException agentCard2) {}
        }
        if (this.m_hasToStop.get()) {
            return true;
        }
        this.m_finishedThreads.set(0);
        for (AgentCard ac : secondTry = this.m_toRepeat.toArray(new AgentCard[0])) {
            this.processAgent(ac, 2);
        }
        while (this.m_finishedThreads.get() < secondTry.length && !this.m_hasToStop.get()) {
            try {
                this.m_currentStatus = "Try #2. Completed: " + this.m_finishedThreads.get() + " of " + secondTry.length;
                Thread.sleep(1000L);
            }
            catch (InterruptedException isMatchedAtLeastOne) {}
        }
        StringBuffer result = new StringBuffer("Finish sync of ");
        result.append(list.size()).append(" agents.");
        if (this.m_skipDeployment) {
            result.append(" Simulated. (Deployments skipped)");
        }
        result.append("\nPlease see logfile for further details: ").append(this.m_logger.getCurrentFileName());
        if (this.m_toRepeat.size() > 0) {
            result.append("\nFailed Agents:\n");
            Iterator<AgentCard> itt = this.m_toRepeat.iterator();
            while (itt.hasNext()) {
                AgentCard ac = itt.next();
                result.append(" (").append(ac.getAgentID()).append(") ").append(ac.getAgentHost());
                if (!itt.hasNext()) continue;
                result.append('\n');
            }
            this.m_toRepeat.clear();
        }
        this.m_currentStatus = result.toString();
        this.m_logger.print(1, result);
        return true;
    }

    private void processAgent(final AgentCard agentCard, final int tryNumber) {
        while (true) {
            try {
                this.m_threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        SyncAgentsJob.this._processAgent(agentCard, tryNumber);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (this.m_hasToStop.get()) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {}
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processAgent(AgentCard agentCard, int tryNumber) {
        StringBuffer sb = new StringBuffer();
        try {
            boolean needToSyncBinaries;
            boolean needToSyncPolicies;
            sb.append("try#").append(tryNumber);
            sb.append(" (").append(agentCard.getAgentID()).append(") ").append(agentCard.getAgentHost());
            AgentSyncStatus async = new AgentSyncStatus(agentCard, this.m_ignoreDeploymentQueue, this.m_undeploySingle, this.m_autoDeployASN ? this.m_autoDeployASNs : null);
            List<String> asnToDeploy = async.checkUnassignedGroups(this.m_skipDeployment);
            if (asnToDeploy != null && asnToDeploy.size() > 0) {
                sb.append(" +AsnGrp: ").append(asnToDeploy);
            }
            if (needToSyncPolicies = async.checkAssignedPolicies()) {
                if (async.getMonToUndeploy().size() > 0) {
                    sb.append(" -Mon: ").append(async.getMonToUndeploy());
                }
                if (async.getMsgToUndeploy().size() > 0) {
                    sb.append(" -Msg: ").append(async.getMsgToUndeploy());
                }
                if (async.getMonToDeploy().size() > 0) {
                    sb.append(" +Mon: ").append(async.getMonToDeploy());
                }
                if (async.getMsgToDeploy().size() > 0) {
                    sb.append(" +Msg: ").append(async.getMsgToDeploy());
                }
            }
            if (needToSyncBinaries = async.checkBinaryPackages()) {
                if (async.getBinpackagesToUnDeploy().size() > 0) {
                    sb.append(" -Bin: ").append(async.getBinpackagesToUnDeploy());
                }
                if (async.getBinpackagesUnsync().size() > 0) {
                    sb.append(" +Bin: ").append(async.getBinpackagesUnsync());
                }
            }
            if (!needToSyncPolicies && !needToSyncBinaries) {
                sb.append(" ---Checked, OK---");
            } else if (!this.m_skipDeployment) {
                DeployClient pd;
                DeployClient pu;
                LinkedList<DeployClient> started = new LinkedList<DeployClient>();
                if (async.getBinpackagesToUnDeploy().size() > 0) {
                    List<DeployClient> bu = ServerEngine.getInstance().getBinariesRepository().undeploy(agentCard, async.getBinpackagesToUnDeploy());
                    started.addAll(bu);
                }
                if (async.getBinpackagesUnsync().size() > 0) {
                    List<DeployClient> bd = ServerEngine.getInstance().getBinariesRepository().deploy(agentCard, async.getBinpackagesUnsync());
                    started.addAll(bd);
                    DeploymentManager.waitDeploymentsStarted(bd);
                }
                if ((async.getMonToUndeploy().size() > 0 || async.getMsgToUndeploy().size() > 0) && (pu = ServerEngine.getInstance().getPolicyRepository().undeploy(agentCard, async.getMonToUndeploy(), async.getMsgToUndeploy())) != null) {
                    started.add(pu);
                }
                if ((async.getMonToDeploy().size() > 0 || async.getMsgToDeploy().size() > 0) && (pd = ServerEngine.getInstance().getPolicyRepository().deploy(agentCard, async.getMonToDeploy(), async.getMsgToDeploy())) != null) {
                    started.add(pd);
                }
                this.waitDeployClients(started);
                sb.append(" ---Synchronized, OK---");
            } else {
                sb.append(" ---Deployment Skipped---");
            }
            this.m_logger.print(1, sb.toString());
        }
        catch (Throwable e) {
            sb.append(" ---Error: ").append(e.getMessage()).append("---");
            this.m_logger.print(1, sb.toString());
            if (!this.m_toRepeat.contains(agentCard)) {
                this.m_toRepeat.offer(agentCard);
            }
        }
        finally {
            this.m_finishedThreads.incrementAndGet();
        }
    }

    public String waitDeployClients(List<DeployClient> started) {
        StringBuilder sb = new StringBuilder();
        long startWait = System.currentTimeMillis();
        while (started.size() > 0) {
            Iterator<DeployClient> it = started.iterator();
            while (it.hasNext()) {
                DeployClient dc = it.next();
                if (dc.isReady()) {
                    it.remove();
                    sb.append(dc);
                    if (dc.getResult().resultCode == 0) continue;
                    throw new RuntimeException(sb.toString());
                }
                if (System.currentTimeMillis() - startWait <= 900000L) continue;
                dc.cancel();
                it.remove();
            }
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
        return sb.toString();
    }

    @Override
    public boolean onStopRun() {
        this.m_logger.print(1, "job finished: SyncAgentJob\n");
        this.m_logger.getPrintStream(false).close();
        return true;
    }

    @Override
    public boolean stopTask() {
        this.m_hasToStop.compareAndSet(false, true);
        return super.stopTask();
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        try {
            this.onInit();
            this.printValues();
        }
        catch (Exception e) {
            throw new InvalidConfig(e.getMessage());
        }
    }

    public List<String> initVariables() throws Exception {
        LinkedList<String> messages = new LinkedList<String>();
        JobConfig jc = super.getJobConfig();
        Group syncGroup = jc.getConfig().getGroup("SYNC");
        if (syncGroup != null) {
            String[] arr;
            TextAttribute asnList;
            String text;
            Boolean bln;
            String val;
            AbstractAttribute ca;
            AbstractAttribute aa = syncGroup.getAttribute("ignoreDeploymentsQueue");
            if (aa != null && aa instanceof SelectAttribute) {
                ca = (SelectAttribute)aa;
                val = ((SelectAttribute)ca).getValue();
                this.m_ignoreDeploymentQueue = "yes".equalsIgnoreCase(val);
            }
            if (aa != null && aa instanceof CheckAttribute && (bln = ((CheckAttribute)(ca = (CheckAttribute)aa)).getValue()) != null) {
                this.m_ignoreDeploymentQueue = bln;
            }
            if ((aa = syncGroup.getAttribute("undeploySingle")) != null && aa instanceof SelectAttribute) {
                ca = (SelectAttribute)aa;
                val = ((SelectAttribute)ca).getValue();
                this.m_undeploySingle = "yes".equalsIgnoreCase(val);
            }
            if (aa != null && aa instanceof CheckAttribute && (bln = ((CheckAttribute)(ca = (CheckAttribute)aa)).getValue()) != null) {
                this.m_undeploySingle = bln;
            }
            if ((aa = syncGroup.getAttribute("skipDeployments")) != null && aa instanceof SelectAttribute) {
                ca = (SelectAttribute)aa;
                val = ((SelectAttribute)ca).getValue();
                this.m_skipDeployment = "yes".equalsIgnoreCase(val);
            }
            if (aa != null && aa instanceof CheckAttribute && (bln = ((CheckAttribute)(ca = (CheckAttribute)aa)).getValue()) != null) {
                this.m_skipDeployment = bln;
            }
            if ((aa = syncGroup.getAttribute("autoDeploy")) != null && aa instanceof SelectAttribute) {
                ca = (SelectAttribute)aa;
                val = ((SelectAttribute)ca).getValue();
                this.m_autoDeployASN = true;
            }
            if (aa != null && aa instanceof CheckAttribute && (bln = ((CheckAttribute)(ca = (CheckAttribute)aa)).getValue()) != null) {
                this.m_autoDeployASN = bln;
            }
            this.m_autoDeployASNs.clear();
            aa = syncGroup.getAttribute("autoDeployASN");
            if (aa != null && aa instanceof TextAttribute && (text = (asnList = (TextAttribute)aa).getValue()) != null && text.trim().length() > 0 && (arr = text.split("[\r\n]+")) != null && arr.length > 0) {
                for (String asnName : arr) {
                    GroupTreeObject gtoASN = ServerEngine.getInstance().getAssignmentRepository().getAsnTree().findFirstGroup(asnName, "pga");
                    if (gtoASN != null) {
                        this.m_autoDeployASNs.add(asnName);
                        continue;
                    }
                    messages.add("Assignment group not found. Ignored name: " + asnName);
                }
            }
            this.m_patterns.clear();
            aa = syncGroup.getAttribute("agentLabelFilter");
            if (aa != null && aa instanceof TextAttribute && (text = (asnList = (TextAttribute)aa).getValue()) != null && text.trim().length() > 0 && (arr = text.split("[\r\n]+")) != null && arr.length > 0) {
                for (String pattern : arr) {
                    try {
                        Pattern p = Pattern.compile(pattern);
                        this.m_patterns.add(p);
                    }
                    catch (Throwable e) {
                        throw new Exception("Invalid pattern: " + pattern);
                    }
                }
            }
        }
        return messages;
    }

    public void initLogfile() {
        this.m_logger.setMaxCount(super.getJobConfig().getLogcount());
        this.m_logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.m_logger.setDir(this.m_workingdir, "SyncAgents");
        this.m_logger.setLevel(super.getJobConfig().getLoglevel());
    }

    private void printValues() {
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.m_logger.print(1, "skip Deployments: " + this.m_skipDeployment);
        this.m_logger.print(1, "ignore Deployment queue: " + this.m_ignoreDeploymentQueue);
        this.m_logger.print(1, "undeploy Single Deployed: " + this.m_undeploySingle);
        this.m_logger.print(1, "auto deploy: " + this.m_autoDeployASN);
        this.m_logger.print(1, "auto deploy Assignmen Groups: " + String.valueOf(this.m_autoDeployASNs));
        this.m_logger.print(1, "agent filters: " + String.valueOf(this.m_patterns));
    }
}

