/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.UnsupportedTypeException;

public class SyncProxyServers
extends ServerJob {
    public static final String JOB_NAME = "Synchronize_PROXY_Slaves";
    private static ServerJob m_this = null;
    protected String m_lastResult = "-";

    public static synchronized ServerJob getServerJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Synchronize Binary packages, Policies and Assignments on PROXY servers");
            jc.setSchedulingInterval("10m");
            jc.getJobGroup().getAttribute("scheduling").setEditable(true);
            jc.setClassName(SyncProxyServers.class.getCanonicalName());
            jc.setActive(true);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            AbstractAttribute active = jc.getJobGroup().getAttribute("active");
            try {
                active.setValue(Boolean.FALSE);
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                // empty catch block
            }
            active.setEditable(true);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new SyncProxyServers(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "SyncProxyServers initialization failed", e);
            }
        }
        return m_this;
    }

    public SyncProxyServers(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
    }

    @Override
    public boolean onGetData() {
        try {
            StringBuffer res = new StringBuffer();
            int foundProxies = 0;
            for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
                if (ssc.getScenario() > 1 && ssc.getScenario() != 8) continue;
                ++foundProxies;
                res = ServerEngine.getInstance().getSlaveServerFactory().syncProxy(ssc, res);
            }
            if (foundProxies == 0) {
                res.append("No Proxy servers found");
            }
            this.m_lastResult = res.toString();
            if (this.m_lastResult.length() == 0) {
                this.m_lastResult = "No PROXY servers configured.";
            }
        }
        catch (Throwable e) {
            this.m_lastResult = "Error: " + e.getMessage();
            RTLogger.print(2, "SyncProxyServer ERROR.", e);
        }
        RTLogger.print(3, this.m_lastResult);
        return true;
    }
}

