/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.SPolicyRepository;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.utils.FileSyncUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyncSlavePoliciesJob
extends ServerJob {
    public static final String JOB_NAME = "Synchronize Policies on PROXY Slaves";
    private static ServerJob m_this = null;
    protected String m_lastResult = "-";
    protected boolean isUpdateForcePossible = false;

    public static synchronized ServerJob getServerJob() {
        if (m_this == null) {
            JobConfig jc = new JobConfig();
            jc.setJobName(JOB_NAME);
            jc.setJobDescription("Automatically Synchronize policies on PROXY servers");
            jc.setSchedulingInterval("10m");
            jc.getJobGroup().getAttribute("scheduling").setEditable(true);
            jc.setClassName(SyncSlavePoliciesJob.class.getCanonicalName());
            jc.setActive(true);
            jc.getJobGroup().getAttribute("jobname").setEditable(false);
            jc.getJobGroup().getAttribute("jobDescription").setEditable(false);
            jc.getJobGroup().getAttribute("class").setEditable(false);
            jc.getJobGroup().getAttribute("active").setEditable(true);
            CheckAttribute ac = new CheckAttribute("STOREXML", true, "Store XML file");
            ac.setEditable(false);
            ac.setEnabled(false);
            jc.getJobGroup().addAttribute(ac);
            try {
                m_this = new SyncSlavePoliciesJob(jc);
            }
            catch (Throwable e) {
                RTLogger.print(2, "SyncSlavePoliciesJob initialization failed", e);
            }
        }
        return m_this;
    }

    public SyncSlavePoliciesJob(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    @Override
    public JobConfig getJobConfig() {
        return super.getJobConfig();
    }

    @Override
    public boolean onGetData() {
        StringBuffer res = new StringBuffer();
        for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
            this.syncPoliciesAndPolicyGroup(res, ssc);
        }
        this.m_lastResult = res.toString();
        if (this.m_lastResult.length() == 0) {
            this.m_lastResult = "No PROXY servers configured.";
        }
        RTLogger.print(3, this.m_lastResult);
        return true;
    }

    public synchronized void syncPoliciesAndPolicyGroup(StringBuffer res, SlaveServerCard ssc) {
        this.isUpdateForcePossible = ssc.getServerClientStandAlone().run("VALIDATE_CMD", "UPDATEPOLICY_FORCE", new String[0]);
        this.syncPolicies(res, ssc);
        this.syncPolicyGroup(res, ssc);
    }

    private void syncPolicyGroup(StringBuffer res, SlaveServerCard ssc) {
        SPolicyRepository prep = ServerEngine.getInstance().getPolicyRepository();
        ServerClient sc = ssc.getServerClientStandAlone();
        String policyGroupsFilePath = "srv/" + "policies" + "/" + "policyGroups.xml";
        sc.run("GET_DIR_HASH", policyGroupsFilePath, new String[0]);
        if (sc.isSuccess()) {
            String all = (String)sc.getResultObject();
            try {
                String report = FileSyncUtils.verifyDigest(new File(policyGroupsFilePath), all, false);
                String[] lines = report.split("\n");
                Pattern p1 = Pattern.compile("\\[(\\S+)\\](.+)(/?)");
                for (int i = 0; i < lines.length; ++i) {
                    Matcher m = p1.matcher(lines[i]);
                    if (m.matches()) {
                        if (!m.group(1).equals("OK")) {
                            if (sc.run("MASTER_UPDATE", "POLICIES", new String[]{policyGroupsFilePath})) {
                                res.append("Policy tree updated\n");
                                continue;
                            }
                            res.append("Policy tree update failed!\n");
                            continue;
                        }
                        res.append("Policy tree in sync\n");
                        continue;
                    }
                    res.append("Policy tree in sync\n");
                }
            }
            catch (Throwable t) {
                res.append("Policy tree update failed: " + t.getMessage());
            }
        } else {
            res.append(" FAILED\n");
            res.append(sc.getResultObject());
        }
    }

    private void syncPolicies(StringBuffer res, SlaveServerCard ssc) {
        int synced = 0;
        SPolicyRepository prep = ServerEngine.getInstance().getPolicyRepository();
        Map<String, AbstractPolicy> known = prep.getAllPolicyMap();
        Pattern p = Pattern.compile(".*/(\\S+) (mon|msg) ([\\d\\.]+)");
        if (ssc.getScenario() <= 1 || ssc.getScenario() == 8) {
            res.append(ssc.getHostName());
            if (!ssc.m_bc.isOnline()) {
                res.append(" FAILED\n");
                res.append(" server is offline\n");
            } else {
                ServerClient sc = ssc.getServerClientStandAlone();
                sc.run("GET_POLICY_VERSIONS", null, new String[0]);
                LinkedList<String> toDelete = new LinkedList<String>();
                if (sc.isSuccess()) {
                    res.append(" OK\n");
                    String all = (String)sc.getResultObject();
                    String[] lines = all.split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        Matcher m;
                        if (lines[i].length() <= 3 || !(m = p.matcher(lines[i])).matches()) continue;
                        String pname = m.group(1);
                        String type = m.group(2);
                        String version = m.group(3);
                        AbstractPolicy policy = null;
                        if ("mon".equals(type)) {
                            policy = prep.getMonitorPolicy(pname);
                        } else if ("msg".equals(type)) {
                            policy = prep.getMessagePolicy(pname);
                        }
                        if (policy == null) {
                            toDelete.add(pname);
                            toDelete.add(type);
                            toDelete.add("");
                        } else if (!policy.getVersion().equals(version)) {
                            if (this.pushPolicyToProxies(ssc, policy)) {
                                ++synced;
                            } else {
                                RTLogger.print(2, "Failed to push: " + pname + " on proxy server " + ssc.getHostName());
                            }
                        }
                        known.remove(pname);
                    }
                    for (Map.Entry<String, AbstractPolicy> en : known.entrySet()) {
                        if (this.pushPolicyToProxies(ssc, en.getValue())) {
                            ++synced;
                            continue;
                        }
                        RTLogger.print(2, "Failed to push: " + en.getKey() + " on proxy server " + ssc.getHostName());
                    }
                    if (toDelete.size() > 0) {
                        sc.run("DELETEPOLICY", null, toDelete.toArray(new String[0]));
                        if (sc.isSuccess()) {
                            synced += toDelete.size();
                        } else {
                            RTLogger.print(2, "Error deleting policies on proxy server " + ssc.getHostName());
                        }
                    }
                } else {
                    res.append(" FAILED\n");
                    res.append(sc.getResultObject());
                }
            }
        }
        res.append("Synchronized ").append(synced).append(" policies\n");
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
    }

    private boolean pushPolicyToProxies(SlaveServerCard ssc, AbstractPolicy ap) {
        if (ap == null) {
            return false;
        }
        String objectName = "";
        String objectType = "";
        String filename = "";
        String treePath = "";
        if (ap instanceof Policy) {
            Policy p = (Policy)ap;
            objectName = p.getName();
            objectType = "mon";
        } else if (ap instanceof MsgPolicy) {
            MsgPolicy mp = (MsgPolicy)ap;
            objectName = mp.getName();
            objectType = "msg";
        }
        SPolicyRepository policyRepository = ServerEngine.getInstance().getPolicyRepository();
        filename = policyRepository.getFilename(objectName);
        treePath = policyRepository.getPolicyTree().findElement(objectName, objectType).getParentPath();
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "PUSH " + objectName);
        }
        return ssc.getServerClientStandAlone().run(this.isUpdateForcePossible ? "UPDATEPOLICY_FORCE" : "UPDATEPOLICY", null, new String[]{objectName, objectType, SPolicyRepository.getPolicyDir() + "/" + filename, treePath});
    }
}

