/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.server.GUIWorker;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.TooOldFiles;
import com.blixx.shared.BM;
import com.blixx.shared.User;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class UserExport
extends ServerJob {
    private static final String YYYY_DD_MM_HH_MM_SS = "yyyy-dd-MM-HH-mm-ss";
    public static final String ATTR_FILE_MASK_DATE_FORMAT = "fileMaskDateFormat";
    public static final String ATTR_FILE_MASK = "fileMask";
    public static final String ATTR_WORKING_DIR = "workingDir";
    public static final String ATTR_KEEPFILES_DAYS = "keepFilesDays";
    public static final String GROUP_USERS = "USERS";
    public static final String VAR_DATE = "<$DATE>";
    private String fileMask = BM.PRODUCT_lowercase + "_<$DATE>.csv";
    private String fileMaskDateFormat = "yyyy-dd-MM-HH-mm-ss";
    private String workingdir = "srv/jobs/userexport";
    private File workingdirFile;
    private int keepFilesDays = 7;
    private SALogger logger = new SALogger();
    public String lastResult = "-";
    public static final String LDAP = "LDAP";

    public UserExport(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        this.initLogfile();
        this.printValues();
        this.logger.print(2, String.valueOf(this.getClass()));
        this.logger.print(1, "init done");
        return true;
    }

    @Override
    public boolean onStartRun() {
        this.logger.print(1, "job started UserExport");
        try {
            if (!this.workingdirFile.exists()) {
                try {
                    Files.createDirectories(this.workingdirFile.toPath(), new FileAttribute[0]);
                    this.initLogfile();
                    this.printValues();
                    this.logger.print(1, "working directory created " + this.workingdirFile.getPath());
                }
                catch (Exception e) {
                    this.logger.print(1, "Error creating worker directory: " + this.workingdir, e);
                }
            } else {
                this.logger.print(3, "directory exist. " + this.workingdirFile.getCanonicalPath());
            }
            File[] toDelete = this.workingdirFile.listFiles(new TooOldFiles(this.keepFilesDays, null, ".csv"));
            if (toDelete != null) {
                this.logger.print(3, "old files to delete: " + toDelete.length);
                for (File file : toDelete) {
                    try {
                        Files.deleteIfExists(file.toPath());
                    }
                    catch (Exception e) {
                        this.logger.print(1, ERROR + "can't delete old file: " + String.valueOf(file), e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.print(3, "", e);
        }
        return super.onStartRun();
    }

    @Override
    public boolean onGetData() {
        this.logger.print(3, "starting...");
        File outFile = this.getFile(new Date());
        try (PrintWriter pw = new PrintWriter(outFile);){
            StringBuilder header = new StringBuilder();
            header.append("USER_ROLE").append(';').append("LOGIN").append(';').append("LAST_NAME").append(';').append("FIRST_NAME").append(';').append("TYPE").append(';').append("ACTIVATION_STATUS").append(';').append("ONLINE_STATUS");
            pw.println(header.toString());
            HashMap<String, String> connectedUsers = new HashMap<String, String>();
            ArrayList users = new ArrayList(GUIWorker.m_users.keySet());
            for (String s : users) {
                connectedUsers.put(s, "");
            }
            ArrayList<String> userLine = new ArrayList<String>();
            for (User user : UserManager.getInstance().getUsers()) {
                String roleName = user.getRoleName();
                this.logger.print(3, "processing user login: " + user.getLoginName());
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append('\"').append(roleName).append('\"').append(';').append('\"').append(user.getLoginName()).append('\"').append(';').append('\"').append(user.getLastName()).append('\"').append(';').append('\"').append(user.getFirstName()).append('\"').append(';');
                    if (user.getEncryptedPwd().equals(LDAP)) {
                        sb.append('\"').append(LDAP).append('\"').append(';');
                    } else {
                        sb.append('\"').append("BOOM").append('\"').append(';');
                    }
                    if (user.getActive() == 0) {
                        sb.append('\"').append("DISABLED").append('\"').append(';');
                    } else {
                        sb.append('\"').append("ENABLED").append('\"').append(';');
                    }
                    if (connectedUsers.containsKey(user.getLoginName())) {
                        sb.append('\"').append("ONLINE").append('\"');
                    } else {
                        sb.append('\"').append("OFFLINE").append('\"');
                    }
                    userLine.add(sb.toString());
                }
                catch (Throwable e) {
                    this.logger.print(1, ERROR + "Error occurred during processing user login: " + user.getLoginName(), e);
                }
            }
            Collections.sort(userLine);
            for (String line : userLine) {
                pw.println(line);
            }
            this.lastResult = "Output file: " + outFile.getName();
            this.logger.print(2, "Output file: " + outFile.getName());
            this.logger.print(1, SUCCESS + "job finished UserExport");
        }
        catch (Exception e) {
            this.lastResult = "Error " + e.getMessage();
            if (outFile != null) {
                this.logger.print(1, ERROR + "Error creating output file " + outFile.getName());
            }
            this.logger.print(1, ERROR, e);
        }
        return true;
    }

    @Override
    public String getLastRunResult() {
        return this.lastResult;
    }

    public void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_USERS);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_WORKING_DIR);
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.workingdir = aa.getValue();
        this.workingdirFile = new File(this.workingdir);
        if (!this.workingdirFile.exists()) {
            this.workingdirFile.mkdirs();
            this.logger.print(1, "working directory created " + this.workingdirFile.getPath());
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK)) == null) {
            throw new InvalidConfig("fileMask is null");
        }
        this.fileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK_DATE_FORMAT);
        if (aa == null) {
            throw new InvalidConfig("fileMaskDateFormat is null");
        }
        try {
            new SimpleDateFormat(aa.getValue());
            this.fileMaskDateFormat = aa.getValue();
        }
        catch (Throwable e) {
            this.logger.print(1, ERROR + "unsupported fileMaskDateFormat" + aa.getValue());
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_KEEPFILES_DAYS);
        if (aa != null) {
            try {
                this.keepFilesDays = Integer.parseInt(aa.getValue());
            }
            catch (Throwable e) {
                this.logger.print(1, ERROR + "invalid value for attribute: keepFilesDays");
            }
        }
    }

    public void initLogfile() {
        this.logger.setMaxCount(super.getJobConfig().getLogcount());
        this.logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.logger.setDir(this.workingdir, "userexport");
        this.logger.setLevel(super.getJobConfig().getLoglevel());
    }

    private void printValues() {
        this.logger.print(1, "working dir: " + this.workingdir);
        this.logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.logger.print(1, "keepFilesDays: " + this.keepFilesDays);
        this.logger.print(1, "filemask: " + this.fileMask);
        this.logger.print(1, "filemask Date format: " + this.fileMaskDateFormat);
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        JobConfig bkp = this.m_config;
        try {
            super.setJobConfig(config);
            this.onInit();
        }
        catch (Exception e) {
            this.logger.print(1, ERROR + "Error processing new configuration. Rollback.");
            try {
                super.setJobConfig(bkp);
                this.onInit();
            }
            catch (Throwable e1) {
                this.logger.print(1, ERROR + "Rollback failed");
            }
            throw new InvalidConfig(e);
        }
    }

    public String getFileMaskDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_DD_MM_HH_MM_SS);
        try {
            sdf = new SimpleDateFormat(this.fileMaskDateFormat);
        }
        catch (Exception e) {
            this.logger.print(3, "Wrong date format: %s", this.fileMaskDateFormat, e);
        }
        return sdf.format(date);
    }

    public String getFilename(Date time) {
        String res = this.fileMask.replace(VAR_DATE, this.getFileMaskDate(time));
        res = res.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
        return res;
    }

    public File getFile(Date time) {
        String filename = this.getFilename(time);
        return new File(this.workingdirFile, filename);
    }
}

