/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.UUID;

public class VirtualAgentImport
extends ServerJob {
    private final String workingdir = "srv/jobs/vagentsimport";
    public File virtualAgents = null;
    String lastResult = "";
    boolean isImportWithAgentID = false;
    private final SALogger saLogger = new SALogger();

    public VirtualAgentImport(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group paramGroups = jc.getConfig().getGroup("PARAMETERS");
        if (paramGroups == null) {
            throw new Exception("Invalid config file. PARAMETERS section not found.");
        }
        AbstractAttribute aa = paramGroups.getAttribute("ImportFile");
        if (aa == null) {
            throw new Exception("Invalid config file. ImportFile attribute not found.");
        }
        if (!(aa instanceof TextAttribute)) {
            throw new Exception("Invalid config file. ImportFile attribute has wrong type.");
        }
        TextAttribute ta = (TextAttribute)aa;
        File dir = new File("srv/jobs/vagentsimport");
        if (!dir.exists() && !dir.mkdirs()) {
            RTLogger.print(5, "Error creating dir: srv/jobs/vagentsimport");
        }
        this.virtualAgents = new File(dir, ta.getValue());
        AbstractAttribute ab = paramGroups.getAttribute("ImportWithAgentID");
        if (ab instanceof CheckAttribute) {
            CheckAttribute cab = (CheckAttribute)ab;
            this.isImportWithAgentID = cab.getValue();
        }
        this.initLogfile();
        StringBuilder sb = new StringBuilder();
        sb.append("Input file: ").append(this.virtualAgents.getAbsolutePath()).append(" exist: ").append(this.virtualAgents.exists());
        this.saLogger.print(1, sb);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        StringBuilder sb = new StringBuilder();
        sb.append("Input file: ").append(this.virtualAgents.getAbsolutePath()).append(" exist: ").append(this.virtualAgents.exists());
        this.saLogger.print(1, sb);
        try (FileReader fr = new FileReader(this.virtualAgents);
             BufferedReader br = new BufferedReader(fr);){
            StrUtils su = new StrUtils();
            String line = null;
            int countCreated = 0;
            int countUpdated = 0;
            int countFailed = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] arr = su.split(line, ';');
                if (arr.length >= 4) {
                    AgentCard ac = null;
                    String agentID = su.removeQuotesStrict(arr[0]);
                    String label = su.removeQuotesStrict(arr[1]);
                    String host = su.removeQuotesStrict(arr[2]);
                    String ip = su.removeQuotesStrict(arr[3]);
                    String description = null;
                    if (arr.length > 4) {
                        description = su.removeQuotesStrict(arr[4]);
                    }
                    if (agentID != null && agentID.length() > 0) {
                        try {
                            UUID.fromString(agentID);
                        }
                        catch (Throwable e) {
                            this.saLogger.print(1, "invalid agent ID: " + agentID);
                            agentID = "";
                        }
                        ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID);
                        if (ac != null) {
                            if (ac.getAgentPort() != 0) {
                                this.saLogger.print(1, "Can not update real existing agent ID: " + agentID);
                                ++countFailed;
                                continue;
                            }
                        } else if (!this.isImportWithAgentID) {
                            this.saLogger.print(1, "Can not find existing virtual agent with ID: " + agentID);
                            ++countFailed;
                            continue;
                        }
                    }
                    if (ac != null) {
                        this.setACfields(ac, label, host, ip, description);
                        ServerEngine.getInstance().getAgentRepository().getAgentCards().put(ac.getAgentID(), ac);
                        ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(ac);
                        this.saLogger.print(1, "updated AgentCard: " + String.valueOf(ac));
                        ServerEngine.getInstance().getAuditLog().logModify(VirtualAgentImport.class.getName(), ac.toString());
                        ++countUpdated;
                    } else if (this.isImportWithAgentID && agentID != null) {
                        AgentCard existingByID = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID);
                        if (existingByID == null) {
                            ac = new AgentCard(agentID, host, ip, label, description);
                            ServerEngine.getInstance().getAgentRepository().getAgentCards().put(ac.getAgentID(), ac);
                            ServerEngine.getInstance().getAgentRepository().saveAgentCard(ac);
                            ++countCreated;
                            this.saLogger.print(1, "created AgentCard: " + String.valueOf(ac));
                            ServerEngine.getInstance().getAuditLog().logCreate(VirtualAgentImport.class.getName(), ac.toString());
                        } else if (existingByID.getAgentPort() != 0) {
                            this.saLogger.print(1, "Can not update existing agent with ID: " + agentID + ". It's not a Virtual Agent!");
                        } else {
                            this.setACfields(existingByID, label, host, ip, description);
                            ServerEngine.getInstance().getAgentRepository().getAgentCards().put(existingByID.getAgentID(), existingByID);
                            ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(existingByID);
                            this.saLogger.print(1, "updated AgentCard: " + String.valueOf(existingByID));
                            ServerEngine.getInstance().getAuditLog().logModify(VirtualAgentImport.class.getName(), existingByID.toString());
                            ++countUpdated;
                        }
                    } else {
                        AgentCard existingByHostAndIP = ServerEngine.getInstance().getAgentRepository().getAgentCardVirtual(host, ip);
                        if (existingByHostAndIP != null) {
                            this.setACfields(existingByHostAndIP, label, host, ip, description);
                            ServerEngine.getInstance().getAgentRepository().getAgentCards().put(existingByHostAndIP.getAgentID(), existingByHostAndIP);
                            ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(existingByHostAndIP);
                            this.saLogger.print(1, "updated AgentCard: " + String.valueOf(existingByHostAndIP));
                            ServerEngine.getInstance().getAuditLog().logModify(VirtualAgentImport.class.getName(), existingByHostAndIP.toString());
                            ++countUpdated;
                        } else {
                            ac = new AgentCard(host, ip, label, description);
                            ServerEngine.getInstance().getExternalHostResolver().addExternalHost(ac, VirtualAgentImport.class.getName());
                            ++countCreated;
                        }
                    }
                } else {
                    this.saLogger.print(1, "invalid line: " + line);
                    ++countFailed;
                }
                this.setStatus(countCreated, countUpdated, countFailed);
            }
            this.setStatus(countCreated, countUpdated, countFailed);
        }
        catch (Throwable e) {
            this.lastResult = "Error: " + e.getMessage() + " File:" + this.virtualAgents.getAbsolutePath();
        }
        finally {
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        this.saLogger.print(1, "job finished: SyncAgentJob\n");
        this.saLogger.getPrintStream(false).close();
        return true;
    }

    private void setStatus(int countCreated, int countUpdated, int countFailed) {
        this.lastResult = "Created: " + countCreated + " updated: " + countUpdated + " failed: " + countFailed;
    }

    private void setACfields(AgentCard ac, String label, String host, String ip, String description) {
        if (label != null && label.length() > 0) {
            ac.setLabel(label);
        }
        if (host != null && host.length() > 0) {
            ac.setNewAgentHost(host);
        }
        if (ip != null && ip.length() > 0) {
            ac.setNewAgentIP(ip);
        }
        if (description != null) {
            ac.setDescription(description);
        }
    }

    @Override
    public String getLastRunResult() {
        return this.lastResult;
    }

    public void initLogfile() {
        this.saLogger.setMaxCount(super.getJobConfig().getLogcount());
        this.saLogger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.saLogger.setDir("srv/jobs/vagentsimport", "ImportVirtualAgents");
        this.saLogger.setLevel(1);
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        super.setJobConfig(config);
        try {
            this.onInit();
        }
        catch (Throwable e) {
            throw new InvalidConfig("Init failed", e);
        }
    }
}

