/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.notify;

import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.server.notify.QueuedNotifier;
import com.blixx.shared.notify.NotificationMsg;
import com.blixx.shared.notify.Notifier;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.notify.Worker;
import java.nio.file.Path;

public class ExecSender
extends QueuedNotifier {
    private static final String FILE_EXEC_FAILED = "exec.retry";
    private static final String FILE_EXEC_UNSENT = "exec.new";
    public static final String FILE_EXEC_EXPIRED = "exec.failed";
    public static final String EXEC_CALL = "exec.call";

    public ExecSender(NovelConfig config, Path mainNotifiDirectory) {
        super(config, mainNotifiDirectory);
        this.failedFileName = FILE_EXEC_FAILED;
        this.unsentFileName = FILE_EXEC_UNSENT;
        this.expiredFileName = FILE_EXEC_EXPIRED;
    }

    @Override
    public synchronized void init() {
        super.init();
        String call = this.getConfig().getMessage();
        if (call == null || "".equals(call)) {
            throw new IllegalArgumentException(" Missing Exec call!");
        }
        this.worker = new ExecWorker(this);
        this.worker.start();
        this.isStarted = true;
    }

    class ExecWorker
    extends Worker {
        private String error;

        protected ExecWorker(Notifier notifi) {
            super(notifi);
            this.error = null;
            this.setName("NF_" + notifi.getConfig().getId());
        }

        @Override
        public void shutDownHook() {
            ExecSender.this.log.closeAllStreams();
        }

        @Override
        public boolean sendMessage(NotificationMsg m, long t) throws InterruptedException {
            boolean gotProblem = true;
            try {
                String msg = m.getMsg();
                ExecResult er = ExecUtils.exec2(msg, null, 20);
                if (er.resultCode != 0) {
                    StringBuilder sb = new StringBuilder();
                    for (String str : er.m_outMessages) {
                        sb.append(str).append('\n');
                    }
                    for (String str : er.m_errorMessages) {
                        sb.append(str).append('\n');
                    }
                    this.error = "Notification Exec Call failed: " + String.valueOf(sb);
                    ExecSender.this.log.print(1, "Notification Exec Call failed: " + String.valueOf(sb));
                } else {
                    ExecSender.this.log.print(1, "OK - " + msg);
                    ExecSender.this.failed.remove(m);
                    gotProblem = false;
                }
            }
            catch (Throwable e) {
                ExecSender.this.putErrorIntoMsg(m, e);
                ExecSender.this.log.print(1, "Failed to execute call", e);
            }
            return gotProblem;
        }

        public String getErrorMsg() {
            return this.error;
        }
    }
}

