/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.notify;

import com.blixx.log.RTLogger;
import com.blixx.shared.notify.NotificationMsg;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;

public class MessageStore {
    public static void save(Collection<NotificationMsg> msgs, File f) throws Exception {
        if (f != null && !Files.exists(f.toPath().getParent(), new LinkOption[0])) {
            Files.createDirectories(f.toPath().getParent(), new FileAttribute[0]);
        }
        try (FileOutputStream out = new FileOutputStream(f);
             DataOutputStream dos = new DataOutputStream(out);){
            for (NotificationMsg m : msgs) {
                dos.writeBoolean(true);
                m.write(dos);
            }
            dos.writeBoolean(false);
        }
    }

    public static Collection<NotificationMsg> read(File f) throws Exception {
        LinkedList<NotificationMsg> result = new LinkedList<NotificationMsg>();
        if (f.exists() && f.length() > 0L) {
            try (FileInputStream fis = new FileInputStream(f);
                 DataInputStream dis = new DataInputStream(fis);){
                while (dis.readBoolean()) {
                    NotificationMsg bm = new NotificationMsg();
                    bm.read(dis);
                    result.add(bm);
                }
            }
            catch (Exception e) {
                RTLogger.print(1, "Error reading notifications from " + f.getAbsolutePath(), e);
            }
        }
        return result;
    }
}

