/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.notify;

import com.blixx.ctrl.sc.INotiMgr;
import com.blixx.log.RTLogger;
import com.blixx.server.EventOperations;
import com.blixx.server.ServerEngine;
import com.blixx.server.ext.ForwardActionsManager;
import com.blixx.server.notify.ExecSender;
import com.blixx.server.notify.MailSender;
import com.blixx.server.notify.QueuedNotifier;
import com.blixx.shared.Cryptor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.notify.NotificationMsg;
import com.blixx.shared.notify.Notifier;
import com.blixx.shared.notify.NotifierQueueFull;
import com.blixx.shared.notify.NotifierStopped;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class NotifierManager
implements INotiMgr {
    private static volatile NotifierManager m_instance = null;
    private final ConcurrentHashMap<String, Notifier> instances = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, NovelConfig> configs = new ConcurrentHashMap();
    private Path dir = Paths.get("srv", new String[0]).resolve("etc").resolve("ext");

    public Path getDir() {
        return this.dir;
    }

    public NotifierManager(Path dir) {
        if (dir != null) {
            this.dir = dir;
        }
    }

    public static void setMockInstance(NotifierManager m) {
        if (m_instance != null && m_instance != m) {
            m_instance.stopAll();
        }
        m_instance = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotifierManager getInstance() {
        if (m_instance != null) return m_instance;
        Class<NotifierManager> clazz = NotifierManager.class;
        synchronized (NotifierManager.class) {
            if (m_instance != null) return m_instance;
            NotifierManager instance = new NotifierManager(null);
            try {
                instance.loadConfigs(instance.getDir());
            }
            catch (Exception e) {
                RTLogger.print(1, "Error loading notification configs", e);
            }
            m_instance = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    @Override
    public synchronized Notifier getNotifier(String id, boolean createIfNecessary) {
        return this.instances.computeIfAbsent(id, idn -> {
            NovelConfig conf;
            QueuedNotifier nfier = null;
            if (createIfNecessary && (conf = this.configs.get(id)) != null) {
                try {
                    if (conf.getType().equals((Object)NovelConfig.NovelCgfType.MAIL)) {
                        nfier = new MailSender(conf, this.getDir());
                    } else if (conf.getType().equals((Object)NovelConfig.NovelCgfType.EXEC)) {
                        nfier = new ExecSender(conf, this.getDir());
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Failed to initialize the Notification Interface: " + conf.getId(), e);
                }
            }
            return nfier;
        });
    }

    @Override
    public NovelConfig getConfig(String configId) {
        return this.configs.get(configId);
    }

    @Override
    public Properties getConfigProperties(String configId) {
        NovelConfig conf = this.configs.get(configId);
        return conf.getProperties();
    }

    @Override
    public List<NovelConfig> getConfigs() {
        ArrayList<NovelConfig> list = new ArrayList<NovelConfig>(this.configs.values());
        for (NovelConfig nc : list) {
            Notifier n = this.getNotifier(nc.getId(), false);
            if (n == null) continue;
            nc.getNotifierStatus().setFailedCount(n.getFailedFinal());
            nc.getNotifierStatus().setQueueSize(n.getQueSize() + n.getFailedQueSize());
            nc.getNotifierStatus().setStarted(n.isStarted());
        }
        return list;
    }

    public void loadConfigs(Path dir) throws IOException {
        this.configs.clear();
        if (dir != null) {
            Files.createDirectories(dir, new FileAttribute[0]);
            ArrayList propFilesList = new ArrayList();
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.filter(path -> path.toString().endsWith(".properties")).forEach(propFilesList::add);
            }
            for (Path filePath : propFilesList) {
                boolean needsToStore = false;
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(filePath.toFile());){
                    props.load(fis);
                    String value = props.getProperty("mail.smtp.password");
                    if (value != null && !value.isEmpty()) {
                        props.setProperty("mail.smtp.password.encrypted", Cryptor.encrypt3(value));
                        props.remove("mail.smtp.password");
                        needsToStore = true;
                    }
                    NovelConfig conf = null;
                    Pattern p = Pattern.compile("(.*)\\.(\\w+)\\.properties");
                    Matcher m = p.matcher(filePath.toFile().getName());
                    if (m.matches()) {
                        String name = m.group(1);
                        String type = m.group(2);
                        if (type.equalsIgnoreCase(NovelConfig.NovelCgfType.MAIL.name())) {
                            conf = new NovelConfig(props, NovelConfig.NovelCgfType.MAIL, name);
                        } else if (type.equalsIgnoreCase(NovelConfig.NovelCgfType.EXEC.name())) {
                            conf = new NovelConfig(props, NovelConfig.NovelCgfType.EXEC, name);
                        } else {
                            RTLogger.print(5, "Error loading unknown type of notification props: " + String.valueOf(filePath) + " type: " + type);
                        }
                    } else {
                        RTLogger.print(5, "Error loading unknown type of notification props: " + String.valueOf(filePath));
                    }
                    if (conf == null) continue;
                    this.configs.put(conf.getId(), conf);
                    Notifier n = this.getNotifier(conf.getId(), true);
                    if (conf.getStartFlag() && n != null) {
                        n.init();
                    }
                    if (!needsToStore) continue;
                    this.saveConfig(conf);
                }
                catch (Exception ex) {
                    RTLogger.print(5, "Could not load Novel configs!", ex);
                }
            }
        }
    }

    @Override
    public boolean deleteConfig(String id, String type) {
        boolean success = true;
        try {
            Path file = this.getDir().resolve(id + "." + type.toLowerCase() + ".properties");
            Files.deleteIfExists(file);
            this.configs.remove(id);
            Path logDir = this.getDir().resolve("notifications" + File.separator + id);
            this.deleteDir(logDir);
        }
        catch (Exception e) {
            RTLogger.print(2, "Error deleting notification configuration: " + id + "." + type, e);
        }
        return success;
    }

    private void deleteDir(Path dir) {
        try {
            FileUtils.deleteDirectoryRecursive(dir.toString());
        }
        catch (Exception e) {
            RTLogger.print(2, "error deleting directory - " + String.valueOf(dir));
        }
    }

    @Override
    public boolean saveConfig(NovelConfig conf) throws IOException {
        boolean result = false;
        NovelConfig.normalizeCfgProps(conf);
        String msg = conf.getMessage();
        if (msg != null && msg.length() > 10 && msg.substring(msg.length() - 10).toLowerCase().contains("</html>")) {
            conf.setHTML(true);
        }
        Path configFile = this.getDir().resolve(conf.getId() + "." + conf.getType().getText().toLowerCase() + ".properties");
        Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
        result = this.saveProperties(conf, configFile);
        return result;
    }

    private boolean saveProperties(NovelConfig conf, Path file) throws IOException {
        boolean result;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)conf.getProperties());
        try (FileOutputStream stream = new FileOutputStream(file.toFile());){
            Matcher matcher;
            String value = props.getProperty("mail.smtp.password");
            if (value != null && !value.isEmpty()) {
                String encryptedPwd = Cryptor.encrypt3(value);
                conf.getProperties().setProperty("mail.smtp.password.encrypted", encryptedPwd);
                conf.getProperties().remove("mail.smtp.password");
                props.setProperty("mail.smtp.password.encrypted", encryptedPwd);
                props.remove("mail.smtp.password");
            }
            Pattern pattern = Pattern.compile("^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?!-)(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$");
            String userName = (String)props.get("mail.smtp.user");
            String pass = (String)props.get("mail.smtp.password.encrypted");
            if (userName != null && pass != null && (matcher = pattern.matcher(userName)).matches() && userName.equals(Cryptor.decrypt(pass))) {
                throw new IllegalArgumentException(" Username and Password can not be the same.");
            }
            props.store(stream, null);
            result = true;
            this.configs.put(conf.getId(), conf);
            if (conf.getStartFlag()) {
                this.instances.remove(conf.getId());
                Notifier n = this.getNotifier(conf.getId(), true);
                n.init();
                n.getConfig().setStartFlag(true);
            } else {
                this.instances.remove(conf.getId());
                Notifier runningNoti = this.getNotifier(conf.getId(), false);
                if (runningNoti != null) {
                    runningNoti.getConfig().setStartFlag(false);
                    runningNoti.shutdown();
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(3, "Error saving Notification config " + String.valueOf(file), e);
            throw new IOException("Error saving Notification templates");
        }
        return result;
    }

    public Notifier start(String id) {
        Notifier n = this.getNotifier(id, true);
        if (n != null && !n.isStarted()) {
            n.init();
            RTLogger.print(2, "User started notification interface: " + id);
            n.getConfig().setStartFlag(true);
            RTLogger.print(2, "User stopped notification interface: " + id);
            try {
                this.saveConfig(n.getConfig());
            }
            catch (Exception e) {
                RTLogger.print(2, "Error saving notification config", e);
            }
        }
        return n;
    }

    public Notifier stop(String id) {
        Notifier n = this.getNotifier(id, false);
        if (n != null && n.isStarted()) {
            n.shutdown();
            n.getConfig().setStartFlag(false);
            RTLogger.print(2, "User stopped notification interface: " + id);
            try {
                this.saveConfig(n.getConfig());
            }
            catch (Exception e) {
                RTLogger.print(2, "Error saving notification config", e);
            }
        }
        return n;
    }

    public void stopAll() {
        this.instances.values().forEach(Notifier::shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String testConfig(NovelConfig conf, String rcp) {
        NotificationMsg bmsg = null;
        Object result = "Test message successfully sent";
        Notifier sender = null;
        String error_msg = null;
        try {
            String msgC = conf.getMessage();
            if (msgC != null && msgC.length() > 10 && msgC.substring(msgC.length() - 10, msgC.length()).toLowerCase().contains("</html>")) {
                conf.setHTML(true);
            }
            SEventFwd test = this.getSampleIndication();
            if (conf.getType().equals((Object)NovelConfig.NovelCgfType.MAIL)) {
                String msg = ForwardActionsManager.prepareString(test, conf.getMessage(), false);
                String subj = ForwardActionsManager.prepareString(test, conf.getSubject(), true);
                sender = new MailSender(conf, this.getDir());
                sender.init();
                bmsg = sender.createNotificationMsg(conf.getFrom(), rcp, msg, subj, conf.isHTML());
                sender.getWorker().sendMessage(bmsg, conf.getExpireInterval());
            } else if (conf.getType().equals((Object)NovelConfig.NovelCgfType.EXEC)) {
                String msg = this.prepareMessageForExec(conf, test);
                sender = new ExecSender(conf, this.getDir());
                sender.init();
                bmsg = sender.createNotificationMsg("", rcp, msg, "", conf.isHTML());
                ExecSender.ExecWorker execWorker = (ExecSender.ExecWorker)sender.getWorker();
                boolean gotProblem = execWorker.sendMessage(bmsg, conf.getExpireInterval());
                if (gotProblem) {
                    error_msg = execWorker.getErrorMsg();
                }
            }
        }
        catch (Throwable ex) {
            result = "Could not test Novel config! \n" + ex.getMessage();
            RTLogger.print(5, (String)result, ex);
            if (bmsg != null && ex.getMessage() != null) {
                bmsg.error = "Initialization error: " + ex.getMessage();
            }
        }
        finally {
            try {
                if (bmsg == null) {
                    result = "Message was not sent.\nUnknown server error";
                } else if (bmsg.getError() != null) {
                    result = "Message was not sent.\n" + bmsg.getError();
                } else if (error_msg != null) {
                    result = "Message was sent but got error back.\n" + error_msg;
                }
                if (sender != null) {
                    sender.shutdown();
                }
            }
            catch (Throwable msgC) {}
        }
        return result;
    }

    private String prepareMessageForExec(NovelConfig conf, SEventFwd test) {
        if (conf.getMessage() == null) {
            return "";
        }
        String call = conf.getMessage().replaceAll("[\r\n]+", " ");
        String msg = ForwardActionsManager.prepareString(test, call, false);
        String replaceNewLineStr = conf.getNewlineReplaceStr();
        if (replaceNewLineStr == null || replaceNewLineStr.length() == 0) {
            replaceNewLineStr = " ";
        }
        return msg.replaceAll("[\r\n]+", replaceNewLineStr);
    }

    public SEventFwd getSampleIndication() {
        SEventFwd sef = new SEventFwd();
        sef.setID("00000000-0000-0000-0000-000000000000");
        sef.setValue(1.0);
        sef.setNode("host.org");
        sef.setSource("Monitor:NonExistingMonitor:00000000-0000-0000-0000-000000000001");
        sef.setFirstTime(System.currentTimeMillis());
        sef.setTime(System.currentTimeMillis());
        sef.setSTime(System.currentTimeMillis());
        sef.setTypeA(1);
        sef.setTypeK(1);
        sef.setDeduplication(true);
        sef.setApplication("Application");
        sef.setMonitor("Monitor");
        sef.setObject("Object");
        sef.setSeverity(5);
        sef.setText("Test indication text line1\nTest indication text line2\nTest indication text line3\nTest indication text line4\nTest indication text line5\n\nTest indication text line6\nTest indication text line7\nTest indication text line8\nTest indication text line9\nTest indication text line10");
        sef.setInstructionID("10000000-0000-0000-0000-000000000000");
        sef.setGroup("Group");
        sef.setKey("host.org:Test:critical");
        sef.setCloseMask("host.org:Test:<*>");
        sef.setDuplicate(1);
        sef.setAgentNode("192.168.0.1");
        sef.setAnnotationFlag(true);
        for (int i = 1; i < 16; ++i) {
            sef.m_CustomAttributes.put("CA" + i, "Attribute" + i + "=value" + i);
        }
        return sef;
    }

    @Override
    public NotificationMsg sendAsNotification(String notifierID, SEventFwd se, String user) throws NotifierStopped, NotifierQueueFull {
        NovelConfig nc;
        Notifier noti;
        NotificationMsg res = null;
        boolean isAlreadySent = this.checkIfSent(notifierID, se, user);
        if (!isAlreadySent && (noti = this.getNotifier(notifierID, false)) != null && (nc = this.getConfig(notifierID)) != null) {
            String msg = "";
            msg = nc.getType().equals((Object)NovelConfig.NovelCgfType.EXEC) ? this.prepareMessageForExec(nc, se) : ForwardActionsManager.prepareString(se, nc.getMessage(), false);
            String sbj = ForwardActionsManager.prepareString(se, nc.getSubject(), true);
            res = noti.enqueueMsg(nc.getFrom(), nc.getTo(), msg, sbj, nc.isHTML());
            this.updateT6(notifierID, se, user);
            EventOperations es = ServerEngine.getInstance().getEventsRouter().detectEventOperations(se.getID());
            if (es != null) {
                try {
                    es.markToInsertOrUpdateInDB(se);
                }
                catch (Exception e) {
                    RTLogger.print(4, "error update indi", e);
                }
                es.getClientProxyMgr().addUpdatedToClients(Collections.singletonList(se));
            }
        }
        return res;
    }

    public boolean checkIfSent(String notifierID, SEventFwd se, String user) {
        boolean isAlreadySent = false;
        String t6 = se.getT6();
        if (user == null && t6 != null && t6.length() != 0) {
            String[] lines = t6.split("\n");
            String prefix = notifierID + "|";
            for (String line : lines) {
                if (!line.startsWith(prefix) || line.indexOf(124) != line.lastIndexOf(124)) continue;
                isAlreadySent = true;
                break;
            }
        }
        return isAlreadySent;
    }

    public void updateT6(String notifierID, SEventFwd se, String user) {
        StringBuilder s = new StringBuilder();
        String old = se.getT6();
        if (old != null && old.length() > 0) {
            s.append(old);
            s.append('\n');
        }
        s.append(notifierID).append('|').append(System.currentTimeMillis());
        if (user != null && user.length() > 0) {
            s.append('|').append(user);
        }
        se.setT6(s.toString());
    }
}

