/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.perf;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.DB;
import com.blixx.shared.utils.HashMapArray;
import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class PerfManager {
    public static final String TIME = "_TIME";
    public static final String URL_START = "<a href=\"/perf?";
    public static final String EQ = "=";
    public static final String INTERVAL = "interval";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String FIELD = "field";
    public static final String CLASS = "class";
    public static final String EXCLUDES = "excludes";
    public static HashMapArray<String, String> keyFields = new HashMapArray();
    static DB m_db = ServerEngine.getInstance().getDB();
    public static final String AGENTID = "BOOMAGENTID";
    static StringBuffer intervalSB = new StringBuffer();

    public static Collection<String> getPerfClasses() {
        ArrayList<String> tables = new ArrayList<String>(0);
        HashMapArray<String, DDFField> hma = m_db.getPerfTables();
        if (hma.size() != 0) {
            tables = new ArrayList(hma.keySet());
            Collections.sort(tables);
        }
        return tables;
    }

    public static void fixBoomAgentIDColumn() {
        try {
            String sql_1 = "UPDATE " + ServerEngine.getInstance().getDB().getPerfDBname() + ".@ SET BOOMAGENTID=AGENTID WHERE AGENTID IS NOT NULL";
            String sql_2 = "ALTER TABLE " + ServerEngine.getInstance().getDB().getPerfDBname() + ".@ DROP COLUMN AGENTID";
            for (String tableName : PerfManager.getPerfClasses()) {
                String s1 = "";
                String s2 = "";
                if (PerfManager.m_db.m_isOraclePERF) {
                    s1 = sql_1.replace("@", "\"" + tableName + "\"");
                    s2 = sql_2.replace("@", "\"" + tableName + "\"");
                } else {
                    s1 = sql_1.replace("@", "`" + tableName + "`");
                    s2 = sql_2.replace("@", "`" + tableName + "`");
                }
                m_db.executePerf2(s1);
                m_db.executePerf2(s2);
                RTLogger.print(3, "Perf table " + tableName + " dropped unused AGENTID column");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getClassesListHTML() {
        HashMapArray<String, DDFField> hma = m_db.getPerfTables();
        StringBuffer sb = new StringBuffer();
        sb.append("<h3>").append("Performance Classes").append("</h3>").append('\n');
        sb.append("<p>");
        if (hma.size() != 0) {
            ArrayList tables = new ArrayList(hma.keySet());
            Collections.sort(tables);
            for (String tableName : tables) {
                sb.append("&nbsp;&nbsp;&nbsp;<a href=\"/perf?class=").append(tableName).append("\">").append(tableName).append("</a><br>");
            }
        } else {
            sb.append("<b>Performance database is empty!</b>");
        }
        sb.append("</p>");
        return sb.toString();
    }

    public String getClassHTML_v2(String separ, String tableName) {
        HashMapArray<String, DDFField> hma = m_db.getPerfTables();
        int count = 0;
        TreeMap<CallSite, String> kFields = new TreeMap<CallSite, String>();
        List<DDFField> fields = hma.getArray(tableName);
        for (DDFField df : fields) {
            String varcharFieldName;
            if (!df.getType().equals(DDFField.VARCHAR) || (varcharFieldName = df.getName()).equalsIgnoreCase(AGENTID)) continue;
            kFields.put((CallSite)((Object)("cl" + count)), varcharFieldName);
            ++count;
        }
        List<String> keyFieldsGlobalCache = keyFields.getArray(tableName);
        if (keyFieldsGlobalCache == null) {
            keyFields.add(tableName);
            keyFieldsGlobalCache = keyFields.getArray(tableName);
        }
        keyFieldsGlobalCache.clear();
        keyFieldsGlobalCache.addAll(kFields.values());
        StringBuffer sb = new StringBuffer("<html><head><STYLE TYPE=\"text/css\"><!-- TD{font-family: Arial; font-size: 8pt;} ---></STYLE></head>");
        sb.append("<script language=\"JavaScript\">");
        sb.append("var excl = new Array(");
        Iterator itk = kFields.keySet().iterator();
        while (itk.hasNext()) {
            String id = (String)itk.next();
            sb.append('\'').append(id).append('\'');
            if (!itk.hasNext()) continue;
            sb.append(',');
        }
        sb.append(");");
        sb.append("function getURL(id, link){\n\tvar linkFin = link;\n\tfor(i=0;i<excl.length;i++){\n\t\tif(document.getElementById(excl[i]).checked == true){\n\t\t\tlinkFin = linkFin + '&excludes=' + document.getElementById(excl[i]).value;\n\t\t}\n\t}\n\tdocument.getElementById(id).href = linkFin;\n}");
        sb.append("</script>");
        sb.append("<body><small><br>Ignore Fields:<br>\n");
        sb.append("<form action=\"/perf\" method=\"GET\">").append('\n');
        for (Map.Entry en : kFields.entrySet()) {
            String id = (String)en.getKey();
            String value = (String)en.getValue();
            sb.append("<input type=\"checkbox\" name=\"excludes\" id=\"").append(id).append("\" value=\"").append(value).append("\"").append("> ").append(value).append("<br>\n");
        }
        this.getFormForTable_v2(separ, hma, sb, tableName);
        sb.append("</form>");
        sb.append("</small></body></html>");
        return sb.toString();
    }

    public String getClassesHTML(String separ) {
        HashMapArray<String, DDFField> hma = m_db.getPerfTables();
        StringBuffer sb = new StringBuffer();
        ArrayList tables = new ArrayList(hma.keySet());
        Collections.sort(tables);
        for (String tableName : tables) {
            this.getFormForTable(separ, hma, sb, tableName);
        }
        return sb.toString();
    }

    private void getFormForTable_v2(String separ, HashMapArray<String, DDFField> hma, StringBuffer sb, String tableName) {
        if (!keyFields.containsKey(tableName)) {
            keyFields.add(tableName);
        }
        sb.append("<h2>").append(tableName).append("</h2>").append('\n');
        sb.append("<input type=\"hidden\" name=\"class\" value=\"").append(tableName).append("\"/>");
        sb.append("<table border=0>").append('\n');
        List<DDFField> fields = hma.getArray(tableName);
        Collections.sort(fields);
        Iterator<DDFField> ddfs = fields.iterator();
        StringBuffer sbOneClickReports = new StringBuffer();
        StringBuffer sbFieldSelectionList = new StringBuffer();
        sbFieldSelectionList.append("<select name=\"field\" width=\"180\" style=\"width: 180px\">");
        while (ddfs.hasNext()) {
            DDFField df = ddfs.next();
            if (df.getName().equalsIgnoreCase(TIME) || df.getName().equalsIgnoreCase(AGENTID)) continue;
            if (!df.getType().equals(DDFField.VARCHAR)) {
                sbFieldSelectionList.append("<option value=\"").append(df.getName()).append("\">").append(df.getName()).append("</option>");
                this.appendOneClickReports_v2(sbOneClickReports, separ, tableName, df);
                continue;
            }
            this.appendKeyFieldSelection(sb, tableName, df);
        }
        sbFieldSelectionList.append("</select>");
        sb.append("<tr><td>Select field: </td><td colspan=2>").append(sbFieldSelectionList).append("</td></tr>");
        this.appendFromToCalendar(sb);
        sb.append("<tr><td colspan=5>&nbsp;</td><td align=right><input type=submit value=Submit></input></td></tr>");
        sb.append("</table>").append('\n');
        sb.append("<table border=0>").append('\n');
        sb.append("<tr><td>One click reports:</td></tr>");
        sb.append(sbOneClickReports);
        sb.append("</table>").append('\n');
    }

    private void getFormForTable(String separ, HashMapArray<String, DDFField> hma, StringBuffer sb, String tableName) {
        if (!keyFields.containsKey(tableName)) {
            keyFields.add(tableName);
        }
        sb.append("<h2>").append(tableName).append("</h2>").append('\n');
        sb.append("<form action=\"/perf\" method=\"GET\">").append('\n');
        sb.append("<input type=\"hidden\" name=\"class\" value=\"").append(tableName).append("\"/>");
        sb.append("<table border=0>").append('\n');
        List<DDFField> fields = hma.getArray(tableName);
        Collections.sort(fields);
        Iterator<DDFField> ddfs = fields.iterator();
        StringBuffer sbOneClickReports = new StringBuffer();
        StringBuffer sbFieldSelectionList = new StringBuffer();
        sbFieldSelectionList.append("<select name=\"field\">");
        while (ddfs.hasNext()) {
            DDFField df = ddfs.next();
            if (df.getName().equalsIgnoreCase(TIME) || df.getName().equalsIgnoreCase(AGENTID)) continue;
            if (!df.getType().equals(DDFField.VARCHAR)) {
                sbFieldSelectionList.append("<option value=\"").append(df.getName()).append("\">").append(df.getName()).append("</option>");
                this.appendOneClickReports(sbOneClickReports, separ, tableName, df);
                continue;
            }
            this.appendKeyFieldSelection(sb, tableName, df);
        }
        sbFieldSelectionList.append("</select>");
        sb.append("<tr><td>Select field: </td><td colspan=2>").append(sbFieldSelectionList).append("</td></tr>");
        this.appendFromToCalendar(sb);
        sb.append("<tr><td colspan=5>&nbsp;</td><td align=right><input type=submit value=Submit></input></td></tr>");
        sb.append("</table>").append('\n');
        sb.append("<table border=0>").append('\n');
        sb.append("<tr><td>One click reports:</td></tr>");
        sb.append(sbOneClickReports);
        sb.append("</table>").append('\n');
        sb.append("</form>");
    }

    private void appendFromToCalendar(StringBuffer sb) {
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.roll(6, false);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String from = sdf.format(fromCalendar.getTime());
        String to = sdf.format(new Date());
        sb.append("<tr><td align=right>From: </td><td colspan=2>").append("<input width=\"180\" style=\"width: 180px\" type=\"text\" name=\"from\" value=\"").append(from).append("\"/></td>").append("<td align=right>To: </td><td colspan=2>").append("<input width=\"180\" style=\"width: 180px\" type=\"text\" name=\"to\" value=\"").append(to).append("\"/></td></tr>");
    }

    private void appendOneClickReports_v2(StringBuffer sbFileds, String separ, String tableName, DDFField df) {
        sbFileds.append("<tr>");
        sbFileds.append("<td>");
        sbFileds.append(df.getName());
        sbFileds.append("</td><td>");
        long interval = 2592000000L;
        sbFileds.append("<a id='").append(df.getName()).append('1').append("' href=\"#\" onclick=\"getURL('").append(df.getName()).append('1').append("','");
        sbFileds.append("/perf?").append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("')\">").append("30 days </a>");
        sbFileds.append("</td><td>");
        interval = 604800000L;
        sbFileds.append("<a id='").append(df.getName()).append('2').append("' href=\"#\" onclick=\"getURL('").append(df.getName()).append('2').append("','");
        sbFileds.append("/perf?").append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("')\">").append("7 days </a>");
        sbFileds.append("</td><td>");
        interval = 259200000L;
        sbFileds.append("<a id='").append(df.getName()).append('3').append("' href=\"#\" onclick=\"getURL('").append(df.getName()).append('3').append("','");
        sbFileds.append("/perf?").append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("')\">").append("3 days </a>");
        sbFileds.append("</td><td>");
        interval = 86400000L;
        sbFileds.append("<a id='").append(df.getName()).append('4').append("' href=\"#\" onclick=\"getURL('").append(df.getName()).append('4').append("','");
        sbFileds.append("/perf?").append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("')\">").append("1 day </a>");
        sbFileds.append("</td><td>");
        interval = 28800000L;
        sbFileds.append("<a id='").append(df.getName()).append('5').append("' href=\"#\" onclick=\"getURL('").append(df.getName()).append('5').append("','");
        sbFileds.append("/perf?").append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("')\">").append("8 hours </a>");
        sbFileds.append("</td><td>");
        interval = 3600000L;
        sbFileds.append("<a id='").append(df.getName()).append('6').append("' href=\"#\" onclick=\"getURL('").append(df.getName()).append('6').append("','");
        sbFileds.append("/perf?").append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("')\">").append("1 hour </a>");
        sbFileds.append("</td><td>");
        sbFileds.append("</td>");
    }

    private void appendOneClickReports(StringBuffer sbFileds, String separ, String tableName, DDFField df) {
        sbFileds.append("<tr>");
        sbFileds.append("<td>");
        sbFileds.append(df.getName());
        sbFileds.append("</td><td>");
        long interval = 2592000000L;
        sbFileds.append(URL_START).append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("\">").append("30 days </a>");
        sbFileds.append("</td><td>");
        interval = 604800000L;
        sbFileds.append(URL_START).append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("\">").append("7 days </a>");
        sbFileds.append("</td><td>");
        interval = 259200000L;
        sbFileds.append(URL_START).append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("\">").append("3 days </a>");
        sbFileds.append("</td><td>");
        interval = 86400000L;
        sbFileds.append(URL_START).append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("\">").append("1 day </a>");
        sbFileds.append("</td><td>");
        interval = 28800000L;
        sbFileds.append(URL_START).append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("\">").append("8 hours </a>");
        sbFileds.append("</td><td>");
        interval = 3600000L;
        sbFileds.append(URL_START).append(CLASS).append(EQ).append(tableName).append(separ).append(FIELD).append(EQ).append(df.getName()).append(separ).append(INTERVAL).append(EQ).append(interval).append("\">").append("1 hour </a>");
        sbFileds.append("</td><td>");
        sbFileds.append("</td>");
    }

    private void appendKeyFieldSelection(StringBuffer sb, String tableName, DDFField df) {
        sb.append("<td valign=top>");
        if (!keyFields.containsValue(tableName, df.getName())) {
            keyFields.putV(tableName, df.getName());
        }
        sb.append(df.getName()).append(" (").append(df.getType()).append(") *key &nbsp;");
        sb.append("</td><td colspan=2><select size=10 width=\"180\" style=\"width: 180px\" multiple=\"multiple\" name=\"").append(df.getName()).append("\" ").append("id=\"").append(df.getName()).append("\">");
        sb.append("<option value=\"*\" selected=\"selected\">").append('*').append("</option>");
        try {
            StringBuilder sbq = new StringBuilder();
            if (PerfManager.m_db.m_isOraclePERF) {
                sbq.append("SELECT DISTINCT ").append('\"').append(df.getName()).append('\"').append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".\"").append(tableName).append('\"').append(" ORDER BY ").append('\"').append(df.getName()).append('\"');
            } else {
                sbq.append("SELECT DISTINCT ").append('`').append(df.getName()).append('`').append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".`").append(tableName).append('`').append(" ORDER BY ").append('`').append(df.getName()).append('`');
            }
            List<Map<String, Object>> rows = m_db.queryPerf2(sbq.toString());
            for (Map<String, Object> row : rows) {
                String val = String.valueOf(row.get(df.getName()));
                sb.append("<option value=\"" + val + "\">").append(val).append("</option>");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        sb.append("</select>&nbsp;&nbsp;");
        sb.append("</td>");
    }

    public List<List<String>> getDistinctKeyValues(String tableName, List<String> numericFields) throws SQLException {
        LinkedList<List<String>> arr2d = new LinkedList<List<String>>();
        ArrayList<String> header = new ArrayList<String>();
        List<DDFField> list = m_db.getPerfTableMetaData(tableName);
        Iterator<DDFField> it = list.iterator();
        while (it.hasNext()) {
            DDFField field = it.next();
            if (!field.getType().equals(DDFField.VARCHAR) && !field.getType().equals("CHAR")) {
                it.remove();
                numericFields.add(field.getName());
                continue;
            }
            header.add(field.getName());
        }
        arr2d.add(header);
        StringBuilder sbq = new StringBuilder();
        sbq.append("SELECT DISTINCT ");
        if (PerfManager.m_db.m_isOraclePERF) {
            it2 = list.iterator();
            while (it2.hasNext()) {
                df = it2.next();
                sbq.append('\"').append(df.getName()).append('\"');
                if (!it2.hasNext()) continue;
                sbq.append(',');
            }
            sbq.append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".\"").append(tableName).append('\"');
        } else {
            it2 = list.iterator();
            while (it2.hasNext()) {
                df = it2.next();
                sbq.append('`').append(df.getName()).append('`');
                if (!it2.hasNext()) continue;
                sbq.append(',');
            }
            sbq.append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".`").append(tableName).append('`');
        }
        List<Map<String, Object>> rows = m_db.queryPerf2(sbq.toString());
        for (Map<String, Object> row : rows) {
            ArrayList<String> row1 = new ArrayList<String>();
            for (String f : header) {
                row1.add((String)row.get(f));
            }
            arr2d.add(row1);
        }
        return arr2d;
    }

    public Map<String, List<List<String>>> getAgentKeyValues(String agentID) throws SQLException {
        LinkedHashMap<String, List<List<String>>> result = new LinkedHashMap<String, List<List<String>>>();
        HashMapArray<String, DDFField> hma = m_db.getPerfTables();
        ArrayList tables = new ArrayList(hma.keySet());
        Collections.sort(tables);
        for (String tableName : tables) {
            LinkedList tableData = new LinkedList();
            ArrayList<String> header = new ArrayList<String>(1);
            List<DDFField> list = m_db.getPerfTableMetaData(tableName);
            Iterator<DDFField> it = list.iterator();
            while (it.hasNext()) {
                DDFField field = it.next();
                if (!field.getType().equals(DDFField.VARCHAR)) {
                    it.remove();
                    continue;
                }
                header.add(field.getName());
            }
            StringBuilder sbq = new StringBuilder();
            sbq.append("SELECT DISTINCT ");
            if (PerfManager.m_db.m_isOraclePERF) {
                it2 = list.iterator();
                while (it2.hasNext()) {
                    df = it2.next();
                    sbq.append('\"').append(df.getName()).append('\"');
                    if (!it2.hasNext()) continue;
                    sbq.append(',');
                }
                sbq.append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".\"").append(tableName).append('\"');
            } else {
                it2 = list.iterator();
                while (it2.hasNext()) {
                    df = it2.next();
                    sbq.append('`').append(df.getName()).append('`');
                    if (!it2.hasNext()) continue;
                    sbq.append(',');
                }
                sbq.append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".`").append(tableName).append('`');
            }
            sbq.append(" WHERE ").append(AGENTID).append("='").append(agentID).append('\'');
            List<Map<String, Object>> rows = m_db.queryPerf2(sbq.toString());
            tableData.add(header);
            for (Map<String, Object> row : rows) {
                ArrayList<String> row1 = new ArrayList<String>();
                for (String f : header) {
                    row1.add((String)row.get(f));
                }
                tableData.add(row1);
            }
            if (tableData.size() <= 1) continue;
            result.put(tableName, tableData);
        }
        return result;
    }

    public File getChart(String table, String field, long from, long to, Map filters, List<String> excludeKeys) {
        File fileR = null;
        try {
            List<String> keys;
            StringBuilder sql = new StringBuilder("SELECT _TIME, ");
            if (PerfManager.m_db.m_isOraclePERF) {
                sql = new StringBuilder("SELECT \"_TIME\", ");
            }
            if ((keys = keyFields.getArray(table)) == null) {
                this.getClassesHTML("&");
                keys = keyFields.getArray(table);
            }
            if (keys != null) {
                keys.removeAll(excludeKeys);
            }
            sql = this.addKeys(keys, sql);
            if (PerfManager.m_db.m_isOraclePERF) {
                sql.append("\"").append(field).append("\"");
            } else {
                sql.append("`").append(field).append("`");
            }
            if (PerfManager.m_db.m_isOraclePERF) {
                sql.append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".\"").append(table).append("\" WHERE \"_TIME\" > ").append(from).append(" AND  \"_TIME\" <= ").append(to);
            } else {
                sql.append(" FROM ").append(ServerEngine.getInstance().getDB().getPerfDBname()).append(".`").append(table).append("` WHERE _TIME > ").append(from).append(" AND _TIME <= ").append(to);
            }
            for (String fi : filters.keySet()) {
                if (!keys.contains(fi)) continue;
                Object o = filters.get(fi);
                if (o instanceof String) {
                    String value = (String)o;
                    if (value == null || value.equals("*") || value.equals("")) continue;
                    if (PerfManager.m_db.m_isOraclePERF) {
                        sql.append(" AND \"").append(fi).append("\"='").append(value).append("'");
                        continue;
                    }
                    sql.append(" AND `").append(fi).append("`='").append(value).append("'");
                    continue;
                }
                if (!(o instanceof List)) continue;
                List values = (List)o;
                sql.append(" AND (");
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    if (PerfManager.m_db.m_isOraclePERF) {
                        sql.append('\"').append(fi).append('\"').append("='").append(it.next()).append("'");
                    } else {
                        sql.append('`').append(fi).append('`').append("='").append(it.next()).append("'");
                    }
                    if (!it.hasNext()) continue;
                    sql.append(" OR ");
                }
                sql.append(")");
            }
            RTLogger.print(5, "chart SQL = " + String.valueOf(sql));
            List<Map<String, Object>> l = m_db.queryPerf2(sql.toString());
            RTLogger.print(5, "chart data size = " + l.size());
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            for (Map<String, Object> row : l) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < keys.size(); ++i) {
                    sb.append(row.get(keys.get(i))).append(' ');
                }
                String keyOfSerie = sb.toString().trim();
                TimeSeries ts = dataset.getSeries((Comparable)((Object)keyOfSerie));
                if (ts == null) {
                    ts = new TimeSeries((Comparable)((Object)keyOfSerie));
                    dataset.addSeries(ts);
                }
                long time = Long.parseLong(String.valueOf(row.get(TIME)));
                try {
                    double fieldValue = Double.parseDouble(String.valueOf(row.get(field)));
                    if (Double.compare(fieldValue, -1.0) == 0) {
                        ts.addOrUpdate((RegularTimePeriod)new Minute(new Date(time)), null);
                        continue;
                    }
                    ts.addOrUpdate((RegularTimePeriod)new Minute(new Date(time)), fieldValue);
                }
                catch (Throwable e) {
                    RTLogger.print(5, "PerfManager.", e);
                }
            }
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)("Table: " + table + " Field: " + field), (String)"Time", (String)"Value", (XYDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
            chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
            XYPlot plot = (XYPlot)chart.getPlot();
            plot.setOutlineVisible(false);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            DateAxis dateAxis = (DateAxis)plot.getDomainAxis();
            SimpleDateFormat SDF_dmhm = new SimpleDateFormat("dd MMM HH:mm");
            dateAxis.setVerticalTickLabels(true);
            dateAxis.setDateFormatOverride((DateFormat)SDF_dmhm);
            File dir = new File("srv/html/perf");
            dir.mkdirs();
            File pngFile = new File(dir, table + System.currentTimeMillis() + ".png");
            ChartUtils.saveChartAsPNG((File)pngFile, (JFreeChart)chart, (int)1024, (int)640);
            fileR = pngFile;
        }
        catch (Throwable e) {
            RTLogger.print(5, "PerfManager err2.", e);
        }
        return fileR;
    }

    private StringBuilder addKeys(List<String> fields, StringBuilder sql) {
        if (fields != null && fields.size() > 0) {
            Iterator<String> it = fields.iterator();
            while (it.hasNext()) {
                if (PerfManager.m_db.m_isOraclePERF) {
                    sql.append('\"').append(it.next()).append('\"');
                } else {
                    sql.append('`').append(it.next()).append('`');
                }
                sql.append(", ");
            }
        }
        return sql;
    }

    static {
        intervalSB.append("<select name=interval>").append("<option value=").append(3600000L).append("> 1 hour </option>").append("<option value=").append(28800000L).append("> 8 hour </option>").append("<option value=").append(86400000L).append("> 24 hour </option>").append("<option value=").append(259200000L).append("> 3 days </option>").append("<option value=").append(604800000L).append("> 7 days </option>").append("<option value=").append(1209600000L).append("> 14 days </option>").append("<option value=").append(2592000000L).append("> 30 days </option>").append("</select>");
    }
}

