/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.perf;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.Connector;
import com.blixx.server.db.DB;
import com.blixx.server.db.OraConnector;
import com.blixx.server.perf.PerfSQL;
import com.blixx.server.perf.PerfSubmitter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class PerfThread
implements Runnable {
    Map<PerfSQL, Queue<Object[]>> perfdata = new ConcurrentHashMap<PerfSQL, Queue<Object[]>>();
    Connector m_connector = null;
    DB m_db = null;
    public AtomicLong m_countIn = new AtomicLong(0L);
    public AtomicLong m_countOut = new AtomicLong(0L);

    public PerfThread(Connector con) {
        this.m_connector = con;
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.insertQueuedPerfData();
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void queuePerf(PerfSQL sql, Object[] values) throws SQLException {
        if (this.m_db == null) {
            this.m_db = ServerEngine.getInstance().getDB();
        }
        Queue<Object[]> queue = this.perfdata.get(sql);
        this.applyInCounter(1);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<Object[]>();
            this.perfdata.put(sql, queue);
            queue.add(values);
        } else {
            queue.add(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertQueuedPerfData() throws SQLException {
        String error = null;
        Iterator<Map.Entry<PerfSQL, Queue<Object[]>>> it = this.perfdata.entrySet().iterator();
        while (it.hasNext()) {
            error = null;
            Map.Entry<PerfSQL, Queue<Object[]>> en = it.next();
            PerfSQL prepSql = en.getKey();
            Queue<Object[]> queuePerSQL = en.getValue();
            if (queuePerSQL.size() <= 0) continue;
            if (queuePerSQL.size() > 10000 && RTLogger.getCurrentLevel() >= 4) {
                RTLogger.print(4, prepSql.m_class + " perf class has size of queue=" + queuePerSQL.size());
            }
            if (!this.m_connector.isReady() && !this.m_connector.onOpen()) {
                while (queuePerSQL.size() > 100000) {
                    queuePerSQL.poll();
                }
                continue;
            }
            PreparedStatement ps = null;
            int count = 0;
            Connection connection = this.m_connector.getConnection();
            try {
                ps = connection.prepareStatement(prepSql.toString());
                connection.setAutoCommit(false);
                if (ps == null) continue;
                int maxBlock = 5000;
                Object[] row = null;
                while (maxBlock > 0 && (row = queuePerSQL.poll()) != null) {
                    try {
                        this.m_connector.fillValues(row, ps);
                        ps.executeUpdate();
                        if (++count > 1000) {
                            connection.commit();
                            this.applyOutCounter(count);
                            count = 0;
                        }
                        error = null;
                    }
                    catch (SQLException e) {
                        try {
                            connection.rollback();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        String nerror = new StringBuffer("Can't insert data for class: ").append(prepSql.m_class).append(" fields:").append(prepSql.m_fields).append(" - ").append(row[row.length - 1]).toString();
                        if (error == null || !error.equals(nerror)) {
                            error = nerror;
                            RTLogger.print(3, error, e);
                        }
                        try {
                            this.alterPerfTable(prepSql.m_class, prepSql.m_fields);
                            queuePerSQL.offer(row);
                        }
                        catch (SQLException e1) {
                            this.applyOutCounter(1);
                            RTLogger.print(3, "Can't alter/create table: " + prepSql.m_class, e1);
                            RTLogger.print(3, "Fields: " + prepSql.m_fields);
                        }
                        finally {
                            try {
                                Thread.sleep(100L);
                                maxBlock -= 100;
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        --maxBlock;
                    }
                }
            }
            finally {
                try {
                    connection.commit();
                    if (count > 0) {
                        this.applyOutCounter(count);
                    }
                }
                catch (Throwable e) {
                    try {
                        connection.rollback();
                    }
                    catch (Throwable throwable) {}
                }
                try {
                    connection.setAutoCommit(true);
                }
                catch (Throwable throwable) {}
                if (ps == null) continue;
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void applyOutCounter(int count) {
        if (this.m_countOut.get() < Long.MAX_VALUE) {
            this.m_countOut.addAndGet(count);
        } else {
            this.m_countOut.set(1L);
            this.m_countIn.set(1L);
        }
    }

    private void applyInCounter(int count) {
        if (this.m_countIn.get() < Long.MAX_VALUE) {
            this.m_countIn.addAndGet(count);
        } else {
            this.m_countOut.set(1L);
            this.m_countIn.set(1L);
        }
    }

    public void alterPerfTable(String className, String fields) throws SQLException {
        List<DDFField> existingFields = this.checkTable(className);
        if (existingFields == null || existingFields.size() == 0) {
            String sql = PerfSubmitter.getCreateTableSQL(fields, className, this.m_db.m_isOraclePERF);
            try {
                RTLogger.print(1, "Creating a table for PERF class. " + className);
                this.m_connector.execute(sql);
                try {
                    if (this.m_connector instanceof OraConnector) {
                        StringBuffer indexSQL = new StringBuffer("CREATE INDEX \"").append(this.m_db.getPerfDBname()).append("\".").append(className).append(" ON \"").append(this.m_db.getPerfDBname()).append("\".").append(className).append(" (\"_TIME\")");
                        this.m_connector.execute(indexSQL.toString());
                    } else {
                        StringBuffer indexSQL = new StringBuffer("alter table `").append(this.m_db.getPerfDBname()).append("`.").append(className).append(" add index `TIME` (`_TIME`)");
                        this.m_connector.execute(indexSQL.toString());
                    }
                }
                catch (Throwable e2) {
                    RTLogger.print(3, "Failed create index on " + className, e2);
                }
                RTLogger.print(1, "Perf table " + className + " created.");
            }
            catch (SQLException e1) {
                String msg = "Failed to create table for PERF class: " + className;
                RTLogger.print(2, msg + sql);
                throw e1;
            }
        }
        String alterSQL = PerfSubmitter.getAlterTableSQL(fields, className, this.m_db.m_isOraclePERF, existingFields);
        if (alterSQL.indexOf("DEFAULT NULL") != -1) {
            try {
                RTLogger.print(1, "ALTERING table for PERF class. " + className);
                this.m_connector.execute(alterSQL);
                RTLogger.print(1, "ALTERING table done. SQL: " + alterSQL);
            }
            catch (SQLException e1) {
                String msg = "Failed to ALTER table for PERF class: " + className;
                RTLogger.print(2, msg + alterSQL);
                throw e1;
            }
        }
    }

    public List<DDFField> checkTable(String table) {
        List<DDFField> fields = null;
        try {
            fields = ServerEngine.getInstance().getDB().getPerfTableMetaData(table);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fields;
    }
}

