/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.pki;

import com.blixx.log.RTLogger;
import com.blixx.server.CertificateStateIndicationHelper;
import com.blixx.shared.Cryptor;
import com.boom.crt.GeneralNameParsingException;
import com.boom.crt.KeyStoreClient;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.crt.hlp.NotSupportedCertificateException;
import com.boom.crt.hlp.SubjectAlternativeNameEntry;
import com.boom.pki.PKI;
import com.boom.pki.PKIResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class BoomPKI
implements PKI {
    public static final String CA_CERTIFICATE_ALIAS = "ca";
    private static final String CA_KS_FILE_PROPERTY_NAME = "ca_ks_file";
    private static final String CA_PASS_PROPERTY_NAME = "ca_password";
    private static final String CA_PASS_ENCODED_PROPERTY_NAME = "ca_password_encoded";
    private static final String CA_DISTINGUISHED_NAME_PROPERTY_NAME = "ca_distinguished_name";
    public static final String CA_VALIDITY_PERIOD_DAYS_PROPERTY_NAME = "ca_validity_period_days";
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private Consumer<PKIResponse> responseConsumer = null;
    private int validityPeriodDays = 700;
    private KeyStoreClient caKsClient;
    private Path mainServerDir;

    @Override
    public void init(Path mainServerDir, Path configFile, Consumer<PKIResponse> responseConsumer, Map<String, String> additionalConfig) {
        this.mainServerDir = mainServerDir;
        this.responseConsumer = responseConsumer;
        Properties properties = new Properties();
        if (configFile != null) {
            try (InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);){
                properties.load(inputStream);
            }
            catch (IOException e) {
                RTLogger.print(1, "Could not load configuration from file " + String.valueOf(configFile), e);
            }
        }
        Path etcDir = mainServerDir.resolve("srv").resolve("etc");
        try {
            Files.createDirectories(etcDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not create required directory: " + String.valueOf(etcDir), e);
        }
        String caKsFile = properties.getProperty(CA_KS_FILE_PROPERTY_NAME, etcDir.resolve("cakeystore.p12").toString());
        String caKsPassEncoded = properties.getProperty(CA_PASS_ENCODED_PROPERTY_NAME, Cryptor.encrypt4("changeit"));
        String caKsPass = properties.getProperty(CA_PASS_PROPERTY_NAME);
        String distinguishedName = properties.getProperty(CA_DISTINGUISHED_NAME_PROPERTY_NAME, "CN=boomCA, O=Worldline, C=DE");
        String validityPeriodDaysStr = properties.getProperty(CA_VALIDITY_PERIOD_DAYS_PROPERTY_NAME, "700");
        if (validityPeriodDaysStr != null) {
            try {
                this.validityPeriodDays = Integer.parseInt(validityPeriodDaysStr);
            }
            catch (Exception e) {
                RTLogger.print(1, "Invalid CA validity period days: " + validityPeriodDaysStr + ", using default 700 days", e);
            }
        }
        if (caKsPass != null && !caKsPass.matches("\\s*")) {
            caKsPassEncoded = Cryptor.encrypt4(caKsPass);
            properties.setProperty(CA_PASS_ENCODED_PROPERTY_NAME, caKsPassEncoded);
            properties.remove(CA_PASS_PROPERTY_NAME);
            if (configFile != null) {
                try (OutputStream outputStream = Files.newOutputStream(configFile, new OpenOption[0]);){
                    properties.store(outputStream, null);
                }
                catch (IOException e) {
                    RTLogger.print(1, "Could not save configuration file " + String.valueOf(configFile), e);
                }
            }
        }
        this.initCaKeyStore(distinguishedName, caKsFile, caKsPassEncoded);
        Runtime.getRuntime().addShutdownHook(new Thread(this.executor::shutdownNow));
    }

    public void init(String caKsFile, String caKsPassEncoded, String distinguishedName) {
        this.initCaKeyStore(distinguishedName, caKsFile, caKsPassEncoded);
        Runtime.getRuntime().addShutdownHook(new Thread(this.executor::shutdownNow));
    }

    private void initCaKeyStore(String dn, String ksFile, String ksPassEncoded) {
        try {
            if (ksFile != null) {
                Path keyStorePath = Paths.get(ksFile, new String[0]);
                this.caKsClient = new KeyStoreClient(KeyStoreUtils.getKeyStoreType(ksFile), keyStorePath, ksPassEncoded);
                if (!Files.exists(keyStorePath, new LinkOption[0])) {
                    RTLogger.print(1, "CA key store not found, creating a new one " + keyStorePath.toAbsolutePath().toString());
                    this.caKsClient.createKeyStore();
                    this.caKsClient.generateAndImportSelfSignedCertificate(CA_CERTIFICATE_ALIAS, dn, 3000, "SHA256WithRSA", false, Collections.emptyList(), true);
                    this.caKsClient.saveKeyStore();
                } else {
                    this.caKsClient.loadKeyStore();
                    RTLogger.print(1, "CA key store loaded");
                    if (!this.caKsClient.getKeyStore().containsAlias(CA_CERTIFICATE_ALIAS)) {
                        throw new Exception("KeyStore does not contain CA certificate. Expected alias: ca. You can delete keystore to re-generate keystore");
                    }
                }
                this.responseConsumer.accept(new PKIResponse(CA_CERTIFICATE_ALIAS, this.caKsClient.exportCertificate(CA_CERTIFICATE_ALIAS)));
            } else {
                RTLogger.print(1, "CA Keystore is not defined");
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "Error init certificate manager key store", e);
            e.printStackTrace();
            System.exit(43);
        }
    }

    @Override
    public void processCSR(String deviceId, byte[] csr) {
        if (this.responseConsumer != null) {
            this.executor.submit(() -> {
                try {
                    this.responseConsumer.accept(this.processCSRSynchronously(deviceId, csr));
                }
                catch (Exception e) {
                    RTLogger.print(1, "Could not sign certificate request deviceId" + deviceId + ", CSR " + new String(csr), e);
                    CertificateStateIndicationHelper.sendFailedCSR(deviceId, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                }
            });
        }
    }

    public PKIResponse processCSRSynchronously(String deviceId, byte[] csr) throws UnrecoverableKeyException, GeneralNameParsingException, CertificateException, NoSuchAlgorithmException, IOException, SignatureException, KeyStoreException, NoSuchProviderException, InvalidKeyException, NotSupportedCertificateException {
        if (RTLogger.getCurrentLevel() >= 2) {
            RTLogger.print(2, "Processing certificate request deviceId " + deviceId + ", CSR " + new String(csr));
        }
        ArrayList<SubjectAlternativeNameEntry> sans = new ArrayList<SubjectAlternativeNameEntry>();
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Processing agent device: " + deviceId + " CSR: " + new String(csr) + " caKsClient: " + String.valueOf(this.caKsClient));
        }
        byte[] bytes = this.caKsClient.signCertificateRequest(CA_CERTIFICATE_ALIAS, csr, this.validityPeriodDays, "SHA256WithRSA", true, sans);
        RTLogger.print(2, "CSR from deviceId " + deviceId + " has been signed");
        return new PKIResponse(deviceId, bytes);
    }

    public KeyStoreClient getCaKsClient() {
        return this.caKsClient;
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }
}

