/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.pki;

import com.blixx.log.RTLogger;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.pki.PKI;
import com.boom.pki.PKIResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.security.pkcs10.PKCS10;
import sun.security.x509.GeneralNames;

public class FileBasedPKI
implements PKI {
    private static final String CSR_DIR_PROPERTY_NAME = "csr_dir";
    private static final String DEFAULT_CSR_DIR = "./pki/csr";
    private static final String CERT_DIR_PROPERTY_NAME = "cert_dir";
    private static final String DEFAULT_CERT_DIR = "./pki/cert";
    private static final String DAT_FILE_TEMPLATE_PROPERTY_NAME = "dat_file_template";
    private static final String SCAN_INTERVAL_PROPERTY_NAME = "scan_interval_ms";
    private static final long DEFAULT_SCAN_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    private String datFileTemplate = "DeviceID=%DEVICE_ID%\n%SUBJECT_NAME%\nSubjectAlternativeNames:\n%SAN%";
    private Path pendingCSRDir;
    private Path signedCertificatesDir;
    private long scanInterval = DEFAULT_SCAN_INTERVAL;
    private Consumer<PKIResponse> responseConsumer;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    @Override
    public void init(Path mainServerDir, Path configFile, Consumer<PKIResponse> responseConsumer, Map<String, String> additionalConfig) {
        this.responseConsumer = responseConsumer;
        Properties properties = new Properties();
        if (configFile != null) {
            try (InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);){
                properties.load(inputStream);
            }
            catch (IOException e) {
                RTLogger.print(1, "Could not load configuration from file " + String.valueOf(configFile), e);
            }
        }
        this.pendingCSRDir = Paths.get(properties.getProperty(CSR_DIR_PROPERTY_NAME, DEFAULT_CSR_DIR), new String[0]);
        this.signedCertificatesDir = Paths.get(properties.getProperty(CERT_DIR_PROPERTY_NAME, DEFAULT_CERT_DIR), new String[0]);
        String intervalStr = properties.getProperty(SCAN_INTERVAL_PROPERTY_NAME, String.valueOf(DEFAULT_SCAN_INTERVAL));
        try {
            this.scanInterval = Long.parseLong(intervalStr);
        }
        catch (NumberFormatException e) {
            RTLogger.print(1, "Could not parse scan_interval_ms value from file", e);
        }
        String datTemplateFile = properties.getProperty(DAT_FILE_TEMPLATE_PROPERTY_NAME);
        if (configFile != null && datTemplateFile != null && !datTemplateFile.isEmpty()) {
            String fileName = Paths.get(datTemplateFile, new String[0]).getFileName().toString();
            Path templateFilePath = configFile.toAbsolutePath().getParent().resolve(fileName);
            if (Files.exists(templateFilePath, new LinkOption[0])) {
                try {
                    byte[] bytes = Files.readAllBytes(templateFilePath);
                    this.datFileTemplate = new String(bytes);
                }
                catch (IOException e) {
                    RTLogger.print(1, "Could not read DAT file template " + String.valueOf(templateFilePath.toAbsolutePath()), e);
                }
            }
        }
        this.createDirectoriesIfMissing();
        this.scheduler.scheduleAtFixedRate(this::scanCertificatesDir, this.scanInterval, this.scanInterval, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this.scheduler::shutdownNow));
    }

    private void createDirectoriesIfMissing() {
        if (!Files.exists(this.pendingCSRDir, new LinkOption[0]) || !Files.isDirectory(this.pendingCSRDir, new LinkOption[0])) {
            try {
                RTLogger.print(1, "Creating pending CSR directory " + this.pendingCSRDir.toAbsolutePath().toString());
                Files.createDirectories(this.pendingCSRDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                RTLogger.print(1, "Could not create directory " + String.valueOf(this.pendingCSRDir), e);
            }
        }
        if (!Files.exists(this.signedCertificatesDir, new LinkOption[0]) || !Files.isDirectory(this.signedCertificatesDir, new LinkOption[0])) {
            try {
                RTLogger.print(1, "Creating signed certificates directory " + this.pendingCSRDir.toAbsolutePath().toString());
                Files.createDirectories(this.signedCertificatesDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                RTLogger.print(1, "Could not create directory " + String.valueOf(this.signedCertificatesDir), e);
            }
        }
    }

    @Override
    public void processCSR(String deviceId, byte[] csr) {
        if (RTLogger.getCurrentLevel() >= 2) {
            RTLogger.print(2, "FileBasePKI received CSR for " + deviceId);
        }
        Path path = this.pendingCSRDir.resolve(deviceId + ".csr");
        try {
            this.createDatFile(deviceId, csr);
            Files.write(path, csr, new OpenOption[0]);
            if (RTLogger.getCurrentLevel() >= 2) {
                RTLogger.print(2, "CSR File written " + path.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not store certificate request from device", e);
        }
        catch (Exception e) {
            RTLogger.print(1, "Could not parse certificate request " + new String(csr), e);
        }
    }

    private void createDatFile(String deviceId, byte[] csrBytes) throws IOException, SignatureException, NoSuchAlgorithmException {
        byte[] bareCSR = CertificateSerializationHelper.stripCertificateDelimiters(csrBytes);
        PKCS10 csr = new PKCS10(Base64.getMimeDecoder().decode(bareCSR));
        GeneralNames generalNamesFromCSR = KeyStoreUtils.extractSubjectAlternativeNamesFromCRS(csr);
        String san = generalNamesFromCSR.names().stream().map(Objects::toString).collect(Collectors.joining("\n"));
        String content = this.datFileTemplate.replace("%DEVICE_ID%", deviceId);
        content = content.replace("%SUBJECT_NAME%", csr.getSubjectName().toString());
        content = content.replace("%SAN%", san);
        Files.write(this.pendingCSRDir.resolve(deviceId + ".dat"), content.getBytes(), new OpenOption[0]);
    }

    private void scanCertificatesDir() {
        try (Stream<Path> list = Files.list(this.signedCertificatesDir);){
            list.filter(p -> p.getFileName().toString().endsWith(".pem")).forEach(path -> {
                try {
                    RTLogger.print(1, "Processing file " + path.toAbsolutePath().toString());
                    byte[] bytes = Files.readAllBytes(path);
                    String fileName = path.getFileName().toString();
                    if (fileName.length() > 4 && fileName.substring(fileName.length() - 4).equalsIgnoreCase(".pem")) {
                        String deviceId = fileName.substring(0, fileName.length() - 4);
                        this.responseConsumer.accept(new PKIResponse(deviceId, bytes));
                        Files.delete(path);
                        RTLogger.print(1, "Finished processing file " + path.toAbsolutePath().toString());
                    }
                }
                catch (IOException e) {
                    RTLogger.print(1, "Could not process certificate " + path.toAbsolutePath().toString(), e);
                }
            });
        }
        catch (Exception e) {
            RTLogger.print(1, "Could not list certificate directory" + this.signedCertificatesDir.toAbsolutePath().toString(), e);
        }
    }

    @Override
    public void stop() {
        this.scheduler.shutdownNow();
    }
}

