/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.services;

import com.blixx.server.services.EventFilter;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.ext.IServiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class EventFilterGroup
extends EventsAndStatus
implements IServiceStatus {
    private String m_name = null;
    private ArrayList<EventFilter> m_filters = new ArrayList();
    private Integer maxAV = null;
    private Integer maxKPI = null;
    private Integer maxOther = null;

    public EventFilterGroup(String name) {
        this.m_name = name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public List<EventFilter> getFilters() {
        return this.m_filters;
    }

    @Override
    public void clear() {
        this.m_filters.clear();
    }

    public void addFilter(EventFilter filter) {
        if (filter != null) {
            for (int i = 0; i < this.m_filters.size(); ++i) {
                if (!this.m_filters.get(i).equals(filter)) continue;
                return;
            }
            this.m_filters.add(filter);
        }
    }

    public void addFilters(List<EventFilter> filterList) {
        if (filterList != null && filterList.size() > 0) {
            if (filterList.size() > 1) {
                this.m_filters.ensureCapacity(this.m_filters.size() + filterList.size());
            }
            for (int i = 0; i < filterList.size(); ++i) {
                this.addFilter(filterList.get(i));
            }
        }
    }

    public void setFilter(EventFilter filter, int position) {
        if (filter != null) {
            this.m_filters.set(position, filter);
        }
    }

    public void removeFilter(int position) {
        this.m_filters.remove(position);
    }

    public void removeFilter(EventFilter filter) {
        if (filter != null) {
            Iterator<EventFilter> it = this.m_filters.iterator();
            while (it.hasNext()) {
                EventFilter ef = it.next();
                if (!ef.toString().equals(filter.toString())) continue;
                it.remove();
                break;
            }
        }
    }

    public boolean isMatched(SEventFwd event) {
        if (this.m_filters.size() == 0) {
            return false;
        }
        boolean isMatched = true;
        for (int j = 0; j < this.m_filters.size(); ++j) {
            boolean bl = isMatched = isMatched && this.m_filters.get(j).select(event);
            if (!isMatched) break;
        }
        return isMatched;
    }

    public boolean hasFilter(EventFilter filter) {
        for (EventFilter ef : this.m_filters) {
            if (!ef.toString().equals(filter.toString())) continue;
            return true;
        }
        return false;
    }

    public void removeAllClosed() {
        Iterator it = this.m_values.keySet().iterator();
        while (it.hasNext()) {
            SEventFwd sef = (SEventFwd)it.next();
            if ('-' == sef.getState() && sef.getSeverityInt() >= 0) continue;
            it.remove();
            this.applyCounter(sef, -1);
            this.cleanMaxis();
        }
    }

    @Override
    public int getStatusAV() {
        if (this.maxAV == null) {
            this.maxAV = 0;
            Iterator<SEventFwd> it = this.iterator();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                if (sef.getTypeA() > 0) {
                    this.maxAV = Math.max(this.maxAV, sef.getSeverityInt());
                }
                if (5 != this.maxAV) continue;
                break;
            }
        }
        return this.maxAV;
    }

    @Override
    public int getStatusKPI() {
        if (this.maxKPI == null) {
            this.maxKPI = 0;
            Iterator<SEventFwd> it = this.iterator();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                if (sef.getTypeK() > 0) {
                    this.maxKPI = Math.max(this.maxKPI, sef.getSeverityInt());
                }
                if (5 != this.maxKPI) continue;
                break;
            }
        }
        return this.maxKPI;
    }

    @Override
    public int getStatusOther() {
        if (this.maxOther == null) {
            this.maxOther = 0;
            Iterator<SEventFwd> it = this.iterator();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                if (sef.getTypeK() == 0 && sef.getTypeA() == 0) {
                    this.maxOther = Math.max(this.maxOther, sef.getSeverityInt());
                }
                if (5 != this.maxOther) continue;
                break;
            }
        }
        return this.maxOther;
    }

    public void cleanMaxis() {
        this.maxAV = null;
        this.maxKPI = null;
        this.maxOther = null;
    }

    public Collection<String> getImpactedAgents() {
        HashSet<String> set = new HashSet<String>();
        Iterator<SEventFwd> it = this.iterator();
        while (it.hasNext()) {
            String agentID = it.next().getT1();
            if (agentID == null || agentID.length() <= 0) continue;
            set.add(agentID);
        }
        return set;
    }

    @Override
    public EventsAndStatus getEvents() {
        return this;
    }

    @Override
    public void invalidateStatus() {
    }

    @Override
    public boolean containsOneOf(Collection<SEventFwd> col) {
        for (SEventFwd se : col) {
            if (!this.isMatched(se)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventFilterGroup) {
            EventFilterGroup second = (EventFilterGroup)obj;
            if (this.getName().equals(second.getName()) && this.m_filters.size() == second.m_filters.size()) {
                return this.m_filters.containsAll(second.m_filters);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.m_name == null) {
            return 0;
        }
        return this.m_name.hashCode();
    }

    @Override
    public boolean add(SEventFwd event) {
        boolean added = super.add(event);
        if (added) {
            this.cleanMaxis();
        }
        return added;
    }

    @Override
    public boolean remove(SEventFwd o) {
        boolean removed = super.remove(o);
        if (removed) {
            this.cleanMaxis();
        }
        return removed;
    }
}

