/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.shared.SEventFwd;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class CheckAgentCardsConflicts {
    public static int doCheck() {
        int removed = 0;
        HashMap<String, String> ids = new HashMap<String, String>();
        HashMap<String, String> hoip = new HashMap<String, String>();
        for (Map.Entry<String, AgentCard> en : ServerEngine.getInstance().getAgentRepository().getAgentCards().entrySet()) {
            if (en.getValue().getAgentPort() == 0) continue;
            String id = en.getKey();
            StringBuffer sb = new StringBuffer();
            sb.append(en.getValue().getAgentHost()).append('|').append(en.getValue().getAgentIP());
            String hoipStr = sb.toString();
            if (hoip.containsKey(hoipStr)) {
                ids.put(id, hoipStr);
                String firstID = (String)hoip.get(hoipStr);
                ids.put(firstID, hoipStr);
                continue;
            }
            hoip.put(hoipStr, id);
        }
        hoip.clear();
        hoip = null;
        if (ids.size() > 0) {
            for (SEventFwd sef : ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false)) {
                ids.remove(sef.getT1());
                if (ids.size() != 0) continue;
                break;
            }
        }
        if (ids.size() > 0) {
            for (SEventFwd sef : ServerEngine.getInstance().getEventsRouter().getEventOperations().getAcknowledgedIndications(false)) {
                ids.remove(sef.getT1());
                if (ids.size() != 0) continue;
                break;
            }
        }
        if (ids.size() > 0) {
            for (String agentid : ids.keySet()) {
                RTLogger.print(2, "Server will delete discovered fantom AgentCard: " + agentid);
                ServerEngine.getInstance().getAgentRepository().deleteAgent(agentid);
                ++removed;
            }
        }
        return removed;
    }

    public static int doMerge(String oldAgentId, String newAgentID) {
        int merged = 0;
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(newAgentID, false);
        String agentHost = null;
        if (ac != null) {
            agentHost = ac.getAgentHost();
        }
        LinkedList<SEventFwd> updated = new LinkedList<SEventFwd>();
        for (SEventFwd sef : ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false)) {
            if (!sef.getT1().equals(oldAgentId)) continue;
            sef.setT1(newAgentID);
            if (agentHost != null) {
                sef.setAgentNode(agentHost);
            }
            updated.add(sef);
        }
        for (SEventFwd sef : ServerEngine.getInstance().getEventsRouter().getEventOperations().getAcknowledgedIndications(false)) {
            if (!sef.getT1().equals(oldAgentId)) continue;
            sef.setT1(newAgentID);
            if (agentHost != null) {
                sef.setAgentNode(agentHost);
            }
            updated.add(sef);
        }
        if (RTLogger.getCurrentLevel() >= 3) {
            StringBuffer sb = new StringBuffer();
            sb.append("Merged ").append(updated.size()).append(" indications to the AgentCard ID:").append(newAgentID);
            RTLogger.print(3, sb.toString());
        }
        merged = updated.size();
        ServerEngine.getInstance().getEventsRouter().getEventOperations().updateEvents(updated, false);
        return merged;
    }
}

