/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.AgentCard;
import com.blixx.server.DeploymentManager;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.ServerEngine;
import com.blixx.server.correlation.AgentOutageManager;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.Interval;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class MaintenanceTask
extends SchedulerTask {
    public long m_lastModTime = 0L;
    public File m_binaries = null;
    public long m_timeProcessing = 0L;
    public int m_pendingTaskLastCheck = 0;

    public MaintenanceTask(String TaskName, File binDir) {
        super(TaskName);
        this.setInterval(Interval.getSimpleInterval(60));
        this.m_binaries = binDir;
    }

    @Override
    public boolean onGetData() {
        long start = System.currentTimeMillis();
        this.setInterval(Interval.getSimpleInterval(10));
        this.checkBinaryTree();
        long delta = System.currentTimeMillis() - start;
        if (delta > 1000L) {
            RTLogger.print(4, "MaintenanceTask check BT ms= " + delta);
        }
        start = System.currentTimeMillis();
        this.checkFirewalledAgents();
        delta = System.currentTimeMillis() - start;
        if (delta > 100L) {
            RTLogger.print(4, "checkFirewalledAgents check BT ms= " + delta);
        }
        start = System.currentTimeMillis();
        ServerEngine.getInstance().getAgentRepository().checkPending();
        delta = System.currentTimeMillis() - start;
        if (delta > 100L) {
            RTLogger.print(4, "AR.checkPending check BT ms= " + delta);
        }
        start = System.currentTimeMillis();
        try {
            ServerEngine.getInstance().getEventsRouter().getEventOperations().cleanProcessedAKeys(true);
        }
        catch (Exception e) {
            RTLogger.print(5, "EO.cleanProcessedAKeys error", e);
        }
        delta = System.currentTimeMillis() - start;
        if (delta > 100L) {
            RTLogger.print(4, "EO.cleanProcessedAKeys check BT ms= " + delta);
        }
        start = System.currentTimeMillis();
        try {
            ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().cleanProcessedAKeys(true);
        }
        catch (Throwable e) {
            RTLogger.print(5, "EOO.cleanProcessedAKeys error", e);
        }
        delta = System.currentTimeMillis() - start;
        if (delta > 100L) {
            RTLogger.print(4, "EOO.cleanProcessedAKeys check BT ms= " + delta);
        }
        start = System.currentTimeMillis();
        this.checkAgentOutages();
        delta = System.currentTimeMillis() - start;
        if (delta > 100L) {
            RTLogger.print(4, "CheckAgentOutages check ms= " + delta);
        }
        start = System.currentTimeMillis();
        DeploymentManager.getInstance().cleanOld();
        delta = System.currentTimeMillis() - start;
        if (delta > 100L) {
            RTLogger.print(4, "DM.cleanOld check BT ms= " + delta);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFirewalledAgents() {
        Map<String, AgentCard> m = ServerEngine.getInstance().getAgentRepository().getAgentCards();
        Iterator<Map.Entry<String, AgentCard>> it = m.entrySet().iterator();
        int pendingUpdates = 0;
        int pendingDeployments = 0;
        while (it.hasNext()) {
            Map.Entry<String, AgentCard> en = it.next();
            AgentCard ac = en.getValue();
            if (ac.getAgentPort() == 0) continue;
            if (ac.getMode() >= 7 && ac.getMode() < 9 && ac.getMode() == 8 && ac.getAgentPort() != -1 && ac.needsToBeChecked()) {
                ac.setMode(7);
            }
            pendingDeployments += ac.getDeploymentQueue().size();
            if (ac.pendingUpdates()) {
                Map<IRemoteProcessing, Long> map = ac.m_pending;
                synchronized (map) {
                    pendingUpdates += ac.m_pending.size();
                    Iterator<Map.Entry<IRemoteProcessing, Long>> itp = ac.getPendingMap_Unsynchronized().entrySet().iterator();
                    while (itp.hasNext()) {
                        Map.Entry<IRemoteProcessing, Long> en1 = itp.next();
                        IRemoteProcessing obj = en1.getKey();
                        boolean isExpired = obj.isExpired();
                        if (!isExpired) continue;
                        try {
                            itp.remove();
                            --pendingUpdates;
                        }
                        catch (Throwable e) {
                            RTLogger.print(5, "Cancel Pending Task failed: ", e);
                        }
                    }
                }
            }
            if (!ac.isPendingDeployments4Firewalled()) continue;
            DeploymentManager.getInstance().checkExpiredDeployments(ac);
        }
        if (pendingUpdates > 0 && this.m_pendingTaskLastCheck != pendingUpdates) {
            RTLogger.print(4, "Total pending Tasks: " + pendingUpdates + " Deployments: " + pendingDeployments);
            this.m_pendingTaskLastCheck = pendingUpdates;
        }
    }

    protected void checkAgentOutages() {
        try {
            AgentOutageManager aom = ServerEngine.getInstance().getEventsRouter().getAgentOutageMgr();
            ArrayList<String> agentIds = new ArrayList<String>(aom.getAllPolicies().keySet());
            agentIds.forEach(aom::renewAgentOutageFlag);
            Map<String, AgentCard> m = ServerEngine.getInstance().getAgentRepository().getAgentCards();
            m.values().stream().filter(AgentCard::isLocalAgent).filter(AbstractAgentCard::getAgentOutage).map(AbstractAgentCard::getAgentID).forEach(aom::renewAgentOutageFlag);
        }
        catch (Exception e) {
            RTLogger.print(5, "checkAgentOutages error", e);
        }
    }

    protected void checkBinaryTree() {
        if (this.m_lastModTime == 0L) {
            this.m_lastModTime = this.getLMD(this.m_binaries, 0L);
        } else {
            long nt = this.getLMD(this.m_binaries, this.m_lastModTime);
            if (nt > this.m_lastModTime) {
                ServerEngine.getInstance().getBinariesRepository().getXmlFile(true);
            }
        }
    }

    public long getLMD(File f, long max) {
        if (f.isDirectory()) {
            max = Math.max(max, f.lastModified());
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                max = this.getLMD(files[i], max);
            }
        } else {
            return Math.max(max, f.lastModified());
        }
        return max;
    }

    @Override
    public boolean onInit() throws Exception {
        ServerEngine.getInstance().getBinariesRepository();
        this.m_binaries = new File("./srv/packages");
        return true;
    }

    @Override
    public boolean onStartRun() {
        this.m_timeProcessing = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean onStopRun() {
        long time = System.currentTimeMillis() - this.m_timeProcessing;
        if (time > 1000L) {
            RTLogger.print(5, "BT refresh time:" + time);
        }
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }

    @Override
    protected int getPriority() {
        return 1;
    }
}

