/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.db.DB;
import com.blixx.shared.SEventFwd;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerfDBMonitor
extends SchedulerTask {
    DB m_db = null;

    public PerfDBMonitor(String TaskName, DB db) {
        super(TaskName);
        this.m_db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        if (!this.m_db.m_isOraclePERF) {
            String sql = "SHOW TABLE STATUS FROM " + ServerEngine.getInstance().getDB().getPerfDBname();
            try {
                long maxPerfTblSize = ServerEngine.getInstance().getServerProps().getMaxPerfTblSize();
                List<Map<String, Object>> l = this.m_db.queryPerf2(sql);
                for (HashMap hashMap : l) {
                    try {
                        long size = Long.parseLong(String.valueOf(hashMap.get("Data_length")));
                        String name = String.valueOf(hashMap.get("Name"));
                        if ((size /= 0x100000L) <= maxPerfTblSize) continue;
                        SEventFwd se = SMessage.createMessage(4, 0, "", "BOOM Server", "PERFDB", "Size of the table for performance class '" + name + "' reached max size: " + maxPerfTblSize + "MB (SIZE=" + size + "MB)");
                        se.setKey("PERFDB:" + name + ":SIZE");
                        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(se);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                ServerProperties.testLic(this);
            }
        } else {
            RTLogger.print(1, "");
        }
        return true;
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        RTLogger.print(5, "PerfDBMonitor Started");
        return true;
    }

    @Override
    public boolean onStopRun() {
        RTLogger.print(5, "PerfDBMonitor Stoped");
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

