/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.utils;

import com.blixx.log.RTLogger;
import com.blixx.sa.VirtualSocket;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class VirtualSocketServer
extends VirtualSocket {
    protected HttpServletResponse m_response = null;

    public VirtualSocketServer(String sessionid) {
        super(sessionid);
    }

    public void setHttpResponse(HttpServletResponse response) {
        this.m_response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendResponseNow() throws IOException {
        try {
            if (this.m_response != null) {
                ByteArrayOutputStream bos;
                this.m_response.setStatus(200);
                this.m_response.setContentType(MIME_DEFAULT_BINARY);
                this.m_response.setHeader("BOOMAGENTSESSIONID", this.m_sockID);
                if (this.getOs().getOutputStream() instanceof ByteArrayOutputStream) {
                    bos = (ByteArrayOutputStream)this.getOs().getOutputStream();
                    byte[] tosend = bos.toByteArray();
                    this.m_response.setContentLength(tosend.length);
                    this.m_response.setBufferSize(tosend.length);
                    this.m_response.getOutputStream().write(tosend, 0, tosend.length);
                }
                this.m_response.flushBuffer();
                this.getOs().detachOutputStream();
                this.getIs().detachInputSteam();
                bos = this.m_response;
                synchronized (bos) {
                    this.m_response.notifyAll();
                }
            } else {
                throw new IOException("HTTPResponse not set!");
            }
            this.m_response = null;
            RTLogger.print(5, "Session sendRequest: " + this.m_sockID);
        }
        catch (Throwable e) {
            RTLogger.print(3, "", e);
        }
    }

    @Override
    public boolean isSendResponseOnCloseState() {
        return this.m_response != null;
    }
}

