/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.IID;
import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractAgentCard
implements IODataStream,
IID {
    public static final int FLAG_MASK_FFF0 = 65520;
    public static final int MODE_MASK_000F = 15;
    public static final int FLAG_OUTAGE = 16;
    public static final int FLAG_HTTP = 32;
    public static final int FLAG_TLS = 64;
    public static final int FLAG_HTTPS = 128;
    public static final int FLAG_WS = 256;
    public static final int FLAG_WSS = 512;
    public static final int FLAG_NONE = 0;
    public static final String GETHASH_SPI_DIR = "GETHASH=spi";
    public static int FIREWALLED_AGENT_PING_EXPIRATION = 60000;
    public static final String CONNECTING = "Connecting...";
    public static final String CSR_PENDING = "CSR pending...";
    public static final String PORT = "PORT";
    public static final String LABEL = "LABEL";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String MODE = "MODE";
    public static final String IP = "IP";
    public static final String ID = "ID";
    public static final String HOSTNAME = "HOSTNAME";
    public static final String OS = "OS";
    public static final String APPROVED = "APPROVED";
    public static final String DISABLED = "DISABLED";
    protected String m_hostname = null;
    protected String m_hostIP = null;
    protected String m_agentID = null;
    protected String m_desc = "";
    protected String m_label = null;
    protected String m_os = "Connecting...";
    protected String m_server = null;
    protected AtomicInteger mode = new AtomicInteger(0);
    protected int m_agentFlags = 0;
    protected int default_mode = 0;
    protected boolean m_approved = true;
    protected boolean m_disabled = false;
    protected int m_port = 23021;

    public int getMode() {
        return this.mode.get();
    }

    public boolean isOnline() {
        switch (this.mode.get()) {
            case 3: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public int getDefaultMode() {
        return this.default_mode;
    }

    public void setDefaultMode(int defailtMode) {
        this.default_mode = defailtMode;
    }

    public int getDefaultModeCombinedWithFlags() {
        return this.getDefaultMode() | this.m_agentFlags;
    }

    public int getAgentPort() {
        return this.m_port;
    }

    public void setAgentPort(int port) {
        this.m_port = port;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getOSName() {
        return this.m_os;
    }

    public void setDescription(String descr) {
        if (descr == null) {
            descr = "";
        }
        this.m_desc = descr;
    }

    public void setLabel(String label) {
        if (label == null) {
            label = "";
        }
        this.m_label = label;
    }

    public void setOSName(String osname) {
        if (osname == null) {
            osname = "";
        }
        this.m_os = osname.intern();
    }

    public String getRelatedServer() {
        return this.m_server;
    }

    public void setRelatedServer(String bserver) {
        this.m_server = bserver == null || bserver.length() == 0 ? null : bserver.intern();
    }

    public boolean isApproved() {
        return this.m_approved;
    }

    public void setApproved() {
        this.m_approved = true;
    }

    public void setUnApproved() {
        this.m_approved = false;
    }

    public int getAgentFlags() {
        return this.m_agentFlags;
    }

    public void setAgentFlags(int agentFlags) {
        this.m_agentFlags = agentFlags;
    }

    public void setSingleFlagON(int agentFlag) {
        this.m_agentFlags |= agentFlag;
    }

    public void setSingleFlagOFF(int agentFlag) {
        this.m_agentFlags &= ~agentFlag;
    }

    public void setSingleFlagToggle(int agentFlag) {
        this.m_agentFlags ^= agentFlag;
    }

    public boolean getAgentOutage() {
        return (this.m_agentFlags & 0x10) == 16;
    }

    public void setAgentOutage(boolean flag) {
        if (flag) {
            this.setSingleFlagON(16);
        } else {
            this.setSingleFlagOFF(16);
        }
    }

    @Override
    public String getID() {
        return this.getAgentID();
    }

    public String getAgentIP() {
        return this.m_hostIP;
    }

    public void setNewAgentIP(String newIP) {
        if (newIP != null) {
            this.m_hostIP = newIP.intern();
        }
    }

    public void setNewAgentHost(String newHost) {
        if (newHost != null) {
            this.m_hostname = newHost.intern();
        }
    }

    public String getAgentHost() {
        return this.m_hostname;
    }

    public String getAgentID() {
        return this.m_agentID;
    }

    public boolean isHttpAgent() {
        return (this.m_agentFlags & 0x20) == 32;
    }

    public boolean isTlsAgent() {
        return (this.m_agentFlags & 0x40) == 64;
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    public boolean setDisabled(boolean disable) {
        boolean isChange = this.m_disabled != disable;
        this.m_disabled = disable;
        return isChange;
    }

    public void setMode(int modeStatus) {
        this.mode.set(modeStatus);
    }

    public boolean isFirewalled() {
        return this.getMode() >= 7;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAgentCard) {
            AbstractAgentCard ac = (AbstractAgentCard)obj;
            return this.m_agentID.equals(ac.m_agentID);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.m_agentID == null) {
            return super.hashCode();
        }
        return this.m_agentID.hashCode();
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        int combinedMode = dis.readInt();
        this.mode.set(combinedMode & 0xF);
        this.m_agentFlags = combinedMode & 0xFFF0;
        this.m_agentID = dis.readUTF();
        this.m_desc = dis.readUTF();
        this.m_hostIP = dis.readUTF().intern();
        String host = dis.readUTF();
        int split = host.lastIndexOf(58);
        if (split != -1) {
            this.m_hostname = host.substring(0, split).intern();
            String port = host.substring(split + 1);
            try {
                this.m_port = Integer.parseInt(port);
            }
            catch (Throwable throwable) {}
        } else {
            this.m_hostname = host.intern();
        }
        this.m_label = dis.readUTF().intern();
        this.m_os = dis.readUTF().intern();
        this.m_approved = dis.readBoolean();
        this.m_disabled = dis.readBoolean();
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeInt(this.mode.get() | this.m_agentFlags);
        dos.writeUTF(this.m_agentID);
        dos.writeUTF(this.m_desc);
        dos.writeUTF(this.m_hostIP);
        String host_port = this.m_hostname + ':' + this.m_port;
        dos.writeUTF(host_port);
        dos.writeUTF(this.m_label);
        dos.writeUTF(this.m_os);
        dos.writeBoolean(this.m_approved);
        dos.writeBoolean(this.m_disabled);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Hostname=").append(this.m_hostname).append(' ');
        res.append("IP=").append(this.m_hostIP).append(' ');
        res.append("Mode=").append(this.getMode()).append(' ');
        res.append("OS=").append(this.m_os).append(' ');
        res.append("Label=").append(this.m_label).append("");
        return res.toString();
    }

    public static Set<String> getAllHostnames(AbstractAgentCard ac) {
        String agentHost;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (ac != null && (agentHost = ac.getAgentHost()) != null && agentHost.length() > 0) {
            String[] arr;
            for (String host : arr = agentHost.split("\\|")) {
                names.add(host);
            }
        }
        return names;
    }

    public static Set<String> getAllIPs(AbstractAgentCard ac) {
        String ip;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (ac != null && (ip = ac.getAgentIP()) != null && ip.length() > 0) {
            String[] arr;
            for (String host : arr = ip.split("\\|")) {
                names.add(host);
            }
        }
        return names;
    }
}

