/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractConditions;
import com.blixx.shared.Condition;
import com.blixx.shared.exceptions.ConfigException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class Conditions
extends AbstractConditions<Condition> {
    public static Conditions getInstance(Properties conditionGroup, boolean resetType, List<Properties> properties) throws ConfigException {
        Conditions cs = new Conditions();
        try {
            cs.uuid = UUID.fromString(conditionGroup.getProperty("CONDITION_ID"));
        }
        catch (RuntimeException e) {
            throw new ConfigException("UUID incorrect");
        }
        cs.description = conditionGroup.getProperty("DESCRIPTION");
        if (cs.description == null) {
            cs.description = "";
        }
        for (int i = 0; i < properties.size(); ++i) {
            Properties pr = properties.get(i);
            try {
                Condition c = Condition.getInstance(pr, resetType);
                cs.addCondition(c);
                continue;
            }
            catch (RuntimeException e) {
                cs.getFailedConditions().add(pr);
                RTLogger.print(1, "failed condition. Error: " + e.getMessage());
                RTLogger.print(2, "", e);
            }
        }
        return cs;
    }

    @Override
    public Condition addNewCondition() {
        Condition c = Condition.getNew(this.getConditionCount());
        this.addCondition(c);
        return c;
    }
}

