/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.IEnv;
import com.blixx.shared.Interval;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatchTimeout;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.Severity;
import com.blixx.shared.SupportedVariablesS;
import com.blixx.shared.exceptions.ConfigException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class MsgCondition
extends AbstractCondition
implements Cloneable {
    public static final String GROUP_SNMP = "SNMP";
    public static final String APPL_SNMPTRAPD = "SNMPTrapd";
    protected String severity = null;
    protected String application = null;
    protected String text = null;
    protected String msggrp = null;
    protected String node = null;
    protected String set_severity = null;
    protected boolean expected = true;
    protected boolean isStopEvaluation = false;
    protected int suppress_interval = 0;
    protected int suppress_count = 0;
    private PatternB m_filter_text = null;
    private PatternMatchResult m_filter_text_PMR = null;
    private PatternB m_filter_node = null;
    private PatternMatchResult m_filter_node_PMR = null;
    private PatternB m_filter_group = null;
    private PatternMatchResult m_filter_group_PMR = null;
    private PatternB m_filter_app = null;
    private PatternMatchResult m_filter_app_PMR = null;
    private PatternMatchResult m_filter_obj_PMR = null;
    private PatternB m_filter_sev = null;
    private Boolean m_isMatchALL = null;
    protected String vfilterAsInPolicy = null;
    protected String vfilterString = null;
    private PatternB[] vfilters = null;
    private PatternMatchResult vfilter_PMR = null;
    protected boolean m_evilPatternDetected = false;
    protected boolean isSNMPcondition = false;

    public static MsgCondition getInstance(Properties prop, int supptime, int suppcount) throws ConfigException {
        String negation;
        int res;
        MsgCondition c = new MsgCondition();
        c.initFrom(prop);
        c.severity = (String)prop.get("SEVERITY");
        c.severity = c.severity == null || c.severity.length() == 0 ? "<*>".intern() : c.severity.intern();
        c.application = (String)prop.get("APPLICATION");
        c.application = c.application == null || c.application.length() == 0 ? "<*>".intern() : c.application.intern();
        c.text = (String)prop.get("TEXT");
        if (c.text == null || "<*>".equals(c.text)) {
            c.text = "<*>".intern();
        }
        c.msggrp = (String)prop.get("MSGGRP");
        c.msggrp = c.msggrp == null || c.msggrp.length() == 0 ? "<*>".intern() : c.msggrp.intern();
        c.node = (String)prop.get("NODE");
        c.node = c.node == null || c.node.length() == 0 ? "<*>".intern() : c.node.intern();
        c.set_text = prop.getProperty("SET_TEXT", "").trim();
        c.suppress_interval = supptime;
        String suppressInterval = (String)prop.get("SUPP_TIME");
        c.suppress_interval = suppressInterval == null ? 0 : ((res = Interval.parseInterval(suppressInterval, 0).getIntervalSeconds()) > 0 ? res : 0);
        c.suppress_count = suppcount;
        String suppressCount = (String)prop.get("SUPP_COUNT");
        if (suppressCount == null) {
            c.suppress_count = 0;
        } else {
            try {
                int res2 = Integer.parseInt(suppressCount);
                c.suppress_count = res2 > 0 ? res2 : 0;
            }
            catch (NumberFormatException e) {
                c.suppress_count = 0;
            }
        }
        if (c.suppress_interval < 0) {
            c.suppress_interval = 0;
        }
        c.set_severity = (String)prop.get("SET_SEVERITY");
        if (c.set_severity != null) {
            c.set_severity = c.set_severity.trim();
            if (c.set_severity.length() == 0 || c.set_severity.equals("<*>")) {
                c.set_severity = null;
            } else {
                int sint = Severity.getSeverity(c.set_severity);
                if (sint == 0 && !"unknown".equalsIgnoreCase(c.set_severity)) {
                    c.set_severity = null;
                }
            }
        }
        if (c.actionType.equalsIgnoreCase("STOP")) {
            c.isStopEvaluation = true;
        }
        if ((negation = (String)prop.get("NEGATION")) != null) {
            c.expected = !Boolean.parseBoolean(negation);
        }
        c.vfilterAsInPolicy = prop.getProperty("VFILTER");
        if (c.vfilterAsInPolicy != null) {
            c.vfilterAsInPolicy = c.vfilterAsInPolicy.intern();
        }
        c.initVFilters();
        c.initFilter();
        if (GROUP_SNMP.equals(c.msggrp) && APPL_SNMPTRAPD.equals(c.application)) {
            c.isSNMPcondition = true;
        }
        return c;
    }

    public void initVFilters() {
        if (this.vfilterAsInPolicy != null && this.vfilterAsInPolicy.length() > 0) {
            try {
                String[] aa = this.vfilterAsInPolicy.split("\\s+");
                if (aa.length > 1) {
                    this.vfilterString = aa[0];
                    String vfpattern = this.vfilterAsInPolicy.substring(aa[0].length()).trim();
                    String[] arrayPb = vfpattern.split("\u2663");
                    this.vfilters = new PatternB[arrayPb.length];
                    for (int i = 0; i < this.vfilters.length; ++i) {
                        this.vfilters[i] = PatternB.getPattern(arrayPb[i]);
                    }
                }
            }
            catch (Throwable e) {
                RTLogger.print(4, "Incorrect VFILTER: " + this.vfilterAsInPolicy);
            }
        }
    }

    public void initFilter() throws ConfigException {
        try {
            this.m_filter_node = this.checkPipe(this.node) ? PatternB.getPattern("[" + this.node + "]") : PatternB.getPattern(this.node);
            this.m_filter_group = this.checkPipe(this.msggrp) ? PatternB.getPattern("[" + this.msggrp + "]") : PatternB.getPattern(this.msggrp);
            this.m_filter_app = this.checkPipe(this.application) ? PatternB.getPattern("[" + this.application + "]") : PatternB.getPattern(this.application);
            this.m_filter_obj = this.checkPipe(this.object) ? PatternB.getPattern("[" + this.object + "]") : PatternB.getPattern(this.object);
            this.m_filter_sev = this.checkPipe(this.severity) ? PatternB.getPattern("[" + this.severity + "]") : PatternB.getPattern(this.severity);
            this.m_filter_text = PatternB.getPattern(this.text);
        }
        catch (ConfigException e) {
            RTLogger.print(2, "ID:" + this.condition_id + " condition:" + this.description + " error. " + e.getMessage());
            throw e;
        }
    }

    public boolean isMatchALL() {
        if (this.m_isMatchALL == null) {
            this.m_isMatchALL = this.isFilterAll(this.m_filter_text.getJavaPattern()) && this.isFilterAll(this.m_filter_node.getJavaPattern()) && this.isFilterAll(this.m_filter_group.getJavaPattern()) && this.isFilterAll(this.m_filter_app.getJavaPattern()) && this.isFilterAll(this.m_filter_obj.getJavaPattern()) && this.isFilterAll(this.m_filter_sev.getJavaPattern()) && (this.vfilters == null || this.vfilters.length == 0) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.m_isMatchALL;
    }

    private boolean isFilterAll(String javaPattern) {
        return javaPattern.equals("(?:.*)") || javaPattern.equals("(?:.*?)") || javaPattern.equals(".*");
    }

    public boolean isMatch(String text, String node, String group, String application, String object, String severity) {
        boolean isMatch = false;
        this.m_filter_obj_PMR = null;
        this.m_filter_text_PMR = null;
        this.m_filter_app_PMR = null;
        this.m_filter_group_PMR = null;
        this.m_filter_node_PMR = null;
        boolean isSNMPMatch = this.isSNMPcondition() && GROUP_SNMP.equals(group) && APPL_SNMPTRAPD.equals(application);
        this.m_filter_obj_PMR = PatternMatcherThread.match(this.m_filter_obj, object);
        if (this.m_filter_obj_PMR == null) {
            throw new PatternMatchTimeout(this.m_filter_obj.getOvPattern(), object, PatternMatchTimeout.OTHER);
        }
        if (this.m_filter_obj_PMR.isMatch()) {
            this.m_filter_text_PMR = PatternMatcherThread.match(this.m_filter_text, text);
            if (this.m_filter_text_PMR == null) {
                throw new PatternMatchTimeout(this.m_filter_text.getOvPattern(), text, PatternMatchTimeout.TEXT);
            }
            if (this.m_filter_text_PMR.isMatch()) {
                PatternMatchResult patternMatchResult = this.m_filter_app_PMR = isSNMPMatch ? PatternMatchResult.TRUE : PatternMatcherThread.match(this.m_filter_app, application);
                if (this.m_filter_app_PMR == null) {
                    throw new PatternMatchTimeout(this.m_filter_app.getOvPattern(), application, PatternMatchTimeout.OTHER);
                }
                if (this.m_filter_app_PMR.isMatch()) {
                    PatternMatchResult patternMatchResult2 = this.m_filter_group_PMR = isSNMPMatch ? PatternMatchResult.TRUE : PatternMatcherThread.match(this.m_filter_group, group);
                    if (this.m_filter_group_PMR == null) {
                        throw new PatternMatchTimeout(this.m_filter_group.getOvPattern(), group, PatternMatchTimeout.OTHER);
                    }
                    if (this.m_filter_group_PMR.isMatch()) {
                        this.m_filter_node_PMR = PatternMatcherThread.match(this.m_filter_node, node);
                        if (this.m_filter_node_PMR == null) {
                            throw new PatternMatchTimeout(this.m_filter_node.getOvPattern(), node, PatternMatchTimeout.OTHER);
                        }
                        if (this.m_filter_node_PMR.isMatch()) {
                            PatternMatchResult sevPMR;
                            PatternMatchResult patternMatchResult3 = sevPMR = isSNMPMatch ? PatternMatchResult.TRUE : PatternMatcherThread.match(this.m_filter_sev, severity);
                            if (sevPMR == null) {
                                throw new PatternMatchTimeout(this.m_filter_sev.getOvPattern(), severity, PatternMatchTimeout.OTHER);
                            }
                            if (sevPMR.isMatch()) {
                                isMatch = true;
                            }
                        }
                    }
                }
            }
        }
        return isMatch;
    }

    public boolean isVFilterMatch(String prepared, IEnv env) {
        if (this.vfilters == null || this.vfilters.length == 0 || this.vfilterString == null) {
            return true;
        }
        HashMap<String, String> tempVars = new HashMap<String, String>();
        String[] preparedParts = prepared.split(Character.toString('\u2663'), this.vfilters.length);
        if (preparedParts.length != this.vfilters.length) {
            return false;
        }
        for (int i = 0; i < this.vfilters.length; ++i) {
            PatternB p = this.vfilters[i];
            this.vfilter_PMR = PatternMatcherThread.match(p, preparedParts[i]);
            if (this.vfilter_PMR == null) {
                throw new PatternMatchTimeout(p.getOvPattern(), prepared, PatternMatchTimeout.VFILTER);
            }
            if (!this.vfilter_PMR.isMatch()) {
                return false;
            }
            MsgCondition.lookup(this.vfilter_PMR.getVariableMap(), env);
            tempVars.putAll(this.vfilter_PMR.getVariableMap());
            if (this.vfilter_PMR.getVariableMap().size() <= 0) continue;
            for (int j = i + 1; j < preparedParts.length; ++j) {
                preparedParts[j] = SupportedVariablesS.replaceOptVars(preparedParts[j], tempVars);
            }
        }
        this.vfilter_PMR.getVariableMap().putAll(tempVars);
        return this.vfilter_PMR.isMatch();
    }

    public boolean isVFilterHasVariables() {
        return this.vfilter_PMR.getVariableMap().size() > 0;
    }

    public Map<String, String> getVFilterVariables() {
        return this.vfilter_PMR.getVariableMap();
    }

    public boolean isVfilterActive() {
        return this.vfilters != null && this.vfilters.length > 0;
    }

    public String getVfilterAsInPolicy() {
        return this.vfilterAsInPolicy;
    }

    public boolean isTextPatternHasVariables() {
        return this.isOtherHasVariables() || this.m_filter_text_PMR.getVariableMap().size() > 0;
    }

    public Map<String, String> getVariables() {
        if (this.isOtherHasVariables()) {
            this.m_filter_text_PMR.putVariables(this.getOtherVariables());
        }
        return this.m_filter_text_PMR.getVariableMap();
    }

    public boolean isOtherHasVariables() {
        return this.getOtherVariables().size() > 0;
    }

    @Override
    public boolean isOverrideNode() {
        return this.set_node != null && this.set_node.length() > 0;
    }

    @Override
    public boolean isOverrideObject() {
        return this.set_object != null && this.set_object.length() > 0;
    }

    @Override
    public boolean isOverrideApplication() {
        return this.set_application != null && this.set_application.length() > 0;
    }

    @Override
    public boolean isOverrideGroup() {
        return this.set_msggrp != null && this.set_msggrp.length() > 0;
    }

    public Map<String, String> getOtherVariables() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.m_filter_node_PMR != null) {
            map.putAll(this.m_filter_node_PMR.getVariableMap());
        }
        if (this.m_filter_group_PMR != null) {
            map.putAll(this.m_filter_group_PMR.getVariableMap());
        }
        if (this.m_filter_app_PMR != null) {
            map.putAll(this.m_filter_app_PMR.getVariableMap());
        }
        if (this.m_filter_obj_PMR != null) {
            map.putAll(this.m_filter_obj_PMR.getVariableMap());
        }
        return map;
    }

    @Override
    public Properties getProperties() {
        Properties p = super.getProperties();
        p.setProperty("SEVERITY", this.severity);
        p.setProperty("APPLICATION", this.application);
        p.setProperty("TEXT", this.text);
        p.setProperty("MSGGRP", this.msggrp);
        p.setProperty("NODE", this.node);
        p.setProperty("MSGKEY", this.msgkey);
        p.setProperty("NEGATION", "" + !this.expected);
        p.setProperty("SET_SEVERITY", this.set_severity == null ? "" : this.set_severity);
        p.setProperty("SET_TEXT", this.set_text == null ? "" : this.set_text);
        p.setProperty("SET_MSGGRP", this.set_msggrp == null ? "" : this.set_msggrp);
        if (this.suppress_interval > 0) {
            p.setProperty("SUPP_TIME", this.suppress_interval / 60 + "m");
        } else {
            p.setProperty("SUPP_TIME", "0");
        }
        p.setProperty("SUPP_COUNT", "" + this.suppress_count);
        if (this.vfilterAsInPolicy != null) {
            p.setProperty("VFILTER", this.vfilterAsInPolicy);
        }
        this.putCustomAttributes(p);
        return p;
    }

    public HashSet<String> getAMKey() {
        HashSet<String> n = new HashSet<String>();
        LinkedList<String> aplist = new LinkedList<String>();
        String aa = this.application;
        if (aa.indexOf(60) != -1) {
            aplist.add("<*>");
        } else if (aa.indexOf(124) != -1) {
            aa = this.cleanSpecials(aa);
            String[] arr = aa.split("\\Q|\\E");
            for (int i = 0; i < arr.length; ++i) {
                aplist.add(arr[i].trim());
            }
        } else {
            aa = this.cleanSpecials(aa);
            aplist.add(aa);
        }
        LinkedList<String> mglist = new LinkedList<String>();
        String mm = this.msggrp;
        if (mm.indexOf(60) != -1) {
            mglist.add("<*>");
        } else if (mm.indexOf(124) != -1) {
            mm = this.cleanSpecials(mm);
            String[] arr = mm.split("\\Q|\\E");
            for (int i = 0; i < arr.length; ++i) {
                mglist.add(arr[i].trim());
            }
        } else {
            mm = this.cleanSpecials(mm);
            mglist.add(mm);
        }
        for (int i = 0; i < aplist.size(); ++i) {
            String appl = (String)aplist.get(i);
            for (int j = 0; j < mglist.size(); ++j) {
                String msggr = (String)mglist.get(j);
                n.add(appl + "@@" + msggr);
            }
        }
        return n;
    }

    public String cleanSpecials(String str) {
        if (str.startsWith("<")) {
            str = str.substring(1);
        }
        if (str.startsWith("[")) {
            str = str.substring(1);
        }
        if (str.endsWith(">")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.endsWith("]")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getAsSourceString(String policy_name) {
        StringBuilder sb = new StringBuilder();
        sb.append("Message:").append(policy_name).append(':').append(this.condition_id);
        return sb.toString();
    }

    public MsgCondition clone() {
        MsgCondition cn = null;
        Properties nP = this.getProperties();
        nP.setProperty("CONDITION_ID", UUID.randomUUID().toString());
        nP.setProperty("HELPTEXT_ID", UUID.randomUUID().toString());
        try {
            cn = MsgCondition.getInstance(nP, this.suppress_interval, this.suppress_count);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cn;
    }

    public static MsgCondition getNew(int number) {
        MsgCondition cn = new MsgCondition();
        cn.msgkey = "<$AGENT_HOST>:<$HOST>:<$APPLICATION>:<$GROUP>:<$OBJECT>:<$SEVERITY>";
        cn.ackkey = "<$AGENT_HOST>:<$HOST>:<$APPLICATION>:<$GROUP>:<$OBJECT>:<*>";
        cn.application = "<*>".intern();
        cn.description = "Condition " + number;
        cn.actionType = "".intern();
        cn.m_filter_node = new PatternB("<*>");
        cn.m_filter_app = new PatternB("<*>");
        cn.m_filter_group = new PatternB("<*>");
        cn.m_filter_obj = new PatternB("<*>");
        cn.m_filter_sev = new PatternB("<*>");
        cn.m_filter_text = new PatternB("<*>");
        cn.msggrp = "<*>".intern();
        cn.node = "<*>".intern();
        cn.set_severity = "".intern();
        cn.set_text = "".intern();
        cn.severity = "<*>".intern();
        cn.text = "<*>".intern();
        cn.suppress_interval = 0;
        cn.suppress_count = 0;
        cn.expected = true;
        cn.initCAs();
        return cn;
    }

    public String getSeverityFilter() {
        return this.severity;
    }

    public void setSeverityFilter(String severity) {
        this.severity = severity;
    }

    public String getTextFilter() {
        return this.text;
    }

    public void setTextFilter(String text) {
        this.text = text;
    }

    public String getGroupFilter() {
        return this.msggrp;
    }

    public void setGroupFilter(String msggrp) {
        this.msggrp = msggrp;
    }

    public String getNodeFilter() {
        return this.node;
    }

    public void setNodeFilter(String node) {
        this.node = node;
    }

    public String getSetSeverity() {
        return this.set_severity;
    }

    public void setSetSeverity(String setSeverity) {
        this.set_severity = setSeverity;
    }

    public int getSuppressInterval() {
        return this.suppress_interval;
    }

    public void setSuppressInterval(int suppressInterval) {
        this.suppress_interval = suppressInterval;
    }

    public int getSuppressCount() {
        return this.suppress_count;
    }

    public void setSuppressCount(int suppressCount) {
        this.suppress_count = suppressCount;
    }

    public String getVfilterString() {
        return this.vfilterString;
    }

    public void setVfilterString(String vfilterString) {
        this.vfilterString = vfilterString;
    }

    public PatternB[] getVfilters() {
        return this.vfilters;
    }

    public void setVfilters(PatternB[] vfilters) {
        this.vfilters = vfilters;
    }

    public PatternMatchResult getVfilterPMR() {
        return this.vfilter_PMR;
    }

    public void setVfilterAsInPolicy(String vfilterAsInPolicy) {
        this.vfilterAsInPolicy = vfilterAsInPolicy;
    }

    public String getApplicationFilter() {
        return this.application;
    }

    public void setApplicationFilter(String application) {
        this.application = application;
    }

    public boolean isEvilPatternDetected() {
        return this.m_evilPatternDetected;
    }

    public void setEvilPatternDetected(boolean evilPatternDetected) {
        this.m_evilPatternDetected = evilPatternDetected;
    }

    public boolean getExpected() {
        return this.expected;
    }

    public void setExpected(boolean expected) {
        this.expected = expected;
    }

    public boolean isStopEvaluation() {
        return this.isStopEvaluation;
    }

    public void setStopEvaluation(boolean isStopEvaluation) {
        this.isStopEvaluation = isStopEvaluation;
    }

    public boolean isSNMPcondition() {
        return this.isSNMPcondition;
    }
}

