/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.ByteHelper;
import com.blixx.shared.GeneralDigest;

public class SHA256Digest
extends GeneralDigest {
    private static final String ALGORITHM_NAME = "SHA-256";
    private static final int DIGEST_LENGTH = 32;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int h5;
    private int h6;
    private int h7;
    private int h8;
    private int[] x = new int[64];
    private int xOff;
    static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256Digest() {
        this.reset();
    }

    public SHA256Digest(SHA256Digest t) {
        super(t);
        this.copyIn(t);
    }

    private void copyIn(SHA256Digest t) {
        super.copyIn(t);
        this.h1 = t.h1;
        this.h2 = t.h2;
        this.h3 = t.h3;
        this.h4 = t.h4;
        this.h5 = t.h5;
        this.h6 = t.h6;
        this.h7 = t.h7;
        this.h8 = t.h8;
        System.arraycopy(t.x, 0, this.x, 0, t.x.length);
        this.xOff = t.xOff;
    }

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public int getDigestSize() {
        return 32;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        int n = in[inOff] << 24;
        n |= (in[++inOff] & 0xFF) << 16;
        n |= (in[++inOff] & 0xFF) << 8;
        this.x[this.xOff] = n |= in[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.x[14] = (int)(bitLength >>> 32);
        this.x[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        ByteHelper.intToBigEndian(this.h1, out, outOff);
        ByteHelper.intToBigEndian(this.h2, out, outOff + 4);
        ByteHelper.intToBigEndian(this.h3, out, outOff + 8);
        ByteHelper.intToBigEndian(this.h4, out, outOff + 12);
        ByteHelper.intToBigEndian(this.h5, out, outOff + 16);
        ByteHelper.intToBigEndian(this.h6, out, outOff + 20);
        ByteHelper.intToBigEndian(this.h7, out, outOff + 24);
        ByteHelper.intToBigEndian(this.h8, out, outOff + 28);
        this.reset();
        return 32;
    }

    public byte[] digest() {
        byte[] chunksHash = new byte[this.getDigestSize()];
        this.doFinal(chunksHash, 0);
        return chunksHash;
    }

    @Override
    public void reset() {
        super.reset();
        this.h1 = 1779033703;
        this.h2 = -1150833019;
        this.h3 = 1013904242;
        this.h4 = -1521486534;
        this.h5 = 1359893119;
        this.h6 = -1694144372;
        this.h7 = 528734635;
        this.h8 = 1541459225;
        this.xOff = 0;
        for (int i = 0; i != this.x.length; ++i) {
            this.x[i] = 0;
        }
    }

    @Override
    protected void processBlock() {
        int i;
        for (int t = 16; t <= 63; ++t) {
            this.x[t] = this.theta1(this.x[t - 2]) + this.x[t - 7] + this.theta0(this.x[t - 15]) + this.x[t - 16];
        }
        int a = this.h1;
        int b = this.h2;
        int c = this.h3;
        int d = this.h4;
        int e = this.h5;
        int f = this.h6;
        int g = this.h7;
        int h = this.h8;
        int t = 0;
        for (i = 0; i < 8; ++i) {
            d += (h += this.sum1(e) + this.ch(e, f, g) + K[t] + this.x[t]);
            h += this.sum0(a) + this.maj(a, b, c);
            c += (g += this.sum1(d) + this.ch(d, e, f) + K[++t] + this.x[t]);
            g += this.sum0(h) + this.maj(h, a, b);
            b += (f += this.sum1(c) + this.ch(c, d, e) + K[++t] + this.x[t]);
            f += this.sum0(g) + this.maj(g, h, a);
            a += (e += this.sum1(b) + this.ch(b, c, d) + K[++t] + this.x[t]);
            e += this.sum0(f) + this.maj(f, g, h);
            h += (d += this.sum1(a) + this.ch(a, b, c) + K[++t] + this.x[t]);
            d += this.sum0(e) + this.maj(e, f, g);
            g += (c += this.sum1(h) + this.ch(h, a, b) + K[++t] + this.x[t]);
            c += this.sum0(d) + this.maj(d, e, f);
            f += (b += this.sum1(g) + this.ch(g, h, a) + K[++t] + this.x[t]);
            b += this.sum0(c) + this.maj(c, d, e);
            e += (a += this.sum1(f) + this.ch(f, g, h) + K[++t] + this.x[t]);
            a += this.sum0(b) + this.maj(b, c, d);
            ++t;
        }
        this.h1 += a;
        this.h2 += b;
        this.h3 += c;
        this.h4 += d;
        this.h5 += e;
        this.h6 += f;
        this.h7 += g;
        this.h8 += h;
        this.xOff = 0;
        for (i = 0; i < 16; ++i) {
            this.x[i] = 0;
        }
    }

    private int ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private int maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private int sum0(int x) {
        return (x >>> 2 | x << 30) ^ (x >>> 13 | x << 19) ^ (x >>> 22 | x << 10);
    }

    private int sum1(int x) {
        return (x >>> 6 | x << 26) ^ (x >>> 11 | x << 21) ^ (x >>> 25 | x << 7);
    }

    private int theta0(int x) {
        return (x >>> 7 | x << 25) ^ (x >>> 18 | x << 14) ^ x >>> 3;
    }

    private int theta1(int x) {
        return (x >>> 17 | x << 15) ^ (x >>> 19 | x << 13) ^ x >>> 10;
    }

    public SHA256Digest copy() {
        return new SHA256Digest(this);
    }

    public void reset(SHA256Digest other) {
        this.copyIn(other);
    }
}

