/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;

public class SecureDocumentBuilderFactory {
    private static final Logger logger = new RTLogger(SecureDocumentBuilderFactory.class);
    private static final Set<String> failedAttributes = new HashSet<String>();
    private static final Set<String> failedFeatures = new HashSet<String>();

    private SecureDocumentBuilderFactory() {
    }

    public static DocumentBuilderFactory newInstance() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            SecureDocumentBuilderFactory.setFeature(dbf, "http://apache.org/xml/features/disallow-doctype-decl", true);
            SecureDocumentBuilderFactory.setFeature(dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            SecureDocumentBuilderFactory.setFeature(dbf, "http://xml.org/sax/features/external-general-entities", false);
            SecureDocumentBuilderFactory.setFeature(dbf, "http://xml.org/sax/features/external-parameter-entities", false);
            SecureDocumentBuilderFactory.setFeature(dbf, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SecureDocumentBuilderFactory.setAttribute(dbf, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            SecureDocumentBuilderFactory.setAttribute(dbf, "http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (Exception e) {
            logger.warn("XML DBF initialization warning", e);
        }
        return dbf;
    }

    private static void setFeature(DocumentBuilderFactory dbf, String name, boolean flag) {
        try {
            if (!failedFeatures.contains(name)) {
                dbf.setFeature(name, flag);
            }
        }
        catch (Exception e) {
            failedFeatures.add(name);
            logger.warn("XML DocumentBuilderFactory (warning) - can't set feature: {} : {}", (Object)name, (Object)e);
        }
    }

    private static void setAttribute(DocumentBuilderFactory dbf, String name, String value) {
        try {
            if (!failedAttributes.contains(name)) {
                dbf.setAttribute(name, value);
            }
        }
        catch (Exception e) {
            failedAttributes.add(name);
            logger.warn("XML DocumentBuilderFactory (warning) - can't set attribute: {} = {} : {}", name, value, e);
        }
    }
}

