/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.RTLogger;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FPolicyFactory
extends PolicyFactory {
    public ForwardPolicy loadForwardPolicy(File file) {
        ForwardPolicy pol = null;
        if (file.exists() && file.canRead()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                pol = this.initForwardPolicy(fileInputStream);
            }
            catch (Throwable e) {
                RTLogger.print(1, "Failed processing file: " + file.getName() + " " + e.getMessage());
                RTLogger.print(2, "", e);
            }
        }
        return pol;
    }

    private ForwardPolicy initForwardPolicy(InputStream io) throws SAXException, ParserConfigurationException, IOException {
        NodeList nlist;
        ForwardPolicy pol = null;
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        String separator = XMLFactory.getSeparator(doc);
        int version = XMLFactory.getVersion(doc);
        if (version == 1) {
            // empty if block
        }
        if ((nlist = doc.getElementsByTagName("FORWARD_MESSAGE")).getLength() != 1) {
            throw new ConfigException("Invalid FORWARD_MESSAGE policy");
        }
        Node item = nlist.item(0);
        Node cdata = XMLFactory.searchCDATA(item);
        if (cdata == null) {
            throw new ConfigException("Error: NO CDATA section found for:" + item.getNodeName());
        }
        String data = cdata.getNodeValue().trim();
        Properties mainProperties = XMLFactory.extractProperties(separator, data);
        mainProperties.setProperty("VERSION", "" + version);
        Document docMonitor = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Node newMon = docMonitor.importNode(item, true);
        docMonitor.appendChild(newMon);
        Properties conditionsProps = this.getConditionsProps(newMon, separator, docMonitor, "TARGETS");
        NodeList condList = docMonitor.getElementsByTagName("TARGET");
        ArrayList<Properties> listOfCondition = new ArrayList<Properties>(condList.getLength());
        for (int k = 0; k < condList.getLength(); ++k) {
            Node cdataCond = XMLFactory.searchCDATA(condList.item(k));
            String ddata = cdataCond.getNodeValue();
            Properties cprops = XMLFactory.extractProperties(separator, ddata);
            listOfCondition.add(cprops);
        }
        pol = new ForwardPolicy(separator, mainProperties, conditionsProps, listOfCondition);
        return pol;
    }

    public List<ForwardFilter> initFilters(File file) {
        List<ForwardFilter> res = new ArrayList<ForwardFilter>();
        if (file.exists() && file.canRead()) {
            try (FileInputStream io = new FileInputStream(file);){
                res = this.initFilters(io);
            }
            catch (Throwable e) {
                res = null;
                RTLogger.print(1, "Failed processing forward filters file: " + file.getName() + " " + e.getMessage());
                RTLogger.print(2, "", e);
            }
        }
        return res;
    }

    private List<ForwardFilter> initFilters(InputStream io) throws SAXException, ParserConfigurationException, IOException {
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        String separator = XMLFactory.getSeparator(doc);
        int version = XMLFactory.getVersion(doc);
        if (version == 1) {
            // empty if block
        }
        return this.parseFilters(doc, separator);
    }

    public List<ForwardFilter> parseFilters(Document doc, String separator) throws ParserConfigurationException {
        NodeList nlist = doc.getElementsByTagName("FORWARD_FILTERS");
        if (nlist.getLength() != 1) {
            throw new ConfigException("Invalid FORWARD_FILTERS file");
        }
        Node item = nlist.item(0);
        Document docMonitor = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Node newMon = docMonitor.importNode(item, true);
        docMonitor.appendChild(newMon);
        NodeList condList = docMonitor.getElementsByTagName("FILTER");
        ArrayList<ForwardFilter> listOfCondition = new ArrayList<ForwardFilter>(condList.getLength());
        for (int k = 0; k < condList.getLength(); ++k) {
            Node cdataCond = XMLFactory.searchCDATA(condList.item(k));
            String ddata = cdataCond.getNodeValue();
            Properties cprops = XMLFactory.extractProperties(separator, ddata);
            try {
                listOfCondition.add(ForwardFilter.getInstance(cprops));
                continue;
            }
            catch (RuntimeException e) {
                RTLogger.print(3, "Forward Filter init failed.", e);
            }
        }
        return listOfCondition;
    }

    public static Document createXMLver1(ForwardPolicy pol) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("POLICY");
            Element separator = doc.createElement("SEPARATOR");
            separator.setTextContent(pol.separator);
            root.appendChild(separator);
            Element version = doc.createElement("VERSION");
            version.setTextContent(pol.syntax);
            root.appendChild(version);
            Element mon = XMLFactory.getCDATA(doc, "FORWARD_MESSAGE", pol.getMainProperties(), pol.separator);
            Element cnds = XMLFactory.getCDATA(doc, "TARGETS", pol.getConditions().getProperties(), pol.separator);
            ArrayList<ForwardCondition> arr = pol.getConditions().getConditionList();
            for (int i = 0; i < arr.size(); ++i) {
                ForwardCondition c = arr.get(i);
                Element cel = XMLFactory.getCDATA(doc, "TARGET", c.getProperties(), pol.separator);
                cnds.appendChild(cel);
            }
            mon.appendChild(cnds);
            root.appendChild(mon);
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Failed creation of ForwardPolicy xml: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return doc;
    }

    public static Document createXMLver1(List<ForwardFilter> filters) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("ROOT_FF");
            Element separator = doc.createElement("SEPARATOR");
            String separator_def = "\u25ba";
            separator.setTextContent(separator_def);
            root.appendChild(separator);
            Element version = doc.createElement("VERSION");
            version.setTextContent("1");
            root.appendChild(version);
            Element mon = doc.createElement("FORWARD_FILTERS");
            for (int i = 0; i < filters.size(); ++i) {
                ForwardFilter c = filters.get(i);
                Element cel = XMLFactory.getCDATA(doc, "FILTER", c.getProperties(), separator_def);
                mon.appendChild(cel);
            }
            root.appendChild(mon);
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(2, "Failed creation of ForwardFilter xml.", e);
        }
        return doc;
    }

    public void storeForwardPolicy(ForwardPolicy p, File file) {
        Document doc = FPolicyFactory.createXMLver1(p);
        FPolicyFactory.writeXml(doc, file);
    }

    public void deleteForwardPolicy(ForwardPolicy p, File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public void storeFilters(List<ForwardFilter> filters, File file) {
        Document doc = FPolicyFactory.createXMLver1(filters);
        FPolicyFactory.writeXml(doc, file);
    }
}

