/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.LoggerMain;
import com.blixx.shared.ext.TimeMask;
import java.util.Calendar;
import org.slf4j.Logger;

public class TimeInterval {
    private static Logger logger = LoggerMain.getLogger(TimeInterval.class);
    private long firstStart = 0L;
    private long interval = Long.MAX_VALUE;
    private TimeMask timeMask = null;

    public TimeInterval(long firstStart, long interval, TimeMask tm) throws Exception {
        this.firstStart = firstStart;
        if (interval <= 0L) {
            throw new Exception("Invalid Interval");
        }
        if (interval <= 1000L) {
            throw new Exception("Invalid Interval (less than a second)");
        }
        this.interval = interval;
        this.timeMask = tm;
        if (this.timeMask != null) {
            long nextstart = this.timeMask.getNextTime();
            if (firstStart <= 0L) {
                this.firstStart = nextstart;
            }
        }
    }

    public TimeInterval(long firstStart, long interval) throws Exception {
        this(firstStart, interval, null);
    }

    public TimeInterval(long firstStart) throws Exception {
        this(firstStart, Long.MAX_VALUE, null);
    }

    public long getFirstStart() {
        return this.firstStart;
    }

    public TimeMask getTimeMask() {
        return this.timeMask;
    }

    public boolean isActive() {
        long time = System.currentTimeMillis();
        boolean isActive = this.isActive(time);
        return isActive;
    }

    public boolean isActive(long time) {
        boolean isActive = false;
        try {
            if (time < this.firstStart) {
                isActive = false;
            } else if (time >= this.firstStart && (this.interval == Long.MAX_VALUE || time < this.firstStart + this.interval && this.timeMask == null)) {
                isActive = true;
            } else if (this.timeMask != null) {
                this.timeMask.setTime(time - this.interval - 1000L);
                long start = this.timeMask.getNextTime();
                Calendar calStart = Calendar.getInstance();
                calStart.setTimeInMillis(start);
                long prevStart1 = this.timeMask.getPreviousTimeFrom(start, 1);
                Calendar calPrev1 = Calendar.getInstance();
                calPrev1.setTimeInMillis(prevStart1);
                boolean isPrevInDST = this.timeMask.getTimeZone().inDaylightTime(calPrev1.getTime());
                boolean isActualInDST = this.timeMask.getTimeZone().inDaylightTime(calStart.getTime());
                long switchTimeIntervalCorrection = -1L;
                if (isPrevInDST && !isActualInDST) {
                    Calendar endOfInterval = Calendar.getInstance();
                    endOfInterval.setTimeInMillis(prevStart1 + this.interval);
                    switchTimeIntervalCorrection = !this.timeMask.getTimeZone().inDaylightTime(endOfInterval.getTime()) ? 3600000L : 0L;
                } else if (!isPrevInDST && isActualInDST) {
                    Calendar endOfInterval = Calendar.getInstance();
                    endOfInterval.setTimeInMillis(prevStart1 + this.interval);
                    switchTimeIntervalCorrection = this.timeMask.getTimeZone().inDaylightTime(endOfInterval.getTime()) ? -3600000L : 0L;
                }
                if (this.interval < Long.MAX_VALUE && switchTimeIntervalCorrection != -1L && time < prevStart1 + this.interval + switchTimeIntervalCorrection) {
                    this.timeMask.setTime(prevStart1 - this.interval);
                    isActive = true;
                } else if (time >= start && (this.interval == Long.MAX_VALUE || time < start + this.interval)) {
                    isActive = true;
                }
            }
        }
        catch (Exception e) {
            logger.trace("", e);
        }
        return isActive;
    }

    public boolean isScheduled() {
        boolean isSch = false;
        if (this.timeMask != null) {
            try {
                this.timeMask.getNextTime();
                isSch = true;
            }
            catch (Exception e) {
                logger.trace("", e);
            }
        }
        return isSch;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getCurrentStart() {
        return this.getCurrentStart(System.currentTimeMillis());
    }

    public long getCurrentStart(long now) {
        if (this.firstStart > 0L && now < this.firstStart) {
            return this.firstStart;
        }
        if (now >= this.firstStart && now < this.firstStart + this.interval) {
            return this.firstStart;
        }
        if (this.isScheduled()) {
            if (this.isActive(now)) {
                this.timeMask.setTime(now - this.interval + 1L);
            } else {
                this.timeMask.setTime(now);
            }
            long res = -1L;
            try {
                res = this.timeMask.getNextTime();
            }
            catch (Exception e) {
                logger.trace("", e);
            }
            return res;
        }
        return -1L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstStart ^ this.firstStart >>> 32);
        result = 31 * result + (int)(this.interval ^ this.interval >>> 32);
        result = 31 * result + (this.timeMask == null ? 0 : this.timeMask.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        if (this.firstStart != other.firstStart) {
            return false;
        }
        if (this.interval != other.interval) {
            return false;
        }
        return !(this.timeMask == null ? other.timeMask != null : !this.timeMask.equals(other.timeMask));
    }
}

