/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class Pipe
implements Runnable {
    BufferedInputStream pi = null;
    BufferedOutputStream po = null;
    boolean m_print = false;
    String name = "";
    AtomicBoolean finished = new AtomicBoolean(false);
    boolean m_skipCR;

    public Pipe(boolean skipCR, String name, InputStream from, OutputStream to, boolean print) {
        this.pi = new BufferedInputStream(from);
        this.po = new BufferedOutputStream(to);
        this.m_print = print;
        this.name = name;
        this.m_skipCR = skipCR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[512];
        try {
            int bytes_read;
            while ((bytes_read = this.pi.read(buffer)) != -1) {
                if (this.m_skipCR) {
                    for (int i = 0; i < bytes_read; ++i) {
                        if (buffer[i] == 13) continue;
                        this.po.write(buffer[i]);
                    }
                } else {
                    this.po.write(buffer, 0, bytes_read);
                }
                if (this.pi.available() <= 0) {
                    this.po.flush();
                }
                if (!this.m_print) continue;
                System.out.print(this.name);
                System.out.print(new String(buffer, 0, bytes_read));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                this.pi.close();
            }
            catch (Throwable throwable) {}
            try {
                this.po.close();
            }
            catch (Throwable throwable) {}
            this.finished.set(true);
        }
    }

    public boolean isClosed() {
        return this.finished.get();
    }
}

