/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.TextAttribute;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JobConfig {
    public static final String CLASS = "class";
    public static final String ACTIVE = "active";
    public static final String DESCRIPTION = "jobDescription";
    public static final String SCHEDULING = "scheduling";
    public static final String JOBNAME = "jobname";
    public static final String LOGLEVEL = "loglevel";
    public static final String LOGCOUNT = "logcount";
    public static final String LOGSIZE = "logsize";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String JOB = "JOB";
    public static final String CONFIG = "CONFIG";
    private Document m_doc = null;
    private Group m_config = null;
    private int m_loglevel = 0;
    private int m_logcount = 3;
    private int m_logsize = 10;

    public JobConfig() {
        try {
            this.m_doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.m_config = new Group(CONFIG);
            this.setJobName("New Job " + System.currentTimeMillis());
            this.setSchedulingInterval("1h");
            this.setActive(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void loadXML(File file) throws Exception {
        this.m_doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        Element root = this.m_doc.getDocumentElement();
        this.m_config = new Group();
        this.m_config.parse(root);
        this.validate();
    }

    private void validate() throws InvalidConfig {
        TextAttribute logsize;
        TextAttribute logcount;
        if (this.m_config == null || this.getJobName() == null || this.getActive() == null || this.getSchedulingInterval() == null || this.getClass() == null) {
            throw new InvalidConfig("Invalid job configuration");
        }
        TextAttribute loglevel = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, LOGLEVEL});
        if (loglevel != null) {
            try {
                this.m_loglevel = Integer.parseInt(loglevel.getValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((logcount = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, LOGCOUNT})) != null) {
            try {
                this.m_logcount = Integer.parseInt(logcount.getValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((logsize = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, LOGSIZE})) != null) {
            try {
                this.m_logsize = Integer.parseInt(logsize.getValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void loadXML(InputStream io) throws Exception {
        this.m_doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        Element root = this.m_doc.getDocumentElement();
        this.m_config = new Group();
        this.m_config.parse(root);
        this.validate();
    }

    public boolean storeXML(File file) {
        try {
            this.m_doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.m_config.addToXML(this.m_doc);
        return XMLFactory.writeXml(this.m_doc, file);
    }

    public void storeXML(OutputStream os) throws Exception {
        try {
            this.m_doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.m_config.addToXML(this.m_doc);
        XMLFactory.writeXml(this.m_doc, os);
    }

    public Group getConfig() {
        return this.m_config;
    }

    public void setConfig(Group config) throws InvalidConfig {
        if (config == null) {
            throw new InvalidConfig("null CONFIG is not allowed");
        }
        this.m_config = config;
    }

    public Group getJobGroup() {
        Group job = this.m_config.getGroup(JOB);
        job = this.ensureJobGroup(job);
        return job;
    }

    public String getJobName() {
        if (this.m_config == null) {
            return null;
        }
        TextAttribute jnameAttr = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, JOBNAME});
        if (jnameAttr == null) {
            return null;
        }
        return jnameAttr.getValue();
    }

    public void setJobName(String jobname) {
        Group job = this.m_config.getGroup(JOB);
        job = this.ensureJobGroup(job);
        job.addAttribute(new TextAttribute(JOBNAME, jobname, "Job Name"));
    }

    public String getSchedulingInterval() {
        if (this.m_config == null) {
            return null;
        }
        TextAttribute intervalAttr = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, SCHEDULING});
        if (intervalAttr == null) {
            return null;
        }
        return intervalAttr.getValue();
    }

    public void setSchedulingInterval(String timeOrInterval) {
        Group job = this.m_config.getGroup(JOB);
        job = this.ensureJobGroup(job);
        job.addAttribute(new TextAttribute(SCHEDULING, timeOrInterval, "Interval"));
    }

    public Boolean getActive() {
        if (this.m_config == null) {
            return null;
        }
        CheckAttribute intervalAttr = (CheckAttribute)this.m_config.getAttributeByPath(new String[]{JOB, ACTIVE});
        if (intervalAttr == null) {
            return null;
        }
        return intervalAttr.getValue();
    }

    @Deprecated
    public void setActive(Boolean isactive) {
        Group job = this.m_config.getGroup(JOB);
        job = this.ensureJobGroup(job);
        job.addAttribute(new CheckAttribute(ACTIVE, isactive, "Active"));
    }

    public String getJobDescription() {
        if (this.m_config == null) {
            return null;
        }
        TextAttribute descr = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, DESCRIPTION});
        if (descr == null) {
            return null;
        }
        return descr.getValue();
    }

    public void setJobDescription(String text) {
        Group job = this.m_config.getGroup(JOB);
        job = this.ensureJobGroup(job);
        job.addAttribute(new TextAttribute(DESCRIPTION, text, "Description"));
    }

    public String getClassName() {
        if (this.m_config == null) {
            return null;
        }
        TextAttribute classAttr = (TextAttribute)this.m_config.getAttributeByPath(new String[]{JOB, CLASS});
        if (classAttr == null) {
            return null;
        }
        return classAttr.getValue();
    }

    public void setClassName(String className) {
        Group job = this.m_config.getGroup(JOB);
        job = this.ensureJobGroup(job);
        job.addAttribute(new TextAttribute(CLASS, className, "Class"));
    }

    private Group ensureJobGroup(Group job) {
        if (job == null) {
            job = new Group(JOB);
            this.m_config.addGroup(job);
        }
        return job;
    }

    public int getLoglevel() {
        return this.m_loglevel;
    }

    public int getLogcount() {
        return this.m_logcount;
    }

    public int getLogsize() {
        return this.m_logsize;
    }
}

