/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.notify;

import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.notify.NotifierStatus;
import com.blixx.shared.utils.StrUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class NovelConfig
implements IODataStream {
    public static final String EXPIRE_INTERVAL = "expire.interval";
    public static final String RETRY_INTERVAL = "retry.interval";
    public static final String EXPIRE_FILE_SIZE = "expired.fileSize";
    public static final String QUEUE_SIZE = "queue.size";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String SUBJECT = "subject";
    public static final String MESSAGE = "message";
    public static final String START = "start";
    public static final String ISHTML = "ishtml";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_SMTP_USER = "mail.smtp.user";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_SMTP_PASSWORD_ENCRYPTED = "mail.smtp.password.encrypted";
    public static final String EXEC_NEWLINE_REPLACE_STRING = "exec.newlineReplaceString";
    public static final String CONF_DESCRIPTION = "config.descr";
    public static final String PROPERTIES_EXT = "properties";
    public static final long DEFAULT_EXPIRE_INTERVAL_MS = 1800000L;
    public static final long DEFAULT_RETRY_INTERVAL_MS = 60000L;
    public static final long DEFAULT_EXPIRED_FILESIZE = 0xA00000L;
    public static final int DEFAULT_QUEUE_LIMIT = 500;
    public static String DEFAULT_EXEC_NEWLINE_REPLACE_STRING = "\\n";
    private Properties properties = new Properties();
    private NovelCgfType type;
    private String id;
    private NotifierStatus notifierStatus = new NotifierStatus();

    public NotifierStatus getNotifierStatus() {
        return this.notifierStatus;
    }

    public void setNotifierStatus(NotifierStatus ns) {
        this.notifierStatus = ns;
    }

    public NovelConfig() {
        this.id = "noID";
    }

    public NovelConfig(Properties properties, NovelCgfType type, String id) {
        if (properties == null) {
            properties = new Properties();
        }
        this.properties = properties;
        this.type = type;
        this.id = id;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        if (this.properties.containsKey(CONF_DESCRIPTION)) {
            return this.properties.getProperty(CONF_DESCRIPTION);
        }
        return null;
    }

    public void setDescription(String descr) {
        this.properties.setProperty(CONF_DESCRIPTION, descr == null ? "" : descr);
    }

    public boolean getStartFlag() {
        return Boolean.parseBoolean(this.properties.getProperty(START));
    }

    public void setStartFlag(boolean start) {
        this.properties.setProperty(START, "" + start);
        if (this.notifierStatus != null) {
            this.notifierStatus.setStarted(start);
        }
    }

    public String getTo() {
        if (this.properties.containsKey(TO)) {
            return this.properties.getProperty(TO);
        }
        return null;
    }

    public void setTo(String to) {
        this.properties.setProperty(TO, to == null ? "" : to);
    }

    public String getFrom() {
        if (this.properties.containsKey(FROM)) {
            return this.properties.getProperty(FROM);
        }
        return null;
    }

    public void setFrom(String from) {
        this.properties.setProperty(FROM, from == null ? "" : from);
    }

    public String getSubject() {
        if (this.properties.containsKey(SUBJECT)) {
            return this.properties.getProperty(SUBJECT);
        }
        return null;
    }

    public void setSubject(String subject) {
        this.properties.setProperty(SUBJECT, subject == null ? "" : subject);
    }

    public String getMessage() {
        if (this.properties.containsKey(MESSAGE)) {
            return this.properties.getProperty(MESSAGE);
        }
        return null;
    }

    public void setMessage(String message) {
        this.properties.setProperty(MESSAGE, message == null ? "" : message);
    }

    public String getNewlineReplaceStr() {
        if (this.properties.containsKey(EXEC_NEWLINE_REPLACE_STRING)) {
            return this.properties.getProperty(EXEC_NEWLINE_REPLACE_STRING);
        }
        return null;
    }

    public void setNewlineReplaceStr(String replaceString) {
        this.properties.setProperty(EXEC_NEWLINE_REPLACE_STRING, replaceString == null ? "" : replaceString);
    }

    public NovelCgfType getType() {
        return this.type;
    }

    public void setType(NovelCgfType type) {
        this.type = type;
    }

    public long getExpireInterval() {
        long result = 1800000L;
        String prefValue = this.properties.getProperty(EXPIRE_INTERVAL);
        if (prefValue != null) {
            try {
                result = Long.parseLong(prefValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public long getExpireIntervalSeconds() {
        return this.getExpireInterval() / 1000L;
    }

    public void setExpireInterval(long maxExpireIntervalMs) {
        this.properties.setProperty(EXPIRE_INTERVAL, new Long(maxExpireIntervalMs).toString());
    }

    public void setExpireIntervalSeconds(long minutes) {
        this.setExpireInterval(minutes * 1000L);
    }

    public long getRetryInterval() {
        String prefValue;
        long result = 60000L;
        if (this.properties.containsKey(RETRY_INTERVAL) && (prefValue = this.properties.getProperty(RETRY_INTERVAL)) != null) {
            try {
                result = Long.parseLong(prefValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public long getRetryIntervalSeconds() {
        return this.getRetryInterval() / 1000L;
    }

    public void setRetryInterval(long maxRetryIntervalMs) {
        this.properties.setProperty(RETRY_INTERVAL, new Long(maxRetryIntervalMs).toString());
    }

    public void setRetryIntervalSeconds(long minutes) {
        this.setRetryInterval(minutes * 1000L);
    }

    public long getMaxExpiredFileSize() {
        long result = 0xA00000L;
        String prefValue = this.properties.getProperty(EXPIRE_FILE_SIZE);
        if (prefValue != null) {
            try {
                result = Long.parseLong(prefValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public void setMaxExpiredFileSize(long maxExpiredFileSizeBytes) {
        this.properties.setProperty(EXPIRE_FILE_SIZE, new Long(maxExpiredFileSizeBytes).toString());
    }

    public int getMaxQueueSize() {
        int result = 500;
        String prefValue = this.properties.getProperty(QUEUE_SIZE);
        if (prefValue != null) {
            try {
                result = Integer.parseInt(prefValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.properties.setProperty(QUEUE_SIZE, new Integer(maxQueueSize).toString());
    }

    public boolean isHTML() {
        String value = this.properties.getProperty(ISHTML);
        return value != null && value.equalsIgnoreCase("true");
    }

    public void setHTML(boolean isHTML) {
        this.properties.setProperty(ISHTML, "" + isHTML);
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.id = dis.readUTF();
        String typeStr = dis.readUTF();
        if (NovelCgfType.MAIL.text.equalsIgnoreCase(typeStr)) {
            this.type = NovelCgfType.MAIL;
        } else if (NovelCgfType.EXEC.text.equalsIgnoreCase(typeStr)) {
            this.type = NovelCgfType.EXEC;
        } else {
            throw new RuntimeException("unknown type");
        }
        int propSize = dis.readInt();
        for (int i = 0; i < propSize; ++i) {
            String key = dis.readUTF();
            String value = dis.readUTF();
            this.properties.setProperty(key, value);
        }
        this.notifierStatus = new NotifierStatus();
        this.notifierStatus.read(dis);
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.getId());
        dos.writeUTF(this.getType().getText());
        dos.writeInt(this.properties.size());
        for (Map.Entry<Object, Object> en : this.properties.entrySet()) {
            String key = (String)en.getKey();
            String value = (String)en.getValue();
            if (value == null) {
                value = "";
            }
            dos.writeUTF(key);
            dos.writeUTF(value);
        }
        this.getNotifierStatus().send(dos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void normalizeCfgProps(NovelConfig conf) {
        Properties props = conf.getProperties();
        NovelCgfType type = conf.getType();
        if (type.equals((Object)NovelCgfType.MAIL)) {
            if (!props.containsKey(MAIL_SMTP_AUTH)) return;
            boolean bl = Boolean.parseBoolean(props.get(MAIL_SMTP_AUTH).toString());
            boolean authFlag = bl;
            if (authFlag) return;
        }
        if (!type.equals((Object)NovelCgfType.EXEC)) return;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object val) {
        if (!(val instanceof NovelConfig)) {
            return false;
        }
        NovelConfig valConf = (NovelConfig)val;
        NovelConfig.normalizeCfgProps(this);
        NovelConfig.normalizeCfgProps(valConf);
        return this.properties.equals(valConf.getProperties()) && this.type == valConf.type && StrUtils.areStringEquals(this.id, valConf.id);
    }

    public static enum NovelCgfType {
        MAIL("Mail"),
        EXEC("EXEC");

        String text;

        public String getText() {
            return this.text;
        }

        private NovelCgfType(String text) {
            this.text = text;
        }
    }
}

