/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.pg;

import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.pg.ObjectType;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGItem
implements IODataStream {
    private static Pattern m_parse = Pattern.compile("(.)(\\w+):(\\w+):(.*)");
    protected PGEntityPermissionFlag m_permFlag = null;
    protected PGEntityAction m_action;
    protected ObjectType m_objectType;
    protected String m_path;
    protected String m_idOrName;

    public static PGItem parse(String uri) throws Exception {
        PGItem res = new PGItem();
        res.valueOf(uri);
        return res;
    }

    public void valueOf(String uri) throws Exception {
        Matcher m = m_parse.matcher(uri);
        if (m.matches()) {
            this.m_permFlag = PGEntityPermissionFlag.getEnum(m.group(1));
            this.m_action = PGEntityAction.valueOf(m.group(2));
            this.m_objectType = ObjectType.valueOf(m.group(3));
            String rest = m.group(4);
            if (rest.startsWith("//")) {
                this.m_path = rest.substring(1);
                if (this.m_path.endsWith("/")) {
                    this.m_path = this.m_path.substring(0, this.m_path.lastIndexOf(47));
                }
            } else {
                this.m_idOrName = rest;
            }
        } else {
            throw new Exception("Invalid URI: " + uri);
        }
    }

    PGItem() {
    }

    public PGItem(PGEntityPermissionFlag f, PGEntityAction a, ObjectType t, String path) {
        this.m_permFlag = f;
        this.m_action = a;
        this.m_objectType = t;
        this.m_path = path;
    }

    public PGItem(String nameOrID, PGEntityPermissionFlag f, PGEntityAction a, ObjectType t) {
        this.m_permFlag = f;
        this.m_action = a;
        this.m_objectType = t;
        this.m_idOrName = nameOrID;
    }

    public PGEntityPermissionFlag getPermFlag() {
        return this.m_permFlag;
    }

    public PGEntityAction getAction() {
        return this.m_action;
    }

    public ObjectType getObjectType() {
        return this.m_objectType;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String getIdOrName() {
        return this.m_idOrName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PGItem)) {
            return false;
        }
        PGItem pgi = (PGItem)obj;
        return this.m_objectType == pgi.m_objectType && this.m_action == pgi.m_action && this.m_permFlag == pgi.m_permFlag && (this.m_path == null ? pgi.m_path == null : this.m_path.equals(pgi.m_path)) && (this.m_idOrName == null ? pgi.m_idOrName == null : this.m_idOrName.equals(pgi.m_idOrName));
    }

    public int hashCode() {
        int hc = this.m_path == null ? 0 : this.m_path.hashCode();
        hc += this.m_idOrName == null ? 0 : this.m_idOrName.hashCode();
        return hc += this.m_objectType.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_permFlag.getChar());
        sb.append(this.m_action.name());
        sb.append(':');
        sb.append(this.m_objectType.name());
        sb.append(':');
        if (this.m_path != null) {
            sb.append('/').append(this.m_path);
        } else {
            sb.append(this.m_idOrName);
        }
        return sb.toString();
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        String str = dis.readUTF();
        try {
            this.valueOf(str);
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.setStackTrace(e.getStackTrace());
            throw ioException;
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.toString());
    }
}

