/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.space;

import com.blixx.log.RTLogger;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.IServiceStatus;
import com.blixx.shared.space.Connection;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.MaxService;
import com.blixx.shared.space.MinService;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class Node
implements Cloneable {
    public static String MAX_SERVICE = "max";
    public static String MIN_SERVICE = "min";
    protected String m_name = null;
    protected String m_type = null;
    protected double m_x = -1.0;
    protected double m_y = -1.0;
    protected double m_z = 0.0;
    protected String m_id = null;
    protected String m_imgURL;
    protected Map<Connection, Object> m_targets = new HashMap<Connection, Object>(2);
    protected Properties m_properties = new Properties();
    protected Object m_object = null;
    protected GCube m_cube = null;

    public String getImgURL() {
        return this.m_imgURL;
    }

    public void setImgURL(String imgURL) {
        this.m_imgURL = imgURL;
    }

    protected Node() {
        this.m_id = UUID.randomUUID().toString();
    }

    public Node(GCube cube, String id, double x, double y, double z, String name, String type) {
        this.m_cube = cube;
        this.m_id = id.intern();
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
        this.m_name = "";
        this.m_imgURL = "";
        if (name != null) {
            this.m_name = name.intern();
        }
        this.m_type = type.intern();
        if (MAX_SERVICE.equals(type)) {
            this.m_object = new MaxService(this);
        } else if (MIN_SERVICE.equals(type)) {
            this.m_object = new MinService(this);
        }
    }

    public void setObject(Object o) {
        this.m_object = o;
    }

    public Object getObject() {
        return this.m_object;
    }

    public Connection addTargetYplus(GCube gcube, String id, String subtype) {
        if (id == null || id.equals("")) {
            return null;
        }
        Connection connection = new Connection(this.getID(), id, "Y+", subtype);
        this.m_targets.put(connection, null);
        gcube.m_connections.put(connection.getID(), connection);
        return connection;
    }

    public Connection addTargetYminus(GCube gcube, String id, String subtype) {
        if (id == null || id.equals("")) {
            return null;
        }
        Connection connection = new Connection(this.getID(), id, "Y-", subtype);
        this.m_targets.put(connection, null);
        gcube.m_connections.put(connection.getID(), connection);
        return connection;
    }

    public Connection addTargetXplus(GCube gcube, String id, String subtype) {
        if (id == null || id.equals("")) {
            return null;
        }
        Connection connection = new Connection(this.getID(), id, "X+", subtype);
        this.m_targets.put(connection, null);
        gcube.m_connections.put(connection.getID(), connection);
        return connection;
    }

    public Connection addTargetXminus(GCube gcube, String id, String subtype) {
        if (id == null || id.equals("")) {
            return null;
        }
        Connection connection = new Connection(this.getID(), id, "X-", subtype);
        this.m_targets.put(connection, null);
        gcube.m_connections.put(connection.getID(), connection);
        return connection;
    }

    public Connection addTargetZplus(GCube gcube, String id, String subtype) {
        if (id == null || id.equals("")) {
            return null;
        }
        Connection connection = new Connection(this.getID(), id, "Z+", subtype);
        this.m_targets.put(connection, null);
        gcube.m_connections.put(connection.getID(), connection);
        return connection;
    }

    public Connection addTargetZminus(GCube gcube, String id, String subtype) {
        if (id == null || id.equals("")) {
            return null;
        }
        Connection connection = new Connection(this.getID(), id, "Z-", subtype);
        this.m_targets.put(connection, null);
        gcube.m_connections.put(connection.getID(), connection);
        return connection;
    }

    public Connection addTargetConnection(GCube gcube, String type, String id, String subtype, Properties connProperties) {
        Connection con = null;
        if (id == null || id.equals("")) {
            return null;
        }
        if (type.equals("Y+")) {
            con = this.addTargetYplus(gcube, id, subtype);
        } else if (type.equals("Y-")) {
            con = this.addTargetYminus(gcube, id, subtype);
        } else if (type.equals("X+")) {
            con = this.addTargetXplus(gcube, id, subtype);
        } else if (type.equals("X-")) {
            con = this.addTargetXminus(gcube, id, subtype);
        } else if (type.equals("Z+")) {
            con = this.addTargetZplus(gcube, id, subtype);
        } else if (type.equals("Z-")) {
            con = this.addTargetZminus(gcube, id, subtype);
        }
        if (connProperties != null && !connProperties.isEmpty()) {
            try {
                ForwardFilter ff = ForwardFilter.getInstance(connProperties);
                if (con != null) {
                    con.setFilter(ff);
                }
            }
            catch (Throwable e) {
                RTLogger.print(5, "", e);
            }
        }
        return con;
    }

    public String getID() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String m_name) {
        this.m_name = m_name;
    }

    public String getType() {
        if (this.m_type == null) {
            return "";
        }
        return this.m_type;
    }

    public double getx() {
        return this.m_x;
    }

    public void setx(double m_x) {
        this.m_x = m_x;
    }

    public double gety() {
        return this.m_y;
    }

    public void sety(double m_y) {
        this.m_y = m_y;
    }

    public double getz() {
        return this.m_z;
    }

    public void setz(double m_z) {
        this.m_z = m_z;
    }

    public Set<Connection> getTargets() {
        return this.m_targets.keySet();
    }

    public void removeConnection(Connection con) {
        this.m_targets.remove(con);
    }

    public void setTargets(Map targets) {
        this.m_targets.clear();
        this.m_targets.putAll(targets);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            Node n = (Node)obj;
            return this.getID().equals(n.getID()) && this.getType().equals(n.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public void setProperty(String key, String value) {
        this.m_properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void setProperties(Properties p) {
        this.m_properties = p;
    }

    public boolean isStatusAvailable() {
        return this.m_object instanceof IServiceStatus;
    }

    public int getAvailability() {
        int res = 0;
        try {
            if (this.m_object instanceof IServiceStatus) {
                res = ((IServiceStatus)this.m_object).getStatusAV();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public int getKPI() {
        int res = 0;
        try {
            if (this.m_object instanceof IServiceStatus) {
                res = ((IServiceStatus)this.m_object).getStatusKPI();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public int getOther() {
        int res = 0;
        try {
            if (this.m_object instanceof IServiceStatus) {
                res = ((IServiceStatus)this.m_object).getStatusOther();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public GCube getCube() {
        return this.m_cube;
    }

    public Node clone() throws CloneNotSupportedException {
        Node clone = new Node(null, this.m_id, this.m_x, this.m_y, this.m_z, this.m_name, this.m_type);
        clone.m_object = this.m_object;
        clone.m_properties = new Properties();
        clone.m_properties.putAll((Map<?, ?>)this.m_properties);
        clone.m_targets.putAll(this.m_targets);
        return clone;
    }
}

