/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapMap<E, K>
extends ConcurrentHashMap<E, Map<K, Object>> {
    private static final long serialVersionUID = 1L;

    public boolean containsValue(E key, K value) {
        Map<K, Object> al = this.getHashMap(key);
        if (al == null) {
            return false;
        }
        return al.containsKey(value);
    }

    public Map<K, Object> getHashMap(E key) {
        return (Map)this.get(key);
    }

    public Map<K, Object> putV(E key, K value) {
        Map<K, Object> list = this.getHashMap(key);
        if (list == null) {
            list = Collections.synchronizedMap(new HashMap());
        }
        if (!list.containsKey(value)) {
            list.put(value, null);
        }
        return super.put(key, list);
    }

    @Override
    public Map<K, Object> put(E key, Map<K, Object> values) {
        Map<K, Object> list = this.getHashMap(key);
        if (list == null) {
            list = Collections.synchronizedMap(new HashMap<K, Object>(values));
        } else {
            list.putAll(values);
        }
        return super.put(key, list);
    }

    public Map<K, Object> values(E key) {
        return this.getHashMap(key);
    }

    public Iterator<K> iterator(E key) {
        Map<K, Object> array = this.getHashMap(key);
        if (array == null) {
            array = Collections.synchronizedMap(new HashMap(0, 0.99f));
        }
        return array.keySet().iterator();
    }

    public void add(E key) {
        Map<K, Object> list = this.getHashMap(key);
        if (list == null) {
            list = Collections.synchronizedMap(new HashMap());
            super.put(key, list);
        }
    }

    public void removeFromAllMaps(Collection<K> list) {
        for (Map.Entry entry : this.entrySet()) {
            ((Map)entry.getValue()).keySet().removeAll(list);
        }
    }

    public void removeFromMap(E key, Collection<K> list) {
        Map<K, Object> array = this.getHashMap(key);
        if (array != null) {
            array.keySet().removeAll(list);
        }
    }

    public void retainFromAllMaps(Collection<K> list) {
        for (Map.Entry entry : this.entrySet()) {
            ((Map)entry.getValue()).keySet().retainAll(list);
        }
    }

    public void retainFromMap(E key, Collection<K> list) {
        Map<K, Object> array = this.getHashMap(key);
        if (array != null) {
            array.keySet().retainAll(list);
        }
    }

    public void clear(E key) {
        Map<K, Object> map = this.getHashMap(key);
        map.clear();
    }

    public boolean removeElement(E key, K value) {
        boolean res = false;
        Map map = (Map)this.get(key);
        if (map != null) {
            res = map.containsKey(value);
            map.remove(value);
        }
        return res;
    }
}

