/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.IID;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Diff<T extends IID> {
    public Map<T, T> updated = new HashMap<T, T>();
    public Map<String, T> newObjects = null;
    public Map<String, T> deletedObjects = null;
    private Comparator<T> comparator = null;

    public Diff(Collection<T> collectionNew, Collection<T> collectionOld, Comparator<T> comparator) {
        this(collectionNew, collectionOld);
        this.setComparator(comparator);
    }

    public Diff(Collection<T> collectionNew, Collection<T> collectionOld) {
        HashMap<String, IID> newIDs = new HashMap<String, IID>(collectionNew.size());
        for (Object en : collectionNew) {
            newIDs.put(en.getID(), (IID)en);
        }
        HashMap<String, IID> oldIDs = new HashMap<String, IID>(collectionOld.size());
        for (IID en : collectionOld) {
            oldIDs.put(en.getID(), en);
        }
        this.newObjects = new HashMap<String, T>(newIDs);
        this.newObjects.keySet().removeAll(oldIDs.keySet());
        this.deletedObjects = new HashMap<String, T>(oldIDs);
        this.deletedObjects.keySet().removeAll(newIDs.keySet());
        HashSet allIds = new HashSet();
        allIds.addAll(newIDs.keySet());
        allIds.addAll(oldIDs.keySet());
        allIds.removeAll(this.newObjects.keySet());
        allIds.removeAll(this.deletedObjects.keySet());
        for (String id : allIds) {
            IID oldObj = (IID)oldIDs.get(id);
            IID newObj = (IID)newIDs.get(id);
            if (!(this.comparator == null ? !newObj.equals(oldObj) : this.comparator.compare(newObj, oldObj) != 0)) continue;
            this.updated.put(newObj, oldObj);
        }
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }
}

