/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.DirFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FileUtils {
    public static String invalidFileNameChars_regex = "[\"/*?<>:\\\\|@',;!% =]+";

    private FileUtils() {
    }

    public static void copyFile(File source, File target) throws IOException {
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(target);){
            int count = -1;
            byte[] buffer = new byte[2048];
            while ((count = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
    }

    public static void appendFile(File source, File target) throws IOException {
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(target);){
            int count = -1;
            byte[] buffer = new byte[2048];
            while ((count = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
    }

    public static String resolveEnvVars(String in) {
        Set<String> keys = System.getenv().keySet();
        for (String key : keys) {
            String val = System.getenv(key);
            if (val == null) {
                val = "";
            }
            if (SystemUtils.OS == 1) {
                in = in.replace("%" + key + "%", val);
                continue;
            }
            in = in.replace("${" + key + "}", val);
            in = in.replace("$" + key, val);
        }
        return in;
    }

    public static void deleteDirectoryRecursive(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    String canonicalPath = file.getCanonicalPath();
                    if (file.isFile()) {
                        Files.deleteIfExists(file.toPath());
                        continue;
                    }
                    FileUtils.deleteDirectoryRecursive(canonicalPath);
                }
            }
            Files.deleteIfExists(dir.toPath());
        }
    }

    public static List<File> getPathsRecursive(String dirPath) throws IOException {
        LinkedList<File> toCollect = new LinkedList<File>();
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            toCollect.add(dir);
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        toCollect.add(file);
                        continue;
                    }
                    toCollect.addAll(FileUtils.getPathsRecursive(file.getCanonicalPath()));
                }
            }
        }
        return toCollect;
    }

    public static List<File> getPaths(String dirPath, boolean recursive, String reg) throws IOException {
        File dir;
        LinkedList<File> toCollect = new LinkedList<File>();
        DirFilter filter = null;
        if (reg != null && !reg.isEmpty()) {
            filter = new DirFilter(reg);
        }
        if ((dir = new File(dirPath)).exists()) {
            File[] files;
            File[] fileArray = files = filter == null ? dir.listFiles() : dir.listFiles(filter);
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        toCollect.add(file);
                        continue;
                    }
                    if (file.isFile() || !recursive) continue;
                    toCollect.addAll(FileUtils.getPaths(file.getCanonicalPath(), recursive, reg));
                }
            }
        }
        return toCollect;
    }

    public static long getFileCreationDate(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not found : " + file.getName());
        }
        BasicFileAttributes attr = Files.readAttributes(Paths.get(file.toURI()), BasicFileAttributes.class, new LinkOption[0]);
        FileTime fileTime = attr.creationTime();
        return fileTime.toMillis();
    }

    public static String getValidFileName(String name) {
        return name.replaceAll(invalidFileNameChars_regex, "_");
    }

    public static String readFile(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (FileReader fr = new FileReader(file);
             BufferedReader br = new BufferedReader(fr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
            }
        }
        return sb.toString();
    }

    public static List<String> readFileAsList(File file) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        try (FileReader fr = new FileReader(file);
             BufferedReader br = new BufferedReader(fr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static void writeFileAsList(File file, List<String> lines) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            for (String line : lines) {
                fos.write(line.getBytes());
                fos.write(10);
            }
            fos.flush();
        }
    }

    public static void writeFile(File file, String content) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            fos.write(content.getBytes());
            fos.flush();
        }
    }
}

